/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.mapping;

import de.statspez.pleditor.generator.runtime.mapping.MappingInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MappingFactory {
    public static final int RAW_TO_TB = 1;
    public static final int TB_TO_RAW = 2;
    public static final int DSB_TO_TB = 3;
    public static final int TB_TO_DSB = 4;
    private String plausiPackage = "de.statspez.plausi.generated";

    public void setPlausiPackage(String plausiPackage) {
        this.plausiPackage = plausiPackage;
    }

    public MappingInterface createMapping(String plTyp, int direction) {
        return this.createMapping(plTyp, direction, this.getClass().getClassLoader());
    }

    public MappingInterface createMapping(String plTyp, int direction, ClassLoader classLoader) {
        MappingInterface mappingObject = null;
        Class<?> mappingClass = null;
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = this.getClass().getClassLoader();
        }
        try {
            String className = this.plausiPackage + ".";
            switch (direction) {
                case 3: {
                    className = className + "DSB_TO_TB";
                    break;
                }
                case 4: {
                    className = className + "TB_TO_DSB";
                    break;
                }
                case 1: {
                    className = className + "RAW_TO_TB";
                    break;
                }
                case 2: {
                    className = className + "TB_TO_RAW";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal direction: " + direction);
                }
            }
            className = className + "_" + plTyp;
            mappingClass = Class.forName(className, true, classLoaderToUse);
            Constructor<?> mappingConst = mappingClass.getConstructor(null);
            if (mappingConst != null) {
                mappingObject = (MappingInterface)mappingConst.newInstance(null);
            }
        }
        catch (ClassNotFoundException ex) {
            String wert = System.getProperty("statspez.plgenerator.mapping.debug");
            if (wert != null && wert.equalsIgnoreCase("true")) {
                System.out.println("Class Not Found: " + ex.getMessage());
            }
        }
        catch (LinkageError ex) {
            System.out.println(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mappingObject;
    }
}

