/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.masken.ZahlMaske;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.StringValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import java.math.BigDecimal;

public class NumberValue
extends Value {
    private static final double PREC_NORM_UEBERLAUF_GRENZE = 0.5;
    private static final double PREC_NORM_UEBERLAUF_DEFAULT = 0.4999999999;
    private String myValueAsString = null;
    private Double myValue = null;
    private static final int radix = NumberValue.computeRadix();
    private static final double machinePrecision = NumberValue.computeMachinePrecision();
    private static final double defaultNumericalPrecision;
    private static final double precisionToUse;
    private static final int decimalPlaceToUse;

    public NumberValue(double value) {
        this.myValue = new Double(value);
    }

    public NumberValue(float value) {
        this.myValue = new Double(value);
    }

    public NumberValue(int value) {
        this.myValue = new Double(value);
    }

    public NumberValue(long value) {
        this.myValue = new Double(value);
    }

    public NumberValue(String value) {
        this.myValueAsString = value;
    }

    @Override
    public double asDouble() throws ValueConversionException {
        this.initializeValueIfNessesary();
        return this.myValue;
    }

    @Override
    public long asLong() throws ValueConversionException {
        this.initializeValueIfNessesary();
        return this.myValue.longValue();
    }

    @Override
    public boolean asBoolean() throws ValueConversionException {
        this.initializeValueIfNessesary();
        return this.asDouble() != 0.0;
    }

    @Override
    public String asString() throws ValueConversionException {
        String erg = null;
        if (this.myValueAsString != null) {
            erg = this.myValueAsString;
        } else {
            BigDecimal bigDecimal = new BigDecimal(this.asDouble()).setScale(NumberValue.getDecimalPlaceToUse(), 4);
            erg = bigDecimal.toPlainString();
            if (erg != null) {
                if ((erg = erg.trim()).length() > 3 && erg.indexOf(46) >= 0 && erg.endsWith("0")) {
                    boolean nullOnly = true;
                    int i = erg.length() - 1;
                    while (nullOnly && i > 0) {
                        if (erg.charAt(i) != '0') {
                            nullOnly = false;
                            if (erg.charAt(i) != '.') continue;
                            --i;
                            continue;
                        }
                        --i;
                    }
                    erg = erg.substring(0, i + 1);
                }
                erg = erg.replaceAll("\\.", ",");
            }
        }
        return erg;
    }

    public boolean isIntegerValueValid(String mask) {
        boolean valid;
        try {
            if (mask != null) {
                MaskenParserInterface parser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(1);
                ZahlMaske maske = (ZahlMaske)parser.parse(mask);
                valid = maske.isLaufzeitWertGueltig(this.asString());
            } else {
                this.asLong();
                valid = this.asString().indexOf(44) < 0;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public boolean isRealValueValid(String mask) {
        boolean valid;
        try {
            if (mask != null) {
                MaskenParserInterface parser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(4);
                ZahlMaske maske = (ZahlMaske)parser.parse(mask);
                valid = maske.isLaufzeitWertGueltig(this.asString());
            } else {
                this.asDouble();
                valid = true;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    @Override
    protected int operatorLevel() {
        return 3;
    }

    @Override
    protected boolean eqImpl(Value aValue) {
        boolean erg = false;
        double thisAsDouble = this.asDouble();
        try {
            double aValueAsDouble = this.getDoubleFromValue(aValue);
            erg = NumberValue.compare(thisAsDouble, aValueAsDouble) == 0;
        }
        catch (Exception ex) {
            erg = false;
        }
        return erg;
    }

    @Override
    protected boolean ltImpl(Value aValue) {
        double aValueAsDouble;
        boolean erg = false;
        double thisAsDouble = this.asDouble();
        erg = NumberValue.compare(thisAsDouble, aValueAsDouble = this.getDoubleFromValue(aValue)) < 0;
        return erg;
    }

    @Override
    protected boolean leImpl(Value aValue) {
        double aValueAsDouble;
        boolean erg = false;
        double thisAsDouble = this.asDouble();
        erg = NumberValue.compare(thisAsDouble, aValueAsDouble = this.getDoubleFromValue(aValue)) <= 0;
        return erg;
    }

    @Override
    protected boolean gtImpl(Value aValue) {
        double aValueAsDouble;
        boolean erg = false;
        double thisAsDouble = this.asDouble();
        erg = NumberValue.compare(thisAsDouble, aValueAsDouble = this.getDoubleFromValue(aValue)) > 0;
        return erg;
    }

    @Override
    protected boolean geImpl(Value aValue) {
        double aValueAsDouble;
        boolean erg = false;
        double thisAsDouble = this.asDouble();
        erg = NumberValue.compare(thisAsDouble, aValueAsDouble = this.getDoubleFromValue(aValue)) >= 0;
        return erg;
    }

    @Override
    protected boolean neImpl(Value aValue) {
        boolean erg = true;
        double thisAsDouble = this.asDouble();
        try {
            double aValueAsDouble = this.getDoubleFromValue(aValue);
            erg = NumberValue.compare(thisAsDouble, aValueAsDouble) != 0;
        }
        catch (Exception ex) {
            erg = true;
        }
        return erg;
    }

    @Override
    protected boolean containsImpl(Value aValue) {
        return this.eq(aValue);
    }

    private void initializeValueIfNessesary() {
        if (this.myValue == null) {
            try {
                String escapedValue = this.myValueAsString;
                if (escapedValue != null && escapedValue.length() > 0) {
                    if (escapedValue.startsWith("+")) {
                        escapedValue = escapedValue.substring(1);
                    }
                    if (escapedValue.endsWith(".")) {
                        throw new NumberFormatException("Punkt darf nicht am Ende stehen.");
                    }
                    String[] splitedValue = escapedValue.split("\\.");
                    if (splitedValue.length > 1) {
                        if (splitedValue[0].startsWith("-")) {
                            splitedValue[0] = splitedValue[0].substring(1);
                        }
                        for (int i = 0; i < splitedValue.length; ++i) {
                            if (i < splitedValue.length - 1) {
                                if (splitedValue[i].length() == 0 || splitedValue[i].length() > 3 || splitedValue[i].indexOf(",") >= 0) {
                                    throw new NumberFormatException("Punkt darf nur in 1000-er Schritten vorkommen.");
                                }
                                if (i <= 0 || splitedValue[i].length() >= 3) continue;
                                throw new NumberFormatException("Punkt darf nur in 1000-er Schritten vorkommen.");
                            }
                            int indexOfComma = splitedValue[i].indexOf(",");
                            if (!(indexOfComma >= 0 ? indexOfComma != 3 : splitedValue[i].length() != 3)) continue;
                            throw new NumberFormatException("Punkt darf nur in 1000-er Schritten vorkommen.");
                        }
                    }
                    escapedValue = escapedValue.replaceAll("\\.", "");
                    escapedValue = escapedValue.replaceAll(",", ".");
                    if ((escapedValue = escapedValue.trim()) != null && escapedValue.indexOf(46) == 0) {
                        throw new NumberFormatException("Zahlenwert darf nicht mit Komma beginnen.");
                    }
                    if (escapedValue != null) {
                        for (int k = 0; k < escapedValue.length(); ++k) {
                            char c = escapedValue.charAt(k);
                            if (Character.isDigit(c) || c == '.' || c == '-' || c == '+') continue;
                            throw new NumberFormatException("Der Wert \"" + escapedValue + "\" enth\u00e4lt unerlaubte Zeichen und konnte nicht in eine Zahl gewandelt werden.");
                        }
                    }
                }
                this.myValue = new Double(escapedValue);
            }
            catch (Exception e) {
                throw new ValueConversionException("Der String \"" + this.myValueAsString + "\" konnte nicht als Zahl interpretiert werden (" + e.getMessage() + ").");
            }
        }
    }

    private double getDoubleFromValue(Value value) {
        double doubleValue = value == null || value == NilValue.instance() || !value.isValid() ? 0.0 : (value instanceof StringValue ? (value.asString() == null || value.asString().length() == 0 ? 0.0 : value.asDouble()) : value.asDouble());
        return doubleValue;
    }

    private static int computeRadix() {
        double tmp1;
        double tmp2;
        int radix = 0;
        double a = 1.0;
        while ((tmp2 = (tmp1 = (a += a) + 1.0) - a) - 1.0 != 0.0) {
        }
        double b = 1.0;
        while (radix == 0) {
            b += b;
            tmp1 = a + b;
            radix = (int)(tmp1 - a);
        }
        return radix;
    }

    private static double computeMachinePrecision() {
        double floatingRadix = NumberValue.getRadix();
        double inverseRadix = 1.0 / floatingRadix;
        double machinePrecision = 1.0;
        double tmp = 1.0 + machinePrecision;
        while (tmp - 1.0 != 0.0) {
            tmp = 1.0 + (machinePrecision *= inverseRadix);
        }
        return machinePrecision;
    }

    private static int computeDecimalPlace() {
        int decimalPlace = 0;
        double tmp = NumberValue.getPrecisionToUse() * 10.0;
        while (tmp - 1.0 < 0.0) {
            ++decimalPlace;
            tmp *= 10.0;
        }
        return decimalPlace;
    }

    public static int getRadix() {
        return radix;
    }

    public static double getMachinePrecision() {
        return machinePrecision;
    }

    public static double defaultNumericalPrecision() {
        return defaultNumericalPrecision;
    }

    public static double getPrecisionToUse() {
        return precisionToUse;
    }

    public static int getDecimalPlaceToUse() {
        return decimalPlaceToUse;
    }

    public static boolean equals(double a, double b) {
        return NumberValue.equals(a, b, NumberValue.getPrecisionToUse());
    }

    public static boolean equals(double a, double b, double precision) {
        double norm = Math.max(Math.abs(a), Math.abs(b));
        double precision_mult_norm = precision * norm;
        if (precision_mult_norm >= 0.5) {
            precision_mult_norm = 0.4999999999;
        }
        return norm < precision || Math.abs(a - b) < precision_mult_norm;
    }

    public static int compare(double a, double b) {
        return NumberValue.compare(a, b, NumberValue.getPrecisionToUse());
    }

    public static int compare(double a, double b, double precision) {
        int erg = 0;
        double norm = Math.max(Math.abs(a), Math.abs(b));
        if (norm >= precision) {
            double a_minus_b = a - b;
            double precision_mult_norm = precision * norm;
            if (precision_mult_norm >= 0.5) {
                precision_mult_norm = 0.4999999999;
            }
            erg = Math.abs(a_minus_b) < precision_mult_norm ? 0 : (a_minus_b > 0.0 ? 1 : -1);
        }
        return erg;
    }

    static {
        precisionToUse = defaultNumericalPrecision = Math.sqrt(machinePrecision);
        decimalPlaceToUse = NumberValue.computeDecimalPlace();
    }
}

