/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomRawField;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ResolveException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Resolver
extends AbstractElementVisitor {
    public static String USAGE_STANDARD = "standard";
    public static String USAGE_APG = "auspraegungsgruppe";
    public static String USAGE_MISSING_VALUES = "fehlwerte";
    public static String USAGE_MAPPING = "mapping";
    public static String USAGE_RAW_MAPPING = "raw_mapping";
    public static String USAGE_RAW_MAPPING_CORE = "raw_mapping_core";
    public static String USAGE_RAW_MAPPING_IDEV = "raw_mapping_idev";
    public static String USAGE_KONTEXT_PL = "PLAUSI";
    public static String USAGE_KONTEXT_IDEV = "IDEV";
    public static String USAGE_KONTEXT_CORE = "CORE";
    public static String USAGE_KONTEXT_APPLICATION = "APPLICATION";
    private Hashtable referenceTable = new Hashtable();
    private boolean useIDasRef = true;

    public void doResolve(MetaElement rootElement) throws ILParseException {
        rootElement.accept(this);
        this.checkSolved();
    }

    public void registerForResolve(MetaElement referingElement, String refName, String refRealName, Class refClass) {
        this.registerForResolve(referingElement, refName, refRealName, refClass, USAGE_STANDARD, true);
    }

    public void registerForResolve(MetaElement referingElement, String refName, String refRealName, Class refClass, boolean resolveRequired) {
        this.registerForResolve(referingElement, refName, refRealName, refClass, USAGE_STANDARD, resolveRequired);
    }

    public void registerForResolve(MetaElement referingElement, String refName, String refRealName, Class refClass, String usageHint, boolean resolveRequired) {
        Vector<Reference> references;
        Hashtable<String, Vector<Reference>> names = (Hashtable<String, Vector<Reference>>)this.referenceTable.get(refClass);
        if (names == null) {
            names = new Hashtable<String, Vector<Reference>>();
            this.referenceTable.put(refClass, names);
        }
        if ((references = (Vector<Reference>)names.get(refName)) == null) {
            references = new Vector<Reference>();
            names.put(refName, references);
        }
        references.add(new Reference(referingElement, resolveRequired, refName, refRealName, usageHint, refClass));
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.visitElements(plausi.getMerkmale());
        this.visitElements(plausi.getThemenbereiche());
        this.visitElements(plausi.getAuspraegungsgruppen());
        this.visitElements(plausi.getDsbs());
        this.visitElements(plausi.getRawDataSets());
        if (((MetaCustomPlausibilisierung)plausi).hasUsedMappings()) {
            ((MetaCustomPlausibilisierung)plausi).usedMappings().accept(this);
        } else {
            this.visitElements(plausi.getMappings());
        }
        this.visitElements(plausi.getPLMaterialien());
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        this.solveReference(new ThemenbereichSolver(tb), tb.getId(), tb.getClass());
        this.visitElements(tb.getAblaeufe());
        this.visitElements(tb.getEigenschaften());
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getInitialisierungswerte());
        this.visitElements(tb.getFunktionen());
        this.visitElements(tb.getPruefungen());
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung pruefung) {
        this.solveReference(new PLPruefungSolver(pruefung), pruefung.getId(), pruefung.getClass());
    }

    @Override
    public void visitTBFeld(MetaTBFeld tbFeld) {
        this.solveReference(new TBFeldSolver(tbFeld), tbFeld.getId(), tbFeld.getClass());
    }

    @Override
    public void visitMerkmal(MetaMerkmal merkmal) {
        this.solveReference(new MerkmalSolver(merkmal), merkmal.getId(), merkmal.getClass());
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
        this.solveReference(new AuspraegungsgruppeSolver(auspraegungsgruppe), auspraegungsgruppe.getId(), auspraegungsgruppe.getClass());
    }

    @Override
    public void visitDsbObjekt(MetaDsbObjekt dsb) {
        this.solveReference(new DsbObjektSolver(dsb), dsb.getId(), dsb.getClass());
        this.visitElements(dsb.getComps().getCompList());
        Iterator it = dsb.getComps().getSatzList();
        while (it != null && it.hasNext()) {
            MetaSatzart sa = (MetaSatzart)it.next();
            this.solveReference(new SatzartSolver(sa), sa.getId(), sa.getClass());
            this.visitElements(sa.getFelder());
        }
    }

    @Override
    public void visitEinzelfeld(MetaEinzelfeld einzelfeld) {
        this.solveReference(new EinzelfeldSolver(einzelfeld), einzelfeld.getId(), einzelfeld.getClass());
    }

    @Override
    public void visitMapping(MetaMapping mapping) {
        this.solveReference(new MappingSolver(mapping), mapping.getId(), mapping.getClass());
        this.visitElements(mapping.getMappingliste());
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial material) {
        this.solveReference(new PLMaterialSolver(material), material.getId(), material.getClass());
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf material) {
        this.solveReference(new PLAblaufSolver(material), material.getId(), material.getClass());
    }

    @Override
    public void visitRawDataSet(MetaRawDataSet rawDataSet) {
        this.solveReference(new RawDataSetSolver(rawDataSet), rawDataSet.getId(), rawDataSet.getClass());
        this.visitElements(rawDataSet.getListOfRawField());
        this.visitElements(rawDataSet.getListOfRawSet());
    }

    @Override
    public void visitRawField(MetaRawField feld) {
        this.solveReference(new RawFieldSolver(feld), feld.getId(), feld.getClass());
    }

    @Override
    public void visitRawFieldGroup(MetaRawFieldGroup group) {
        this.solveReference(new RawFieldSolver(group), group.getId(), MetaCustomRawField.class);
        this.visitElements(group.getListOfRawField());
    }

    @Override
    public void visitRawSet(MetaRawSet set) {
        this.solveReference(new RawSetSolver(set), set.getId(), set.getClass());
        this.visitElements(set.getListOfRawField());
    }

    private void solveReference(SolverElementVisitor solver, String refName, Class refClass) {
        Hashtable names = (Hashtable)this.referenceTable.get(refClass);
        if (names == null) {
            return;
        }
        Vector references = (Vector)names.remove(refName);
        if (references == null) {
            return;
        }
        for (Reference ref : references) {
            solver.setUsageHint(ref.usageHint);
            ref.referringElement.accept(solver);
        }
        if (names.size() == 0) {
            this.referenceTable.remove(refName);
        }
    }

    private void checkSolved() throws ILParseException {
        StringBuffer message = new StringBuffer("");
        for (Class aClass : this.referenceTable.keySet()) {
            Hashtable nameTable = (Hashtable)this.referenceTable.get(aClass);
            if (nameTable == null) continue;
            for (String aName : nameTable.keySet()) {
                Vector referencesVector = (Vector)nameTable.get(aName);
                if (referencesVector == null) continue;
                for (Reference aReference : referencesVector) {
                    if (!aReference.resolveRequired) continue;
                    message.append("\nReferenz auf '");
                    message.append(aReference.realName);
                    message.append("' vom Typ ");
                    message.append(this.getNameForClass(aReference.refClass));
                    message.append(" nicht gefunden (");
                    message.append("referenziert von ");
                    message.append(this.getNameForClass(aReference.referringElement.getClass()));
                    MetaElement refElement = aReference.referringElement;
                    if (refElement instanceof MetaStatspezObjekt) {
                        message.append(", Name: ");
                        message.append(((MetaStatspezObjekt)refElement).getName());
                    }
                    message.append(", ID: ");
                    message.append(refElement.getId());
                    message.append(")");
                }
            }
        }
        if (message.length() > 0) {
            throw new ResolveException("Es existieren nicht aufloesbare Referenzen:" + message.toString());
        }
    }

    public boolean isUseIDasRef() {
        return this.useIDasRef;
    }

    public void setUseIDasRef(boolean b) {
        this.useIDasRef = b;
    }

    private String getNameForClass(Class klasse) {
        String erg = "Unbekannt";
        if (klasse != null) {
            StringTokenizer eintraege = null;
            eintraege = new StringTokenizer(klasse.getName(), ".");
            String k_name = klasse.getName();
            while (eintraege != null && eintraege.hasMoreTokens()) {
                k_name = eintraege.nextToken();
            }
            if (k_name != null && k_name.startsWith("Meta")) {
                k_name = k_name.substring("Meta".length());
            }
            if (k_name != null && k_name.startsWith("Custom")) {
                k_name = k_name.substring("Custom".length());
            }
            erg = k_name;
        }
        return erg;
    }

    private class SolverElementVisitor
    extends AbstractElementVisitor {
        private String usageHint = null;

        public String getUsageHint() {
            return this.usageHint;
        }

        public void setUsageHint(String usageHint) {
            this.usageHint = usageHint;
        }
    }

    private class PLMaterialSolver
    extends SolverElementVisitor {
        private MetaPLMaterial myMaterial = null;

        public PLMaterialSolver(MetaPLMaterial material) {
            this.myMaterial = material;
        }

        @Override
        public void visitTBMaterialReferenz(MetaTBMaterialReferenz ref) {
            ref.setMaterialbeschreibung(this.myMaterial);
        }
    }

    private class RawDataSetSolver
    extends SolverElementVisitor {
        private MetaRawDataSet myRawDataSet = null;

        public RawDataSetSolver(MetaRawDataSet rawDataSet) {
            this.myRawDataSet = rawDataSet;
        }

        @Override
        public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
            ((MetaCustomPlausibilisierung)plausi).setRawDataSet(this.myRawDataSet);
        }

        @Override
        public void visitPLMaterial(MetaPLMaterial material) {
            ((MetaCustomPLMaterial)material).setRawDataSet(this.myRawDataSet);
        }

        @Override
        public void visitMapping(MetaMapping mapping) {
            ((MetaCustomMapping)mapping).setRawDataSet(this.myRawDataSet);
        }
    }

    private class MappingSolver
    extends SolverElementVisitor {
        private MetaMapping myMapping = null;

        public MappingSolver(MetaMapping mapping) {
            this.myMapping = mapping;
        }

        @Override
        public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
            if (USAGE_RAW_MAPPING.equals(this.getUsageHint())) {
                ((MetaCustomPlausibilisierung)plausi).setRawMapping(this.myMapping);
            } else {
                ((MetaCustomPlausibilisierung)plausi).setUsedMappings(this.myMapping);
            }
        }

        @Override
        public void visitPLMaterial(MetaPLMaterial material) {
            if (USAGE_RAW_MAPPING.equals(this.getUsageHint())) {
                ((MetaCustomPLMaterial)material).setUsedRawMapping(this.myMapping);
            } else if (USAGE_RAW_MAPPING_CORE.equals(this.getUsageHint())) {
                ((MetaCustomPLMaterial)material).setUsedRawMappingCORE(this.myMapping);
            } else if (USAGE_RAW_MAPPING_IDEV.equals(this.getUsageHint())) {
                ((MetaCustomPLMaterial)material).setUsedRawMappingIDEV(this.myMapping);
            } else {
                material.setMapping(this.myMapping);
            }
        }
    }

    private class RawSetSolver
    extends SolverElementVisitor {
        private MetaRawSet myRawSet = null;

        public RawSetSolver(MetaRawSet rawSet) {
            this.myRawSet = rawSet;
        }

        @Override
        public void visitMappingElement(MetaMappingElement mappingElement) {
            ((MetaCustomMappingElement)mappingElement).setRawSet(this.myRawSet);
        }
    }

    private class SatzartSolver
    extends SolverElementVisitor {
        private MetaSatzart mySatzart = null;

        public SatzartSolver(MetaSatzart satzart) {
            this.mySatzart = satzart;
        }

        @Override
        public void visitMappingElement(MetaMappingElement mappingElement) {
            mappingElement.setFeldSatzart(this.mySatzart);
        }
    }

    private class RawFieldSolver
    extends SolverElementVisitor {
        private MetaRawField myRawfield = null;

        public RawFieldSolver(MetaRawField rawfield) {
            this.myRawfield = rawfield;
        }

        @Override
        public void visitMappingElement(MetaMappingElement mappingElement) {
            if (mappingElement instanceof MetaCustomMappingElement) {
                ((MetaCustomMappingElement)mappingElement).setFeldRaw(this.myRawfield);
            }
        }
    }

    private class EinzelfeldSolver
    extends SolverElementVisitor {
        private MetaEinzelfeld myEinzelfeld = null;

        public EinzelfeldSolver(MetaEinzelfeld einzelfeld) {
            this.myEinzelfeld = einzelfeld;
        }

        @Override
        public void visitSatzart(MetaSatzart satzart) {
            satzart.setEf(this.myEinzelfeld);
        }

        @Override
        public void visitMappingElement(MetaMappingElement mappingElement) {
            if (mappingElement instanceof MetaCustomMappingElement) {
                ((MetaCustomMappingElement)mappingElement).setFeldDSB(this.myEinzelfeld);
            }
        }
    }

    private class DsbObjektSolver
    extends SolverElementVisitor {
        private MetaDsbObjekt myDsbObjekt = null;

        public DsbObjektSolver(MetaDsbObjekt dsbObjekt) {
            this.myDsbObjekt = dsbObjekt;
        }

        @Override
        public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
            ((MetaCustomPlausibilisierung)plausi).setUsedDsbObjekt(this.myDsbObjekt);
        }

        @Override
        public void visitMapping(MetaMapping mapping) {
            mapping.setDSB(this.myDsbObjekt);
        }

        @Override
        public void visitPLMaterial(MetaPLMaterial material) {
            if (material instanceof MetaCustomPLMaterial) {
                if (USAGE_KONTEXT_CORE.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)material).setDsbDaten(this.myDsbObjekt);
                } else if (USAGE_KONTEXT_IDEV.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)material).setDsbDaten(this.myDsbObjekt);
                } else if (USAGE_KONTEXT_PL.equals(this.getUsageHint())) {
                    material.setDSB(this.myDsbObjekt);
                } else if (USAGE_KONTEXT_APPLICATION.equals(this.getUsageHint())) {
                    material.setDSB(this.myDsbObjekt);
                } else {
                    throw new IllegalArgumentException("Unbekannter Verweis");
                }
            }
        }
    }

    private class AuspraegungsgruppeSolver
    extends SolverElementVisitor {
        private MetaAuspraegungsgruppe myAuspraegungsgruppe = null;

        public AuspraegungsgruppeSolver(MetaAuspraegungsgruppe auspraegungsgruppe) {
            this.myAuspraegungsgruppe = auspraegungsgruppe;
        }

        @Override
        public void visitMerkmal(MetaMerkmal merkmal) {
            if (USAGE_MISSING_VALUES.equals(this.getUsageHint())) {
                merkmal.setKlasseFehlwerte(this.myAuspraegungsgruppe);
            } else {
                merkmal.setKlasseWertebereich(this.myAuspraegungsgruppe);
            }
        }
    }

    private class MerkmalSolver
    extends SolverElementVisitor {
        private MetaMerkmal myMerkmal = null;

        public MerkmalSolver(MetaMerkmal merkmal) {
            this.myMerkmal = merkmal;
        }

        @Override
        public void visitTBFeld(MetaTBFeld feld) {
            feld.setKlasse(this.myMerkmal);
        }
    }

    private class PLPruefungSolver
    extends SolverElementVisitor {
        private MetaPLPruefung myPruefung = null;

        public PLPruefungSolver(MetaPLPruefung pruefung) {
            this.myPruefung = pruefung;
        }
    }

    private class TBFeldSolver
    extends SolverElementVisitor {
        private MetaTBFeld myTBFeld = null;

        public TBFeldSolver(MetaTBFeld tbFeld) {
            this.myTBFeld = tbFeld;
        }

        @Override
        public void visitPLPruefung(MetaPLPruefung pruefung) {
            ((MetaCustomPruefung)pruefung).fuegeHauptBezugsfeldItemHinzu(this.myTBFeld);
        }

        @Override
        public void visitMappingElement(MetaMappingElement mappingElement) {
            if (mappingElement instanceof MetaCustomMappingElement) {
                ((MetaCustomMappingElement)mappingElement).fuegeTBFeldHinzu(this.myTBFeld);
            }
        }
    }

    private class PLAblaufSolver
    extends SolverElementVisitor {
        private MetaCustomAblauf myAblauf = null;

        public PLAblaufSolver(MetaPLAblauf myAblauf) {
            this.myAblauf = (MetaCustomAblauf)myAblauf;
        }

        @Override
        public void visitPLMaterial(MetaPLMaterial anObject) {
            if (anObject instanceof MetaCustomPLMaterial) {
                if (USAGE_KONTEXT_CORE.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)anObject).setCoreAblauf(this.myAblauf);
                } else if (USAGE_KONTEXT_IDEV.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)anObject).addToAblaeufeIDEV(this.myAblauf);
                } else if (USAGE_KONTEXT_PL.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)anObject).addToAblaeufePL(this.myAblauf);
                } else if (USAGE_KONTEXT_APPLICATION.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)anObject).addToAblaeufe(this.myAblauf);
                } else {
                    throw new IllegalArgumentException("Unbekannter Verweis");
                }
            }
        }
    }

    private class ThemenbereichSolver
    extends SolverElementVisitor {
        private MetaCustomThemenbereich myTb = null;

        public ThemenbereichSolver(MetaThemenbereich tb) {
            this.myTb = (MetaCustomThemenbereich)tb;
        }

        @Override
        public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
            ((MetaCustomPlausibilisierung)plausi).setRootThemenbereich(this.myTb);
        }

        @Override
        public void visitTBFeld(MetaTBFeld feld) {
            feld.setKlasse(this.myTb);
            this.myTb.addReferenziertVon(feld);
        }

        @Override
        public void visitMapping(MetaMapping mapping) {
            mapping.setThemenbereich(this.myTb);
        }

        @Override
        public void visitPLMaterial(MetaPLMaterial material) {
            if (material instanceof MetaCustomPLMaterial) {
                if (USAGE_KONTEXT_CORE.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)material).setThemenbereichCORE(this.myTb);
                } else if (USAGE_KONTEXT_IDEV.equals(this.getUsageHint())) {
                    ((MetaCustomPLMaterial)material).setThemenbereichIDEV(this.myTb);
                } else if (USAGE_KONTEXT_PL.equals(this.getUsageHint())) {
                    material.setThemenbereich(this.myTb);
                } else if (USAGE_KONTEXT_APPLICATION.equals(this.getUsageHint())) {
                    material.setThemenbereich(this.myTb);
                } else {
                    throw new IllegalArgumentException("Unbekannter Verweis");
                }
                this.myTb.setDescribesMaterial(true);
                this.myTb.setMaterial(material);
            }
        }
    }

    private class Reference {
        public MetaElement referringElement;
        public boolean resolveRequired;
        public String refName;
        public String realName;
        public String usageHint;
        public Class refClass;

        public Reference(MetaElement referringElement, boolean resolveRequired, String refName, String realName, Class refClass) {
            this.referringElement = referringElement;
            this.resolveRequired = resolveRequired;
            this.refName = refName;
            this.realName = realName;
            this.refClass = refClass;
        }

        public Reference(MetaElement referringElement, boolean resolveRequired, String refName, String realName, String usageHint, Class refClass) {
            this.referringElement = referringElement;
            this.resolveRequired = resolveRequired;
            this.refName = refName;
            this.realName = realName;
            this.usageHint = usageHint;
            this.refClass = refClass;
        }
    }
}

