/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ObjectReferenceParser
extends SubParser {
    private MetaStatspezObjekt currentElement = null;

    public ObjectReferenceParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "objectReference".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("objectReference".equalsIgnoreCase(localName)) {
            this.enable();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("objectReference".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("objectReference".equalsIgnoreCase(localName)) {
            String str = atts.getValue("class");
            if (str != null) {
                // empty if block
            }
            if ((str = atts.getValue("reference-type")) != null) {
                // empty if block
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!("objectID".equalsIgnoreCase(localName) || "objectName".equalsIgnoreCase(localName) || "objectVersion".equalsIgnoreCase(localName))) {
            handled = false;
        }
        return handled;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
    }
}

