/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.parser.Dsb_Comment_Parser;
import de.statspez.pleditor.generator.parser.Dsb_FieldTypeParser;
import de.statspez.pleditor.generator.parser.Dsb_GroupTypeParser;
import de.statspez.pleditor.generator.parser.Dsb_RecordIdentifiersParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Dsb_RecordTypeParser
extends SubParser
implements SuperParser {
    private MetaSatzart currentSatzart = null;
    private MetaDsbObjekt currentDsb = null;
    private ParserChain parserChain = new ParserChain();
    private Dsb_FieldTypeParser feldParser = null;
    private Dsb_Comment_Parser commentParser = null;
    private Dsb_GroupTypeParser groupParser = null;
    private Dsb_RecordIdentifiersParser identifiersParser = null;
    private boolean satzartFlag = false;

    public Dsb_RecordTypeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.commentParser = new Dsb_Comment_Parser(this, resolver);
        this.parserChain.addParser(this.commentParser);
        this.feldParser = new Dsb_FieldTypeParser(this, resolver);
        this.parserChain.addParser(this.feldParser);
        this.groupParser = new Dsb_GroupTypeParser(this, resolver);
        this.parserChain.addParser(this.groupParser);
        this.identifiersParser = new Dsb_RecordIdentifiersParser(this, resolver);
        this.parserChain.addParser(this.identifiersParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "recordType".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("recordType".equalsIgnoreCase(localName)) {
            this.enable();
            if (this.satzartFlag) {
                this.currentSatzart = new MetaSatzart();
                this.identifiersParser.setCurrentSA(this.currentSatzart);
            } else {
                this.currentSatzart = null;
            }
            this.handleAttributes(namespaceURI, localName, qName, atts);
        } else {
            if ("groupType".equalsIgnoreCase(localName)) {
                this.feldParser.setCanEnabled(false);
                this.commentParser.setCanEnabled(false);
            }
            if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
                if (this.canHandleTag(namespaceURI, localName)) {
                    this.handleAttributes(namespaceURI, localName, qName, atts);
                } else {
                    throw ILParseException.unknownTagException(localName);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("recordType".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        if (this.satzartFlag) {
            return this.currentSatzart;
        }
        return this.currentDsb;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            MetaDsbFeld aFeld = (MetaDsbFeld)this.feldParser.object();
            if (this.satzartFlag) {
                this.currentSatzart.addToFelder(aFeld);
            } else {
                this.currentDsb.getComps().addToCompList(aFeld);
            }
        } else if (aParser == this.groupParser) {
            MetaDsbComps comps = (MetaDsbComps)this.groupParser.object();
            Iterator it = comps.getCompList();
            if (this.satzartFlag) {
                while (it != null && it.hasNext()) {
                    this.currentSatzart.addToFelder((MetaDsbFeld)it.next());
                }
            } else {
                while (it != null && it.hasNext()) {
                    this.currentDsb.getComps().addToCompList((MetaDsbFeld)it.next());
                }
            }
            this.feldParser.setCanEnabled(true);
            this.commentParser.setCanEnabled(true);
        } else if (aParser == this.commentParser) {
            if (this.satzartFlag) {
                this.currentSatzart.addToFelder((MetaDsbFeld)this.commentParser.object());
            } else {
                this.currentDsb.getComps().addToCompList((MetaDsbFeld)this.commentParser.object());
            }
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("recordType".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (this.currentSatzart != null) {
                if (str == null || str.trim().length() == 0) {
                    throw new ILParseException("Fuer die Satzart ist kein Name definiert!");
                }
                this.currentSatzart.setName(str.trim());
            }
            String id = atts.getValue("id");
            if (this.currentSatzart != null && id != null && id.trim().length() > 0) {
                this.currentSatzart.setId(id.trim());
            }
            if ((str = atts.getValue("class")) != null) {
                // empty if block
            }
            if ((str = atts.getValue("length")) != null) {
                int length;
                try {
                    length = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {
                    throw new ILParseException("Wert des Attributes length ist keine Zahl!");
                }
                if (this.currentSatzart != null) {
                    this.currentSatzart.setSatzlaenge(length);
                } else {
                    this.currentDsb.setSatzlaenge(length);
                }
            }
            if ((str = atts.getValue("name-prefix")) != null && str.trim().length() > 0) {
                if (this.currentSatzart != null) {
                    this.currentSatzart.setPraefix(str.trim());
                } else {
                    this.currentDsb.setPraefix(str.trim());
                }
            }
            if ((str = atts.getValue("name-headprefix")) != null && str.trim().length() > 0) {
                this.currentSatzart.setKopfPraefix(str.trim());
            }
        } else if ("encoding".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (str == null) {
                throw new ILParseException("Fuer den Zeichensatz ist kein Name definiert!");
            }
            str = atts.getValue("class");
            if (str != null) {
                // empty if block
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!"annotation".equalsIgnoreCase(localName) && !"encoding".equalsIgnoreCase(localName)) {
            handled = false;
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "annotation".equalsIgnoreCase(localName) || "encoding".equalsIgnoreCase(localName);
    }

    public boolean isSatzartFlag() {
        return this.satzartFlag;
    }

    public void setSatzartFlag(boolean b) {
        this.satzartFlag = b;
    }

    public void setCurrentDsb(MetaDsbObjekt objekt) {
        this.currentDsb = objekt;
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

