/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.meta;

import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import java.util.Iterator;
import java.util.Vector;

public class MetaProgram
extends MetaElement {
    public static final String DEFAULT_NAME = "Program";
    private String myName = null;
    private MetaStatementSequence myStatements = null;
    private Vector myParameters = new Vector();
    private MessageContextInterface contextInfos = null;
    private boolean hasToReturnValue = false;
    private boolean containsHierarchicalFunction = false;
    private boolean canHaveSelfAccess = false;
    private boolean plausiStatementsAllowed = false;
    private boolean canHaveIndexOperator = true;

    public MetaProgram(String name, MetaStatementSequence statements) {
        this.myName = name;
        this.myStatements = statements;
        if (statements != null) {
            this.setSourceLocation(statements.startLine(), statements.startColumn(), statements.endLine(), statements.endColumn());
        }
    }

    public boolean isCanHaveSelfAccess() {
        return this.canHaveSelfAccess;
    }

    public void setCanHaveSelfAccess(boolean canHaveSelfAccess) {
        this.canHaveSelfAccess = canHaveSelfAccess;
    }

    public MetaProgram(String name, MetaStatementSequence statements, Vector parameters) {
        this(name, statements);
        this.myParameters = parameters;
    }

    public MetaProgram(MetaStatementSequence statements, boolean containsHierarchicalFunction) {
        this(DEFAULT_NAME, statements);
        this.containsHierarchicalFunction = containsHierarchicalFunction;
    }

    public String name() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public MetaStatementSequence statements() {
        return this.myStatements;
    }

    public void addParameter(MetaProgramParameter aParameter) {
        this.myParameters.add(aParameter);
    }

    public Iterator parameters() {
        return this.myParameters.iterator();
    }

    public int numberOfParameters() {
        return this.myParameters.size();
    }

    public MetaProgramParameter parameterAt(int position) {
        return (MetaProgramParameter)this.myParameters.elementAt(position);
    }

    public void setContextInfos(MessageContextInterface infos) {
        this.contextInfos = infos;
    }

    public MessageContextInterface contextInfos() {
        return this.contextInfos;
    }

    @Override
    public void accept(MetaElementVisitor aVisitor) {
        aVisitor.visitProgram(this);
    }

    @Override
    public String toString() {
        return "Program '" + this.name() + "'";
    }

    public boolean isHasToReturnValue() {
        return this.hasToReturnValue;
    }

    public void setHasToReturnValue(boolean hasToReturnValue) {
        this.hasToReturnValue = hasToReturnValue;
    }

    public boolean containsHierarchicalFunction() {
        return this.containsHierarchicalFunction;
    }

    public void delegateAcceptOnRightValue(MetaElementVisitor aVisitor) {
        this.accept(aVisitor);
    }

    public void setPlausiStatementsAllowed(boolean plausiStatementsAllowed) {
        this.plausiStatementsAllowed = plausiStatementsAllowed;
    }

    public boolean isPlausiStatementsAllowed() {
        return this.plausiStatementsAllowed;
    }

    public boolean isCanHaveIndexOperator() {
        return this.canHaveIndexOperator;
    }

    public void setCanHaveIndexOperator(boolean canHaveIndexOperator) {
        this.canHaveIndexOperator = canHaveIndexOperator;
    }
}

