/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatumMaske
extends AbstractMaske {
    private static ThreadLocal masken = new ThreadLocal();

    protected DatumMaske() {
    }

    public SimpleDateFormat getSimpleDateFormat() {
        if (this.maske != null) {
            return DatumMaske.createSimpleDateFormat(this.maske);
        }
        return null;
    }

    public boolean isWertGueltigOld(String wert, StringBuffer fehler) {
        try {
            Date date = this.getWertAlsDate(wert);
            SimpleDateFormat format = DatumMaske.createSimpleDateFormat(this.maske);
            format.format(date);
            return true;
        }
        catch (MaskeException e) {
            if (fehler != null) {
                fehler.append(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean isWertGueltig(String wert, StringBuffer fehler) {
        if (this.maske == null) {
            if (fehler != null) {
                fehler.append("Die Maske muss angegeben werden!");
            }
            return false;
        }
        if (wert == null) {
            if (fehler != null) {
                fehler.append("Der Wert muss angegeben werden!");
            }
            return false;
        }
        if (wert.length() != this.minLaenge) {
            this.gibFormatFehler(fehler, wert);
            return false;
        }
        try {
            SimpleDateFormat format = DatumMaske.createSimpleDateFormat(this.maske);
            format.parse(wert);
            Date date = format.parse(wert);
            String str = format.format(date);
            if (!str.equals(wert)) {
                this.gibFormatFehler(fehler, wert);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.gibFormatFehler(fehler, wert);
            return false;
        }
    }

    public Date getWertAlsDate(String wert) throws MaskeException {
        if (this.maske == null) {
            throw new MaskeException("Die Maske muss angegeben werden!");
        }
        if (wert == null) {
            throw new MaskeException("Der Wert muss angegeben werden!");
        }
        if (wert.length() != this.maske.length()) {
            throw new MaskeException("Der Wert " + wert + " muss genau " + this.maske.length() + " Zeichen enthalten!");
        }
        try {
            SimpleDateFormat format = DatumMaske.createSimpleDateFormat(this.maske);
            Date date = format.parse(wert);
            return date;
        }
        catch (Exception e) {
            throw new MaskeException("Der Wert " + wert + " entspricht nicht dem in der Maske definierten Format.");
        }
    }

    @Override
    public String gibWertFormatiert(Object wert) {
        if (wert == null) {
            return null;
        }
        if (wert instanceof Date) {
            return this.gibWertFormatiert((Date)wert);
        }
        return wert.toString();
    }

    public String gibWertFormatiert(Date date) {
        String erg;
        if (date == null) {
            erg = null;
        } else {
            SimpleDateFormat format = DatumMaske.createSimpleDateFormat(this.maske);
            erg = format.format(date);
        }
        return erg;
    }

    @Override
    protected char gibStandardAusrichtung() {
        return 'L';
    }

    public static SimpleDateFormat createSimpleDateFormat(String maske) {
        SimpleDateFormat format = null;
        Map threadFormate = (Map)masken.get();
        if (threadFormate == null) {
            threadFormate = new LinkedHashMap(){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 70;
                }
            };
            masken.set(threadFormate);
        }
        if ((format = (SimpleDateFormat)threadFormate.get(maske)) == null) {
            format = new SimpleDateFormat(maske);
            format.setLenient(false);
            threadFormate.put(maske, format);
        }
        return format;
    }
}

