/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;

public abstract class AbstractMaskenParser
implements MaskenParserInterface {
    private char[] patternSymbols = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'};
    protected char[] symbole;

    protected abstract void initSymbole();

    public AbstractMaskenParser() {
        this.initSymbole();
    }

    protected boolean istSymbol(char ch) {
        boolean erg = false;
        for (int i = 0; this.symbole != null && i < this.symbole.length; ++i) {
            if (this.symbole[i] != ch) continue;
            erg = true;
            break;
        }
        return erg;
    }

    protected String gibAusdruckFuerSymbol(char ch) throws MaskeException {
        String erg;
        switch (ch) {
            case 'Z': {
                erg = "[^a-z]";
                break;
            }
            case 'z': {
                erg = "[^A-Z]";
                break;
            }
            case 'c': {
                erg = ".";
                break;
            }
            case '#': {
                erg = "[0-9]";
                break;
            }
            case '@': {
                erg = " ";
                break;
            }
            default: {
                throw new MaskeException("Zeichen " + ch + " unerwartet");
            }
        }
        return erg;
    }

    protected String maskierePatternSymbol(char zeichen) {
        String erg = null;
        for (int i = 0; this.patternSymbols != null && i < this.patternSymbols.length && erg == null; ++i) {
            if (zeichen != this.patternSymbols[i]) continue;
            erg = new String(new char[]{'\\', zeichen});
        }
        if (erg == null) {
            erg = new String(new char[]{zeichen});
        }
        return erg;
    }

    protected String parseAusrichtung(AbstractMaske abstractMaske, String maske) {
        if (maske != null && maske.length() > 0) {
            char ch = maske.charAt(0);
            switch (ch) {
                case 'L': 
                case 'M': 
                case 'R': {
                    abstractMaske.setzeAusrichtung(ch);
                    maske = maske.substring(1);
                }
            }
        }
        return maske;
    }
}

