/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.format;

import de.statspez.pleditor.generator.format.CodeSegment;
import de.statspez.pleditor.generator.format.FormatSegment;
import de.statspez.pleditor.generator.format.Segment;
import de.statspez.pleditor.generator.format.SegmentTraverser;
import de.statspez.pleditor.generator.format.TextSegment;
import java.util.HashMap;
import java.util.Map;

public class HtmlSegmentConverter
extends SegmentTraverser {
    private static final Map<String, String> formatTags = new HashMap<String, String>();
    private StringBuffer buffer = new StringBuffer();
    private boolean ignoreFirstLineBreak = false;

    public String convert(Segment segment) {
        this.buffer.delete(0, this.buffer.length());
        segment.accept(this);
        return this.buffer.toString();
    }

    protected void append(String text) {
        this.buffer.append(text);
    }

    @Override
    public void visitFormatSegment(FormatSegment segment) {
        String tag = formatTags.get(segment.getType());
        if (tag == null) {
            throw new IllegalStateException("Invalid segment type: " + segment.getType());
        }
        this.append("<" + tag + ">");
        if ("nl".equals(segment.getType()) || "ul".equals(segment.getType())) {
            this.ignoreFirstLineBreak = true;
        }
        super.visitFormatSegment(segment);
        this.append("</" + tag + ">");
        if ("nl".equals(segment.getType()) || "ul".equals(segment.getType()) || "le".equals(segment.getType()) || "t1".equals(segment.getType()) || "t2".equals(segment.getType()) || "t3".equals(segment.getType()) || "t4".equals(segment.getType())) {
            this.ignoreFirstLineBreak = true;
        }
    }

    @Override
    public void visitTextSegment(TextSegment segment) {
        String text = segment.getText();
        if (this.ignoreFirstLineBreak && text.startsWith("\n")) {
            text = text.substring(1);
        }
        this.ignoreFirstLineBreak = false;
        this.append(HtmlSegmentConverter.escape(text));
    }

    @Override
    public void visitCodeSegment(CodeSegment segment) {
        this.append(HtmlSegmentConverter.escape(segment.toString()));
    }

    protected static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = text.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '<': {
                    buffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    buffer.append("<br/>");
                    continue block8;
                }
                case '\t': 
                case '\r': {
                    continue block8;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        return buffer.toString();
    }

    static {
        formatTags.put("f", "b");
        formatTags.put("k", "i");
        formatTags.put("u", "u");
        formatTags.put("h", "sup");
        formatTags.put("t", "sub");
        formatTags.put("nl", "ol");
        formatTags.put("ul", "ul");
        formatTags.put("le", "li");
        formatTags.put("t1", "h1");
        formatTags.put("t2", "h2");
        formatTags.put("t3", "h3");
        formatTags.put("t4", "h4");
    }
}

