/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.MultipleComparedNode;
import de.statspez.pleditor.generator.compare2.ui.ComboBoxValue;
import de.statspez.pleditor.generator.compare2.ui.CompareEditor;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultipleFieldDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_UEBERNEHMEN = "\u00dcbernehmen";
    private static final String LABEL_ABBRECHEN = "Abbrechen";
    private JButton uebernehmen;
    private CompareEditor compareEditor;
    private MultipleComparedNode comparedNode;
    private boolean editable;
    private List<AnswerComponent> answers;
    private JScrollPane scrollPane;

    public MultipleFieldDialog(Frame owner, CompareEditor compareEditor) {
        super(owner, true);
        this.init(compareEditor);
    }

    public MultipleFieldDialog(Dialog owner, CompareEditor compareEditor) {
        super(owner, true);
        this.init(compareEditor);
    }

    public void show(MultipleComparedNode comparedNode, int column) {
        this.comparedNode = comparedNode;
        this.editable = column == 1;
        this.answers = this.createAnswerComponents(comparedNode.getClassifications(), comparedNode.getMissingValueClassifications());
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridBagLayout());
        inputPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        boolean addMissingTitle = true;
        for (AnswerComponent antwort : this.answers) {
            if (antwort.missingValue && addMissingTitle) {
                addMissingTitle = false;
                ++constraints.gridy;
                constraints.insets = new Insets(3, 3, 0, 0);
                inputPanel.add((Component)new JLabel("Fehlwerte:"), constraints);
                constraints.insets = new Insets(0, 0, 0, 0);
            }
            ++constraints.gridy;
            inputPanel.add((Component)antwort, constraints);
        }
        this.scrollPane.setViewportView(inputPanel);
        this.readValues(column);
        this.setTitle(comparedNode.toString());
        this.pack();
        this.setVisible(true);
    }

    private void init(CompareEditor compareEditor) {
        this.compareEditor = compareEditor;
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.scrollPane, "Center");
        panel.add((Component)this.getActionsPanel(), "South");
        this.getContentPane().add(panel);
    }

    private JComponent getActionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.uebernehmen = new JButton(LABEL_UEBERNEHMEN);
        this.uebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleFieldDialog.this.writeValues();
                MultipleFieldDialog.this.setVisible(false);
            }
        });
        panel.add(this.uebernehmen);
        JButton abbrechen = new JButton(LABEL_ABBRECHEN);
        abbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleFieldDialog.this.setVisible(false);
            }
        });
        panel.add(abbrechen);
        return panel;
    }

    private List<AnswerComponent> createAnswerComponents(MetaAuspraegungsgruppe classifications, MetaAuspraegungsgruppe missingValueClassifications) {
        List<ComboBoxValue> comboBoxValues;
        ArrayList<AnswerComponent> result = new ArrayList<AnswerComponent>();
        if (classifications != null) {
            comboBoxValues = TreeTable.getComboBoxValues(classifications, false);
            for (ComboBoxValue tmp : comboBoxValues) {
                result.add(new AnswerComponent(tmp, false));
            }
        }
        if (missingValueClassifications != null) {
            comboBoxValues = TreeTable.getComboBoxValues(missingValueClassifications, false);
            for (ComboBoxValue tmp : comboBoxValues) {
                result.add(new AnswerComponent(tmp, true));
            }
        }
        return result;
    }

    private void readValues(int column) {
        this.uebernehmen.setEnabled(false);
        String[] values = column == 1 ? this.comparedNode.getHauptsatzFeldwert() : this.comparedNode.getVergleichssatzFeldwert(column - 1);
        ArrayList<String> list = new ArrayList<String>(values == null ? 0 : values.length);
        if (values != null) {
            for (String str : values) {
                list.add(str);
            }
        }
        for (AnswerComponent tmp : this.answers) {
            tmp.readValue(list);
        }
    }

    private void writeValues() {
        ArrayList<ComboBoxValue> selectedValues = new ArrayList<ComboBoxValue>();
        for (AnswerComponent tmp : this.answers) {
            if (!tmp.checkBox.isSelected()) continue;
            selectedValues.add(tmp.apg);
        }
        this.compareEditor.setHauptsatzValue(selectedValues, this.comparedNode);
    }

    private void deselect(boolean missingValue) {
        for (AnswerComponent tmp : this.answers) {
            if (tmp.missingValue != missingValue || !tmp.checkBox.isSelected()) continue;
            tmp.checkBox.setSelected(false);
        }
    }

    private class AnswerComponent
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final ComboBoxValue apg;
        private final boolean missingValue;
        private final JCheckBox checkBox;
        private final JLabel label;

        private AnswerComponent(ComboBoxValue apg, boolean missingValue) {
            super(new BorderLayout());
            this.apg = apg;
            this.missingValue = missingValue;
            this.checkBox = new JCheckBox();
            this.label = new JLabel(apg.getLabel());
            this.add((Component)this.checkBox, "West");
            this.add((Component)this.label, "Center");
            this.checkBox.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MultipleFieldDialog.this.uebernehmen.isEnabled()) {
                MultipleFieldDialog.this.uebernehmen.setEnabled(true);
            }
            if (this.checkBox.isSelected()) {
                MultipleFieldDialog.this.deselect(!this.missingValue);
            }
        }

        public void readValue(ArrayList<String> values) {
            boolean selected = values.contains(this.apg.getValue().toString());
            this.checkBox.setSelected(selected);
            if (!MultipleFieldDialog.this.editable) {
                this.checkBox.setEnabled(false);
            }
            if (!MultipleFieldDialog.this.editable && !selected) {
                this.label.setEnabled(false);
            }
        }
    }
}

