/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2;

import de.statspez.pleditor.generator.compare2.Comparator;
import de.statspez.pleditor.generator.compare2.ComparedCell;
import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.DefaultComparedCell;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.List;

public class DefaultComparedNode
extends ComparedNode {
    private String hauptsatzFeldwert = null;

    public DefaultComparedNode(ComparedNode parent, MetaElement element, FeldDeskriptorImpl feldDeskriptor, boolean virtual, SatzInterface hauptsatz, List<SatzInterface> vergleichssaetze, Comparator comparator) {
        super(parent, element, feldDeskriptor, virtual, hauptsatz, vergleichssaetze, comparator);
    }

    @Override
    public boolean hasHauptsatzValue() {
        return this.hauptsatzFeldwert != null && this.hauptsatzFeldwert.length() > 0;
    }

    @Override
    public boolean setHauptsatzValue(Object value, boolean markAsChanged) {
        boolean noChanged;
        Value valueNeu;
        if (value == null) {
            valueNeu = InvalidValue.instance();
        } else if (value instanceof String) {
            String strValue = (String)value;
            valueNeu = strValue.length() > 0 ? ValueFactory.instance().valueFor(strValue) : InvalidValue.instance();
        } else if (value instanceof Value) {
            valueNeu = (Value)value;
        } else {
            throw new RuntimeException("Ung\u00fcltiges Format beim Setzten des neuen Werts. " + value.getClass());
        }
        String hauptsatzFeldwertNeu = ((Value)valueNeu).asString();
        boolean bl = noChanged = this.hauptsatzFeldwert == null && hauptsatzFeldwertNeu == null || this.hauptsatzFeldwert != null && hauptsatzFeldwertNeu != null && this.hauptsatzFeldwert.equals(hauptsatzFeldwertNeu);
        if (!noChanged) {
            this.getFeldDeskriptor().setValueWith(this.hauptsatz, valueNeu, true);
            if (markAsChanged) {
                this.setChanged(true);
            }
            this.readValueOfHauptsatz();
        }
        return !noChanged;
    }

    @Override
    protected ComparedCell createComparedCell(SatzInterface satz) {
        return new DefaultComparedCell(satz);
    }

    @Override
    protected boolean isDifferentValue(int indexOfVergleichssatz) {
        DefaultComparedCell cell = (DefaultComparedCell)this.getComparedCell(indexOfVergleichssatz);
        return !this.hauptsatzFeldwert.equals(cell.getValue());
    }

    @Override
    protected void readValueOfHauptsatz() {
        if (this.hasHauptsatz()) {
            this.hauptsatzAnzeigewert = this.hauptsatzFeldwert = this.getFeldDeskriptor().getValueFrom(this.hauptsatz, true).asString();
            MetaAuspraegungsgruppe classifications = this.getClassifications();
            if (classifications != null) {
                this.hauptsatzAnzeigewert = DefaultComparedNode.getClassificationText(classifications, this.hauptsatzFeldwert);
            }
        } else {
            this.hauptsatzFeldwert = null;
            this.hauptsatzAnzeigewert = null;
            this.setChanged(false);
        }
    }

    @Override
    protected void setVergleichssatzValueInHauptsatz(ComparedNode quellNode, int indexOfVergleichssatz) {
        DefaultComparedCell cell = (DefaultComparedCell)this.getComparedCell(indexOfVergleichssatz);
        String value = cell.getValue();
        this.getFeldDeskriptor().setValueWith(this.hauptsatz, ValueFactory.instance().valueFor(value), true);
    }
}

