/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.codegen.java.CodegenFacade;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.Arrays;

public class GeneratorInvocation {
    private static String ENABLE_DSB_MAPPING = "-dsbmapping";
    private static String ENABLE_RAW_MAPPING = "-rawmapping";

    public static void main(String[] args) throws Exception {
        boolean enableDsbMapping = false;
        boolean enableRawMapping = false;
        boolean optionError = false;
        int rawOptionPos = -1;
        int dsbOptionPos = -1;
        for (int i = 0; i < args.length && !optionError; ++i) {
            if (ENABLE_DSB_MAPPING.equals(args[i])) {
                enableDsbMapping = true;
                dsbOptionPos = i;
                if (i == 0) {
                    optionError = true;
                }
            }
            if (!ENABLE_RAW_MAPPING.equals(args[i])) continue;
            enableRawMapping = true;
            rawOptionPos = i;
            if (i != 0) continue;
            optionError = true;
        }
        if (!optionError && (enableDsbMapping || enableRawMapping)) {
            int optionsToRemove = 0;
            optionsToRemove += enableDsbMapping ? 1 : 0;
            if (args.length - (optionsToRemove += enableRawMapping ? 1 : 0) < 1) {
                optionError = true;
            } else {
                int[] positionToRemove = new int[optionsToRemove];
                int pos = 0;
                if (enableDsbMapping) {
                    positionToRemove[pos] = dsbOptionPos;
                    ++pos;
                }
                if (enableRawMapping) {
                    positionToRemove[pos] = rawOptionPos;
                }
                args = GeneratorInvocation.removeStringFromPositions(args, positionToRemove);
            }
        }
        if (args.length < 1 || args.length > 2 || optionError) {
            System.err.println("Es muessen die folgenden Parameter angegeben werden:");
            System.err.println("1. (erforderlich) Name der Eingabe-Datei oder des Pfades.");
            System.err.println("2. (optional) Verzeichnis, in dem die Ausgabe-Datei erzeugt");
            System.err.println("3. (optional) " + ENABLE_DSB_MAPPING + " Ob bei der Generierung das DSB-Mapping erzeugt werden soll");
            System.err.println("4. (optional) " + ENABLE_RAW_MAPPING + " Ob bei der Generierung das RAW-Mapping erzeugt werden soll");
            System.err.println("   werden soll. Wenn dieser Parameter nicht angegeben ist wird");
            System.err.println("   das aktuelle Verzeichnis verwendet.");
            System.err.println("   Falls f\u00fcr 1. ein Pfad vorgegeben wird, werden die enthaltenen");
            System.err.println("   Dateien mit dem Muster Plausi_*.xml verarbeitet.");
            System.exit(1);
        }
        File file = new File(args[0]);
        File targetPath = null;
        if (file.isFile()) {
            targetPath = args.length == 1 ? file.getParentFile() : new File(args[1]);
            GeneratorInvocation.generate(file, targetPath, enableDsbMapping, enableRawMapping);
        } else if (file.isDirectory()) {
            targetPath = args.length == 1 ? file : new File(args[1]);
            Object[] filesInDir = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File f, String s) {
                    return s.startsWith("Plausi_") && s.endsWith(".xml");
                }
            });
            if (filesInDir.length != 0) {
                Arrays.sort(filesInDir);
                for (int i = 0; i < filesInDir.length; ++i) {
                    GeneratorInvocation.generate(new File(file, (String)filesInDir[i]), targetPath, enableDsbMapping, enableRawMapping);
                }
            } else {
                System.out.println("Keine EDT-DAteien in " + file + " gefunden ...");
            }
        }
    }

    private static String[] removeStringFromPositions(String[] array, int[] posi) {
        String[] returnVelue;
        if (array == null || posi == null) {
            returnVelue = null;
        } else if (array.length <= 1) {
            returnVelue = new String[]{};
        } else {
            int i;
            returnVelue = new String[array.length - posi.length];
            int[] marks = new int[returnVelue.length];
            int markerpos = 0;
            for (i = 0; i < array.length; ++i) {
                boolean add = true;
                for (int d = 0; d < posi.length; ++d) {
                    if (posi[d] != i) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                marks[markerpos] = i;
                ++markerpos;
            }
            for (i = 0; i < marks.length; ++i) {
                returnVelue[i] = array[marks[i]];
            }
        }
        return returnVelue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(File file, File targetPath, boolean dsbCheck, boolean rawCheck) throws Exception {
        MetaPlausibilisierung plausi = null;
        try (FileReader in = new FileReader(file);){
            System.out.println("Parsen der Eingabe-Datei " + file + " ...");
            IntermediateLanguageParser parser = new IntermediateLanguageParser();
            plausi = (MetaPlausibilisierung)parser.parse(in);
        }
        try {
            CodegenFacade generator = new CodegenFacade();
            generator.generate(plausi, targetPath.getAbsolutePath(), dsbCheck, rawCheck);
        }
        catch (CodegenException exc) {
            System.err.println("Bei der Code-Erzeugung von " + file + " sind Fehler/Warnungen aufgetreten:");
            System.err.println(exc.getMessage());
            System.err.println(exc.errorsAsText());
            System.err.println(exc.warningsAsText());
            if (exc.hasErrors()) {
                System.exit(1);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            System.exit(1);
        }
    }
}

