/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.HelperVisitorAdapter;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.ErrorMessage;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.common.WarningMessage;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class AbstractCodeGenerator
extends AbstractElementVisitor
implements HelperVisitorAdapter {
    private static final String INDENT = "   ";
    private int indentLevel = 0;
    private CodegenException codegenExc = null;
    private MessageContextInterface errorContext = null;
    protected PrintWriter out = new PrintWriter(System.out, true);
    protected OutputStream ostream = null;

    public void setOutput(Writer aWriter) {
        this.ostream = null;
        this.out = new PrintWriter(aWriter, true);
    }

    public void setOutputStream(OutputStream stream) {
        this.ostream = stream;
        this.out = new PrintWriter((Writer)new OutputStreamWriter(stream), true);
    }

    public void print(String text) {
        this.out.print(text);
    }

    public void print(int number) {
        this.out.print(number);
    }

    public void flush() {
        this.out.flush();
    }

    public void setIndentLevel(int level) {
        this.indentLevel = level;
    }

    public void setErrorContext(MessageContextInterface context) {
        this.errorContext = context;
    }

    public void setErrorContext(String context) {
        this.errorContext = new DefaultMessageContext(context);
    }

    @Override
    public Scope hvScope() {
        return null;
    }

    @Override
    public String hvNamespace() {
        return "__root-namespace__";
    }

    @Override
    public PrintWriter hvOut() {
        return this.out;
    }

    @Override
    public void hvIndentNewLine() {
        this.indentNewLine();
    }

    @Override
    public void hvIncreaseIndentLevel() {
        this.increaseIndentLevel();
    }

    @Override
    public void hvDecreaseIndentLevel() {
        this.decreaseIndentLevel();
    }

    @Override
    public void hvError(MetaElement element, String message) {
        this.error(element, message);
    }

    @Override
    public void hvWarning(MetaElement element, String message) {
        this.warning(element, message);
    }

    protected void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.out.print(INDENT);
        }
    }

    protected void newLine() {
        this.out.print('\n');
    }

    protected void indentNewLine() {
        this.out.print('\n');
        this.indent();
    }

    protected void increaseIndentLevel() {
        ++this.indentLevel;
    }

    protected void decreaseIndentLevel() {
        --this.indentLevel;
    }

    protected int indentLevel() {
        return this.indentLevel;
    }

    protected void checkForErrors() {
        this.checkForErrors(false);
    }

    protected void checkForErrors(boolean ignoreWarnings) {
        if (this.codegenExc != null && (this.codegenExc.hasErrors() || this.codegenExc.hasWarnings() && !ignoreWarnings)) {
            throw this.codegenExc;
        }
    }

    protected void error(MetaElement anElement, String message) {
        this.error(message, anElement.startLine(), anElement.startColumn());
    }

    protected void error(String message, int startLine, int startColumn) {
        if (this.errorContext != null) {
            this.error(new ErrorMessage(this.errorContext, message, startLine, startColumn));
        } else {
            this.error(new ErrorMessage(message, startLine, startColumn));
        }
    }

    protected void error(ErrorMessage errorMessage) {
        if (this.codegenExc == null) {
            this.codegenExc = new CodegenException("Es sind Fehler oder Warnungen vorhanden.");
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException("Fehlermeldung darf nicht null sein.");
        }
        this.codegenExc.addError(errorMessage);
    }

    protected void warning(MetaElement anElement, String message) {
        if (this.errorContext != null) {
            this.warning(new WarningMessage(this.errorContext, message, anElement.startLine(), anElement.startColumn()));
        } else {
            this.warning(new WarningMessage(message, anElement.startLine(), anElement.startColumn()));
        }
    }

    protected void warning(WarningMessage warningMessage) {
        if (this.codegenExc == null) {
            this.codegenExc = new CodegenException("Es sind Fehler oder Warnungen vorhanden.");
        }
        if (warningMessage == null) {
            throw new IllegalArgumentException("Warnhinweis darf nicht null sein.");
        }
        this.codegenExc.addWarning(warningMessage);
    }
}

