/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.mapping.util.AttributesGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.ConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.DSBAttributesGenererator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.DSBConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.MappingDataGenerator;
import de.statspez.pleditor.generator.codegen.mapping.MappingUtil;
import de.statspez.pleditor.generator.codegen.support.DSBStructureBuilder;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomEinzelfeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class MappingDSBDataGenerator
extends MappingDataGenerator {
    public static final String PREFIX = "DSB_";
    private String className;
    private CodegenContext contex;

    public MappingDSBDataGenerator(CodegenContext contex) {
        this.className = this.getPrefix() + StringHelper.getEscapedName(contex.getPlausiClassName());
        this.contex = contex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(MetaDsbObjekt anObject) {
        String filename = this.className + ".java";
        Writer writer = this.contex.createWriter(filename);
        try {
            this.setOutput(writer);
            this.createImports(this.contex.getPlausiPackage());
            this.createClassNotOpen(this.className, "TopicField", anObject, false);
            this.visitElementsStufe1(anObject.getComps().getCompList());
            this.visitElements(anObject.getComps().getSatzList());
            this.closeBlock();
            this.out.flush();
        }
        finally {
            this.contex.destroyWriter(filename, writer);
        }
    }

    @Override
    public void visitEinzelfeld(MetaEinzelfeld anObject) {
        if (DSBStructureBuilder.istStrukturTyp(anObject.getTyp())) {
            this.visitElements(((MetaCustomEinzelfeld)anObject).getCompList());
            String name = this.structurePrefix + MappingUtil.encodeName(anObject.getName());
            this.createClass(anObject, name, "TopicField");
        }
    }

    @Override
    public void visitSatzart(MetaSatzart anObject) {
        String name = MappingUtil.encodeName(anObject.getName());
        this.structurePrefix = name + "_";
        this.visitElementsStufe1(anObject.getFelder());
        this.createClass(anObject, name, "TopicField");
        this.structurePrefix = "";
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    protected void visitElementsStufe1(Iterator it) {
        assert (it != null) : "Iterator ist null";
        while (it.hasNext()) {
            MetaElement e = (MetaElement)it.next();
            if (e == null || !(e instanceof MetaCustomEinzelfeld) || ((MetaCustomEinzelfeld)e).getStufenNr() != 1) continue;
            e.accept(this);
        }
    }

    @Override
    protected AttributesGenerator attributesGenerator(PrintWriter out) {
        return new DSBAttributesGenererator(out);
    }

    @Override
    protected ConstructorGenerator constructorGenerator(PrintWriter out) {
        return new DSBConstructorGenerator(out);
    }

    @Override
    protected void generateSpecialMethods(Object dsbObject) {
        if (dsbObject instanceof MetaDsbObjekt) {
            MetaDsbObjekt dsb = (MetaDsbObjekt)dsbObject;
            this.defineMethod("public", "StructureDescriptor", "getStructure", "");
            this.indentNewLine();
            this.out.print("return StructureDescriptor.create(new StructureDescriptor[]");
            this.openBlock();
            dsb.accept(new AbstractElementVisitor(){
                private short level = 1;

                @Override
                public void visitDsbObjekt(MetaDsbObjekt dsb) {
                    this.visitElements(dsb.getComps().getCompList());
                    this.visitElements(dsb.getComps().getSatzList());
                }

                @Override
                public void visitEinzelfeld(MetaEinzelfeld einzelfeld) {
                    if (einzelfeld.getStufenNr() == this.level) {
                        MappingDSBDataGenerator.this.indentNewLine();
                        if (DSBStructureBuilder.istStrukturTyp(einzelfeld.getTyp())) {
                            MappingDSBDataGenerator.this.out.print("StructureDescriptor.fieldGroup(\"" + einzelfeld.getName() + "\", new StructureDescriptor[]");
                            MappingDSBDataGenerator.this.openBlock();
                            this.level = (short)(this.level + 1);
                            this.visitElements(((MetaCustomEinzelfeld)einzelfeld).getCompList());
                            this.level = (short)(this.level - 1);
                            MappingDSBDataGenerator.this.closeBlock();
                            MappingDSBDataGenerator.this.out.print("),");
                        } else {
                            MappingDSBDataGenerator.this.out.print("StructureDescriptor.field(\"" + einzelfeld.getName() + "\"),");
                        }
                    }
                }

                @Override
                public void visitSatzart(MetaSatzart satzart) {
                    MappingDSBDataGenerator.this.indentNewLine();
                    MappingDSBDataGenerator.this.out.print("StructureDescriptor.record(\"" + satzart.getName() + "\", new StructureDescriptor[]");
                    MappingDSBDataGenerator.this.openBlock();
                    this.visitElements(satzart.getFelder());
                    MappingDSBDataGenerator.this.closeBlock();
                    MappingDSBDataGenerator.this.out.print("),");
                }
            });
            this.closeBlock();
            this.out.print(");");
            this.closeBlock();
        }
    }
}

