/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.analysis.PruefschluesselErmittler;
import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class PlausiFehlerIdsGenerator
extends JavaCodeGenerator {
    private static final String GET_FEHLER_IDS_METHOD = "getPlausiFehlerIds";
    private static final String ADD_FEHLER_IDS_METHOD = "addPlausiFehlerIds";
    private static final String FLOW_VAR = "ablauf";
    private static final String IDS_VAR = "ids";
    private static final String VECTOR_CLASS_NAME = Vector.class.getName();
    private CodegenContext context;
    private int numOfIds;
    private Stack segments;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.numOfIds = 0;
        this.segments = new Stack();
        PruefschluesselErmittler schluesselErmittler = new PruefschluesselErmittler();
        this.defineMethod("public", "String[]", GET_FEHLER_IDS_METHOD, "String ablauf");
        Iterator iter = ((MetaCustomPlausibilisierung)this.context.getPlausi()).rootThemenbereich().getAblaeufe();
        while (iter.hasNext()) {
            boolean outsouced;
            MetaPLAblauf ablauf = (MetaPLAblauf)iter.next();
            String[] pruefschluessel = schluesselErmittler.ermittlePruefschluessel(ablauf);
            int numOfSegments = this.segments.size();
            this.indentNewLine();
            this.out.print("if (\"");
            this.out.print(ablauf.getName());
            this.out.print("\".equals(ablauf))");
            this.openBlock();
            this.indentNewLine();
            this.out.print(VECTOR_CLASS_NAME);
            this.out.print(" ids = new ");
            this.out.print(VECTOR_CLASS_NAME);
            this.out.print("();");
            for (int i = 0; i < pruefschluessel.length; ++i) {
                this.startNewOutsourcedSegmentIfNecessary();
                this.indentNewLine();
                this.out.print("ids.add(\"");
                this.out.print(pruefschluessel[i]);
                this.out.print("\");");
            }
            boolean bl = outsouced = this.segments.size() - numOfSegments > 0;
            while (this.segments.size() > numOfSegments) {
                this.closeCurrentSegment();
            }
            this.indentNewLine();
            this.out.print("return (String[])ids.toArray(new String[0]);");
            this.closeBlock();
            if (!outsouced || !iter.hasNext()) continue;
            this.startNewSplittedSegment();
        }
        this.indentNewLine();
        this.out.print("throw new IllegalArgumentException(\"Ungueltiger Ablauf \" + ");
        this.out.print(FLOW_VAR);
        this.out.print(");");
        while (this.withinSegment()) {
            this.closeCurrentSegment();
        }
        this.endMethodDefinition();
    }

    private void startNewOutsourcedSegmentIfNecessary() {
        if (this.numOfIds >= this.context.getMaxElementsInSegment(4)) {
            this.numOfIds = 1;
            String className = this.context.getNextPlausiSegmentClassName();
            this.indentNewLine();
            this.out.print(className);
            this.out.print(".");
            this.out.print(ADD_FEHLER_IDS_METHOD);
            this.out.print("(");
            this.out.print(IDS_VAR);
            this.out.print(");");
            String filename = className + ".java";
            Writer writer = this.context.createWriter(filename);
            this.segments.push(new SegmentInfo(filename, writer, this.out, this.indentLevel()));
            this.setOutput(writer);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.defineClass(className, "public", null);
            this.defineMethod("public static", "void", ADD_FEHLER_IDS_METHOD, VECTOR_CLASS_NAME + " " + IDS_VAR);
        } else {
            ++this.numOfIds;
        }
    }

    private void startNewSplittedSegment() {
        this.numOfIds = 1;
        String className = this.context.getNextPlausiSegmentClassName();
        this.indentNewLine();
        this.out.print("return ");
        this.out.print(className);
        this.out.print(".");
        this.out.print(GET_FEHLER_IDS_METHOD);
        this.out.print("(");
        this.out.print(FLOW_VAR);
        this.out.print(");");
        String filename = className + ".java";
        Writer writer = this.context.createWriter(filename);
        this.segments.push(new SegmentInfo(filename, writer, this.out, this.indentLevel()));
        this.setOutput(writer);
        this.setIndentLevel(0);
        this.out.print("package ");
        this.out.print(this.context.getPlausiPackage());
        this.out.print(";");
        this.indentNewLine();
        this.defineClass(className, "public", null);
        this.defineMethod("public static", "String[]", GET_FEHLER_IDS_METHOD, "String ablauf");
    }

    private void closeCurrentSegment() {
        if (this.withinSegment()) {
            this.endMethodDefinition();
            this.endClassDefinition();
            this.out.flush();
            SegmentInfo segment = (SegmentInfo)this.segments.pop();
            this.context.destroyWriter(segment.filename, segment.writer);
            this.out = segment.previousOut;
            this.setIndentLevel(segment.previousIndentLevel);
        }
    }

    private boolean withinSegment() {
        return !this.segments.isEmpty();
    }

    private class SegmentInfo {
        public String filename;
        public Writer writer;
        public PrintWriter previousOut;
        private int previousIndentLevel;

        public SegmentInfo(String filename, Writer writer, PrintWriter previousOut, int previousIndentLevel) {
            this.filename = filename;
            this.writer = writer;
            this.previousOut = previousOut;
            this.previousIndentLevel = previousIndentLevel;
        }
    }
}

