/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;

public class MehrfachantwortProgramCodeGenerator
extends JavaCodeGenerator {
    public void generate(MetaMerkmal merkmal) {
        String programName = "Merkmal_" + StringHelper.getEscapedName(merkmal.getName());
        MetaAuspraegungsgruppe values = merkmal.getKlasseWertebereich();
        int count = CodegenUtil.getAuspraegungenCount(values);
        MetaAuspraegungsgruppe missingValues = merkmal.getKlasseFehlwerte();
        this.indentNewLine();
        this.out.print("public Value ");
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(");
        this.out.print("PlausiRuntimeContext");
        this.out.print(" context, Array array)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context.startNewPruefSection(\"Merkmal ");
        this.out.print(StringHelper.getEscapedStringValue(merkmal.getName()));
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("boolean empty = true;");
        }
        if (missingValues != null) {
            this.indentNewLine();
            this.out.print("boolean missingValue = false;");
        }
        this.indentNewLine();
        this.out.print("for (int i = 0; i < ");
        this.out.print(count);
        this.out.print("; i++)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("FeatureVariable field = (FeatureVariable) array.getElement(context, new int[] {i});");
        this.indentNewLine();
        this.out.print("Value value = new MerkmalCheckFeatureVariable(field).get(context);");
        this.indentNewLine();
        this.out.print("if (InvalidValue.instance().ne(value))");
        this.openBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("empty = false;");
        }
        this.indentNewLine();
        this.out.print("if (");
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(context, field).asBoolean())");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return BooleanValue.TRUE;");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("else");
        this.openBlock();
        this.indentNewLine();
        if (missingValues != null) {
            this.out.print("if (i == 0)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("if (classificationByCode(\"#");
            this.out.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.out.print("\").contains(value))");
            this.openBlock();
            this.indentNewLine();
            this.out.print("missingValue = true;");
            this.closeBlock();
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
        } else {
            this.out.print("if (i > 0)");
        }
        this.openBlock();
        if (missingValues != null) {
            this.indentNewLine();
            this.out.print("if (missingValue || classificationByCode(\"#");
            this.out.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.out.print("\").contains(value))");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context.setCurrentField(field);");
            this.error(programName, 6, false);
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
            this.openBlock();
        }
        this.indentNewLine();
        this.out.print("for (int j = 0; j < i; j++)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("FeatureVariable prevField = (FeatureVariable) array.getElement(context, new int[] {j});");
        this.indentNewLine();
        this.out.print("Value prevValue = new MerkmalCheckFeatureVariable(prevField).get(context);");
        this.indentNewLine();
        this.out.print("if (InvalidValue.instance().ne(prevValue) && value.eq(prevValue))");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context.setCurrentField(field);");
        this.error(programName, 5, false);
        this.closeBlock();
        this.closeBlock();
        if (missingValues != null) {
            this.closeBlock();
        }
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("if (empty)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context.setCurrentField((FeatureVariable) array.getElement(context, new int[] {0}));");
            this.error(programName, 1, false);
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("return BooleanValue.FALSE;");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (Exception e)");
        this.openBlock();
        this.error(programName, 0, true);
        this.closeBlock();
        this.indentNewLine();
        this.out.print("finally");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context.setCurrentField(null);");
        this.indentNewLine();
        this.out.print("context.leaveCurrentSection();");
        this.closeBlock();
        this.closeBlock();
    }

    private void error(String programName, int errorType, boolean exceptionThrown) {
        this.indentNewLine();
        this.out.print("context.getLogger().trace(\"Fehler angeschrieben");
        if (exceptionThrown) {
            this.out.print(" (wg. Exception)");
        }
        this.out.print(": ");
        this.out.print(programName);
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler_");
        this.out.print(programName);
        this.out.print("(context, ");
        this.out.print(errorType);
        this.out.print(", ");
        this.out.print(exceptionThrown ? "e" : "null");
        this.out.print(");");
        this.indentNewLine();
        this.out.print("return BooleanValue.TRUE;");
    }
}

