/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.Precondition;
import de.statspez.pleditor.generator.codegen.html.UsedPlFunctionsExtractor;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForEachStatement;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PreconditionRefelementsExtractor
extends Traverser {
    private List<MetaElement> refelements;

    protected List<MetaElement> extractRefelements(Collection<Precondition> preconditions) {
        this.refelements = new ArrayList<MetaElement>();
        for (Precondition precondition : preconditions) {
            precondition.getStatement().accept(this);
        }
        return this.refelements;
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        aStatement.condition().accept(this);
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        aStatement.endCondition().accept(this);
        aStatement.stepExpression().accept(this);
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.traverseForEachStatement(aStatement);
    }

    @Override
    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.traverseForEachStatement(aStatement);
        aStatement.condition().accept(this);
    }

    @Override
    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        aStatement.value().accept(this);
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        aStatement.condition().accept(this);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion anObject) {
        if (!this.refelements.contains(anObject)) {
            this.refelements.add(anObject);
            List<MetaElement> subelements = new UsedPlFunctionsExtractor().getUsedPlFunctions(((MetaCustomFunktion)anObject).getMetaSpezifikation());
            for (MetaElement element : subelements) {
                if (this.refelements.contains(element)) continue;
                this.refelements.add(element);
            }
        }
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung anObject) {
        if (!this.refelements.contains(anObject)) {
            this.refelements.add(anObject);
            List<MetaElement> subelements = new UsedPlFunctionsExtractor().getUsedPlFunctions(((MetaCustomPruefung)anObject).getMetaSpezifikation());
            for (MetaElement element : subelements) {
                if (this.refelements.contains(element)) continue;
                this.refelements.add(element);
            }
        }
    }

    @Override
    public void visitFunctionCall(MetaFunctionCall aStatement) {
        MetaElement referredElement = aStatement.referredElement();
        if (referredElement != null && !InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
            referredElement.accept(this);
        }
        super.visitFunctionCall(aStatement);
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aStatement.referredElement();
        pruefung.accept(this);
    }

    private void traverseForEachStatement(MetaForEachStatement aStatement) {
        this.visitElements(aStatement.variables());
        aStatement.value().accept(this);
        for (MetaElement e : aStatement.restrictions()) {
            if (e == null) continue;
            e.accept(this);
        }
    }
}

