/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.AssignmentNameExtractor;
import de.statspez.pleditor.generator.codegen.html.Precondition;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PreconditionFieldsExtractor
extends Traverser {
    private Collection<String> fields;
    private Precondition currentPrecondition;

    public Collection<String> extractFields(Collection<Precondition> preconditions) {
        this.fields = new ArrayList<String>();
        Iterator<Precondition> iterator = preconditions.iterator();
        while (iterator.hasNext()) {
            Precondition precondition;
            this.currentPrecondition = precondition = iterator.next();
            this.currentPrecondition.getStatement().accept(this);
        }
        return this.fields;
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        MetaFactor condition = aStatement.condition();
        condition.accept(this);
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        aStatement.stepExpression().accept(this);
        aStatement.endCondition().accept(this);
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.visitElements(aStatement.variables());
        this.visitElements(aStatement.restrictions().iterator());
        aStatement.value().accept(this);
    }

    @Override
    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.visitElements(aStatement.variables());
        this.visitElements(aStatement.restrictions().iterator());
        aStatement.condition().accept(this);
    }

    @Override
    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        aStatement.value().accept(this);
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        MetaFactor condition = aStatement.condition();
        condition.accept(this);
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
        String setzungName = setzungNameGenerator.getAssignmentName(aFieldAccess, this.currentPrecondition.getAblaufSpezifikation());
        if (aFieldAccess.referredElement() == null) {
            this.addToFields(setzungName + "@" + this.currentPrecondition.getAblauf().getName());
        } else {
            this.addToFields(setzungName);
        }
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
        String setzungName = setzungNameGenerator.getAssignmentName(aStructureAccess, this.currentPrecondition.getAblaufSpezifikation());
        this.addToFields(setzungName);
        aStructureAccess.accept(new Traverser(){

            @Override
            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                PreconditionFieldsExtractor.this.visitElements(anArrayAccess.indices());
            }
        });
    }

    private void addToFields(String field) {
        String fieldWithNamespace = "";
        if (this.currentPrecondition.getNamespace() != null && this.currentPrecondition.getNamespace().length() > 0) {
            fieldWithNamespace = this.currentPrecondition.getNamespace() + ".";
        }
        if (!this.fields.contains(fieldWithNamespace = fieldWithNamespace + field)) {
            this.fields.add(fieldWithNamespace);
        }
    }
}

