/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.AssignmentNameExtractor;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import java.util.ArrayList;
import java.util.Collection;

public class FieldsExtractor
extends Traverser {
    private Collection<String> fields;
    private MetaCustomAblauf ablauf;
    private String namespace;

    public Collection<String> extractFields(MetaElement metaElement, MetaCustomAblauf ablauf, String namespace) {
        this.ablauf = ablauf;
        this.namespace = namespace;
        this.fields = new ArrayList<String>();
        metaElement.accept(this);
        return this.fields;
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
        String setzungName = setzungNameGenerator.getAssignmentName(aFieldAccess, this.ablauf.getSpezifikation());
        if (aFieldAccess.referredElement() == null) {
            this.addToFields(setzungName + "@" + this.ablauf.getName());
        } else {
            this.addToFields(setzungName);
        }
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
        String setzungName = setzungNameGenerator.getAssignmentName(aStructureAccess, this.ablauf.getSpezifikation());
        this.addToFields(setzungName);
        aStructureAccess.accept(new Traverser(){

            @Override
            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                FieldsExtractor.this.visitElements(anArrayAccess.indices());
            }
        });
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
        String setzungName = setzungNameGenerator.getAssignmentName(anArrayAccess, this.ablauf.getSpezifikation());
        this.addToFields(setzungName);
        this.visitElements(anArrayAccess.indices());
    }

    private void addToFields(String field) {
        String fieldWithNamespace = field;
        if (this.namespace != null && this.namespace.length() > 0) {
            fieldWithNamespace = this.namespace + "." + field;
        }
        if (!this.fields.contains(fieldWithNamespace)) {
            this.fields.add(fieldWithNamespace);
        }
    }
}

