/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class BaseStat {
    protected ArrayList elementList = null;
    protected Hashtable idElementTable = new Hashtable();
    protected HashSet fehlerHafteElemente = new HashSet();

    public void deleteLists() {
        this.elementList = null;
    }

    public int getCount() {
        return this.idElementTable.size();
    }

    public DokuElement getElement(String iD) {
        return (DokuElement)this.idElementTable.get(iD);
    }

    public List getElements(Collection ids) throws IllegalArgumentException {
        ArrayList<DokuElement> result = new ArrayList<DokuElement>(ids.size());
        for (String id : ids) {
            DokuElement de = this.getElement(id);
            if (de == null) {
                throw new IllegalArgumentException("Element mit der ID " + id + " wurde nicht gefunden.");
            }
            result.add(de);
        }
        Collections.sort(result);
        return result;
    }

    public ArrayList getElementList() {
        if (this.elementList == null) {
            return new ArrayList(this.idElementTable.values());
        }
        return this.elementList;
    }

    public HashSet getIDs() {
        HashSet tmpSet = new HashSet(this.idElementTable.keySet());
        return tmpSet;
    }

    public void initializeLists() {
        this.initializeLists(false);
    }

    public void initializeLists(boolean force) {
        if (this.elementList == null || force) {
            this.elementList = new ArrayList();
            this.elementList.addAll(this.idElementTable.values());
        }
    }

    public ArrayList resolveIds(Collection iDs) {
        ArrayList<DokuElement> tmpList = new ArrayList<DokuElement>();
        Iterator it = iDs.iterator();
        while (it.hasNext()) {
            tmpList.add(this.getElement((String)it.next()));
        }
        return tmpList;
    }

    public void sortLists() {
        this.initializeLists();
        this.sortListsOnly();
    }

    public void sortListsOnly() {
        Collections.sort(this.elementList);
    }

    public List getFehlerhafteElementeAsList(boolean sortList) {
        ArrayList list = new ArrayList(this.fehlerHafteElemente);
        if (sortList) {
            Collections.sort(list);
        }
        return list;
    }

    public int getFehlerhafteElementeCount() {
        return this.fehlerHafteElemente.size();
    }
}

