/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class DiffUITreeNode
implements TreeNode {
    private List childNodes = null;
    private List childUIAllNodes = null;
    private List childUIVisibleNodes = null;
    private DiffResultTreeNode diffResultTreeNode = null;
    private DiffUITreeNode parent = null;
    private Comparator comparator = null;

    DiffUITreeNode(DiffUITreeNode parent, DiffResultTreeNode diffResultTreeNode) {
        if (diffResultTreeNode == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.diffResultTreeNode = diffResultTreeNode;
        this.childNodes = this.diffResultTreeNode.getChildNodes();
        this.initChildren();
    }

    public Enumeration children() {
        return new Enumeration(){
            private int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < DiffUITreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return DiffUITreeNode.this.getChildAt(this.count++);
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childUIVisibleNodes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.childUIVisibleNodes.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.childUIVisibleNodes.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.childNodes.size() == 0;
    }

    public String toString() {
        return this.diffResultTreeNode.toString();
    }

    DiffResultTreeNode getDiffResultTreeNode() {
        return this.diffResultTreeNode;
    }

    void hideNoDiff(boolean hide, DiffConfig diffConfig) {
        Iterator iterator = this.childUIAllNodes.iterator();
        this.childUIVisibleNodes.clear();
        while (iterator.hasNext()) {
            DiffUITreeNode diffUINode = (DiffUITreeNode)iterator.next();
            DiffResultTreeNode diffResultNode = diffUINode.getDiffResultTreeNode();
            boolean add = true;
            if (hide && !diffResultNode.isHeaderNode()) {
                add = this.hasRelevantDiffs(diffResultNode, diffConfig);
            }
            if (!add) continue;
            this.childUIVisibleNodes.add(diffUINode);
        }
        if (this.comparator != null) {
            Collections.sort(this.childUIVisibleNodes, this.comparator);
        }
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DiffUITreeNode child = (DiffUITreeNode)enumeration.nextElement();
            child.hideNoDiff(hide, diffConfig);
        }
    }

    private boolean hasRelevantDiffs(DiffResultTreeNode diffResultNode, DiffConfig diffConfig) {
        boolean hasDiffs = false;
        List diffs = diffResultNode.getDiffResults();
        if (diffs != null && diffs.size() > 0) {
            if (diffConfig == null) {
                hasDiffs = true;
            } else {
                for (int i = 0; i < diffs.size(); ++i) {
                    DiffResult diffResult = (DiffResult)diffs.get(i);
                    if (diffConfig.getErrorLevel(diffResult) == 0) continue;
                    hasDiffs = true;
                }
            }
        }
        if (!hasDiffs) {
            List children = diffResultNode.getNodeChildren();
            Iterator iterator = children.iterator();
            while (!hasDiffs && iterator.hasNext()) {
                DiffResultTreeNode child = (DiffResultTreeNode)iterator.next();
                hasDiffs = this.hasRelevantDiffs(child, diffConfig);
            }
        }
        return hasDiffs;
    }

    void sortChildren(Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        Collections.sort(this.childUIVisibleNodes, comparator);
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DiffUITreeNode child = (DiffUITreeNode)enumeration.nextElement();
            child.sortChildren(comparator);
        }
    }

    private void initChildren() {
        this.childUIAllNodes = new ArrayList(this.childNodes.size());
        for (DiffResultTreeNode diffResultNode : this.childNodes) {
            DiffUITreeNode diffUINode = new DiffUITreeNode(this, diffResultNode);
            this.childUIAllNodes.add(diffUINode);
        }
        this.childUIVisibleNodes = new ArrayList(this.childNodes.size());
        this.childUIVisibleNodes.addAll(this.childUIAllNodes);
    }
}

