/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffElement;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;

public final class DiffResultElementChanged
extends DiffResult {
    private String attribute = null;
    private String description = null;
    private String value1;
    private String value2;

    DiffResultElementChanged(MetaElement metaElement1, MetaElement metaElement2, String attribute, String value1, String value2, int diffType, int contextType) {
        super(metaElement1, metaElement2, diffType, contextType);
        if (metaElement1 == null || metaElement2 == null || attribute == null) {
            throw new NullPointerException();
        }
        if (attribute.equals("")) {
            throw new IllegalArgumentException("Attribute darf nicht leer sein!");
        }
        this.attribute = attribute;
        this.value1 = value1;
        this.value2 = value2;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    @Override
    public final String getDiffDescription() {
        if (this.description == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(DiffElement.getDiffElement(this.getMetaElement1()).getLongName());
            if (this.getMetaElement1() instanceof MetaStatspezObjekt) {
                buffer.append(" (Name: ");
                buffer.append(((MetaStatspezObjekt)this.getMetaElement1()).getName());
                buffer.append(")");
            }
            buffer.append(" ge\u00e4ndert ['");
            buffer.append(this.attribute);
            buffer.append("': '");
            buffer.append(this.value1);
            buffer.append("' => '");
            buffer.append(this.value2);
            buffer.append("']");
            this.description = buffer.toString();
        }
        return this.description;
    }

    @Override
    public String getDiffDescriptionAsHtmlPart(int width, String columnName1, String columnName2) {
        String rightContent;
        String leftContent;
        if (this.attribute.equals("Spezifikation") || this.attribute.equals("PL-Spezifikation") || this.attribute.equals("Wertebereich")) {
            leftContent = "<code>" + DiffResultElementChanged.replace(DiffResultElementChanged.replace(this.getDifferencesHtmlStyled(this.value1, this.value2), "\n", "<br>"), "  ", "&nbsp; ") + "</code>";
            rightContent = "<code>" + DiffResultElementChanged.replace(DiffResultElementChanged.replace(this.getDifferencesHtmlStyled(this.value2, this.value1), "\n", "<br>"), "  ", "&nbsp; ") + "</code>";
        } else {
            leftContent = this.getDifferencesHtmlStyled(this.value1, this.value2);
            rightContent = this.getDifferencesHtmlStyled(this.value2, this.value1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<p>Attribut <b>").append(this.attribute).append("</b> ge\u00e4ndert</p><br>");
        sb.append("<table cellspacing=\"0\" cellpadding=\"5px\" style=\"width: ").append((double)width * 0.77).append("px;\">");
        if (columnName1 != null || columnName2 != null) {
            sb.append("<tr>");
            sb.append("<th style=\"border-left: 1px solid silver; border-top: 1px solid silver; border-right: 1px solid silver;\">");
            if (columnName1 != null) {
                sb.append(columnName1);
            }
            sb.append("</th>");
            sb.append("<th style=\"border-top: 1px solid silver; border-right: 1px solid silver;\">");
            if (columnName2 != null) {
                sb.append(columnName2);
            }
            sb.append("</th>");
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append("<td valign=\"top\" style=\"border-left: 1px solid silver; border-top: 1px solid silver; border-right: 1px solid silver; border-bottom: 1px solid silver;\">").append(leftContent).append("</td>");
        sb.append("<td valign=\"top\" style=\"border-top: 1px solid silver; border-right: 1px solid silver; border-bottom: 1px solid silver;\">").append(rightContent).append("</td>");
        sb.append("</tr> ");
        sb.append("</table>");
        return sb.toString();
    }

    private String getDifferencesHtmlStyled(String from, String to) {
        StringBuffer builder = new StringBuffer();
        if (from != null && from.length() > 0) {
            if (to != null && to.length() > 0) {
                int start;
                char[] fromChars = from.toCharArray();
                char[] toChars = to.toCharArray();
                for (start = 0; start < fromChars.length && start < toChars.length && fromChars[start] == toChars[start]; ++start) {
                }
                int end = fromChars.length - 1;
                if (start < fromChars.length) {
                    int i = toChars.length - 1;
                    while (end >= start && fromChars[end] == toChars[i]) {
                        --end;
                        --i;
                    }
                }
                if (start > 0) {
                    builder.append(fromChars, 0, start);
                }
                if (end >= start) {
                    builder.append("<span style=\"background-color: yellow;\">");
                    builder.append(fromChars, start, end - start + 1);
                    builder.append("</span>");
                }
                if (end + 1 < fromChars.length) {
                    builder.append(fromChars, end + 1, fromChars.length - end - 1);
                }
            } else {
                builder.append("<span style=\"background-color: yellow;\">");
                builder.append(from);
                builder.append("</span>");
            }
        }
        return builder.toString();
    }

    private static String replace(String string, String from, String to) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            if (string.startsWith(from, i)) {
                buffer.append(to);
                i += from.length();
                continue;
            }
            buffer.append(string.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    public final String getValue1() {
        return this.value1;
    }

    public final String getValue2() {
        return this.value2;
    }
}

