/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;

public class CppMehrfachantwortProgramCodeGenerator
extends CppCodeGenerator {
    public void generate(MetaMerkmal merkmal) {
        String programName = "Merkmal_" + StringHelper.getEscapedName(merkmal.getName());
        MetaAuspraegungsgruppe values = merkmal.getKlasseWertebereich();
        int count = CodegenUtil.getAuspraegungenCount(values);
        MetaAuspraegungsgruppe missingValues = merkmal.getKlasseFehlwerte();
        this.indentNewLine();
        this.out.print("Value* ");
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(");
        this.out.print("RuntimeContext*");
        this.out.print(" context, FieldArray* array)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context->startNewSection(\"Merkmal ");
        this.out.print(StringHelper.getEscapedStringValue(merkmal.getName()));
        this.out.print("\", PL_TRUE);");
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("PL_BOOL empty = PL_TRUE;");
        }
        if (missingValues != null) {
            this.indentNewLine();
            this.out.print("PL_BOOL missingValue = PL_FALSE;");
        }
        this.indentNewLine();
        this.out.print("for (PL_NUMBER i = 0; i < ");
        this.out.print(count);
        this.out.print("; i++)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("Field* field = array->getElement(context, 1, i);");
        this.indentNewLine();
        this.out.print("Value* value = FeatureField(field).get(context);");
        this.indentNewLine();
        this.out.print("if (context->createInvalidValue()->ne(value))");
        this.openBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("empty = PL_FALSE;");
        }
        this.indentNewLine();
        this.out.print("if (");
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(context, field)->asBool())");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return context->createBoolValue(PL_TRUE);");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("else");
        this.openBlock();
        this.indentNewLine();
        if (missingValues != null) {
            this.out.print("if (i == 0)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("if (classificationByCode(\"#");
            this.out.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.out.print("\")->contains(value))");
            this.openBlock();
            this.indentNewLine();
            this.out.print("missingValue = PL_TRUE;");
            this.closeBlock();
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
        } else {
            this.out.print("if (i > 0)");
        }
        this.openBlock();
        if (missingValues != null) {
            this.indentNewLine();
            this.out.print("if (missingValue || classificationByCode(\"#");
            this.out.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.out.print("\")->contains(value))");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context->setCurrentField(field);");
            this.error(programName, 6, false);
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
            this.openBlock();
        }
        this.indentNewLine();
        this.out.print("for (PL_NUMBER j = 0; j < i; j++)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("Field* prevField = array->getElement(context, 1, j);");
        this.indentNewLine();
        this.out.print("Value* prevValue = FeatureField(prevField).get(context);");
        this.indentNewLine();
        this.out.print("if (context->createInvalidValue()->ne(prevValue) && value->eq(prevValue))");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context->setCurrentField(field);");
        this.error(programName, 5, false);
        this.closeBlock();
        this.closeBlock();
        if (missingValues != null) {
            this.closeBlock();
        }
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.out.print("if (empty)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context->setCurrentField(array->getElement(context, 1, 0));");
            this.error(programName, 1, false);
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("context->setCurrentField(PL_NULL);");
        this.indentNewLine();
        this.out.print("context->leaveCurrentSection();");
        this.indentNewLine();
        this.out.print("return context->createBoolValue(PL_FALSE);");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (PlausiException& e)");
        this.openBlock();
        this.error(programName, 0, true);
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (...)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("PlausiException e;");
        this.error(programName, 0, true);
        this.closeBlock();
        this.closeBlock();
    }

    private void error(String programName, int errorType, boolean exceptionThrown) {
        this.indentNewLine();
        this.out.print("context->getLogger()->error() << \"Fehler w\u00e4hrend Ausf\u00fchrung: ");
        this.out.print(programName);
        if (exceptionThrown) {
            this.out.print(" (\" << e.getMessage() << \")");
        }
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("prb_");
        this.out.print(programName);
        this.out.print("(context, ");
        this.out.print(CppSettings.getRuntimeProblemInfoType(errorType));
        if (exceptionThrown) {
            this.out.print(", e.getMessage()");
        }
        this.out.print(");");
        this.indentNewLine();
        this.out.print("context->setCurrentField(PL_NULL);");
        this.indentNewLine();
        this.out.print("context->leaveCurrentSection();");
        this.indentNewLine();
        this.out.print("return context->createBoolValue(PL_TRUE);");
    }
}

