/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.util.AbstractList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeferredNamedListImpl<T extends Named>
extends AbstractList<T>
implements NamedList<T> {
    private final NamedList<T> list = new NamedListImpl();
    private State state = State.NEW;
    protected final XmlaOlap4jConnection.MetadataRequest metadataRequest;
    protected final XmlaOlap4jConnection.Context context;
    protected final XmlaOlap4jConnection.Handler<T> handler;
    protected final Object[] restrictions;
    protected final Semaphore semaphore = new Semaphore(1);

    DeferredNamedListImpl(XmlaOlap4jConnection.MetadataRequest metadataRequest, XmlaOlap4jConnection.Context context, XmlaOlap4jConnection.Handler<T> handler, Object[] restrictions) {
        this.metadataRequest = metadataRequest;
        this.context = context;
        this.handler = handler;
        this.restrictions = restrictions == null ? new Object[]{} : restrictions;
    }

    void reset() {
        this.state = State.NEW;
        this.list.clear();
    }

    private NamedList<T> getList() {
        try {
            this.semaphore.acquire();
            switch (this.state) {
                case POPULATING: {
                    throw new RuntimeException("recursive population");
                }
                case NEW: {
                    try {
                        this.state = State.POPULATING;
                        this.populateList(this.list);
                        this.state = State.POPULATED;
                        break;
                    }
                    catch (Exception e) {
                        this.state = State.NEW;
                        throw new RuntimeException(e);
                    }
                }
            }
            NamedList<T> e = this.list;
            return e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public T get(int index) {
        return (T)((Named)this.getList().get(index));
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    public T get(String name) {
        return (T)((Named)this.getList().get(name));
    }

    public int indexOfName(String name) {
        return this.getList().indexOfName(name);
    }

    public String getName(Object element) {
        return this.getList().getName(element);
    }

    public Map<String, T> asMap() {
        return this.getList().asMap();
    }

    protected void populateList(NamedList<T> list) throws OlapException {
        this.context.olap4jConnection.populateList(list, this.context, this.metadataRequest, this.handler, this.restrictions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEW,
        POPULATING,
        POPULATED;

    }
}

