/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.layout;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.impl.CoordinateIterator;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.layout.CellSetFormatter;
import org.olap4j.metadata.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectangularCellSetFormatter
implements CellSetFormatter {
    private final boolean compact;

    public RectangularCellSetFormatter(boolean compact) {
        this.compact = compact;
    }

    @Override
    public void format(CellSet cellSet, PrintWriter pw) {
        CellSetAxis columnsAxis = cellSet.getAxes().size() > 0 ? cellSet.getAxes().get(0) : null;
        AxisInfo columnsAxisInfo = this.computeAxisInfo(columnsAxis);
        CellSetAxis rowsAxis = cellSet.getAxes().size() > 1 ? cellSet.getAxes().get(1) : null;
        AxisInfo rowsAxisInfo = this.computeAxisInfo(rowsAxis);
        if (cellSet.getAxes().size() > 2) {
            int[] dimensions = new int[cellSet.getAxes().size() - 2];
            for (int i = 2; i < cellSet.getAxes().size(); ++i) {
                CellSetAxis cellSetAxis = cellSet.getAxes().get(i);
                dimensions[i - 2] = cellSetAxis.getPositions().size();
            }
            for (int[] pageCoords : CoordinateIterator.iterate(dimensions)) {
                this.formatPage(cellSet, pw, pageCoords, columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
            }
        } else {
            this.formatPage(cellSet, pw, new int[0], columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
        }
    }

    private void formatPage(CellSet cellSet, PrintWriter pw, int[] pageCoords, CellSetAxis columnsAxis, AxisInfo columnsAxisInfo, CellSetAxis rowsAxis, AxisInfo rowsAxisInfo) {
        int y;
        if (pageCoords.length > 0) {
            pw.println();
            for (int i = pageCoords.length - 1; i >= 0; --i) {
                int pageCoord = pageCoords[i];
                CellSetAxis axis = cellSet.getAxes().get(2 + i);
                pw.print(axis.getAxisOrdinal() + ": ");
                Position position = axis.getPositions().get(pageCoord);
                int k = -1;
                for (Member member : position.getMembers()) {
                    if (++k > 0) {
                        pw.print(", ");
                    }
                    pw.print(member.getUniqueName());
                }
                pw.println();
            }
        }
        int yOffset = columnsAxisInfo.getWidth();
        int xOffsset = rowsAxisInfo.getWidth();
        Matrix matrix = new Matrix(xOffsset + (columnsAxis == null ? 1 : columnsAxis.getPositions().size()), yOffset + (rowsAxis == null ? 1 : rowsAxis.getPositions().size()));
        for (int x = 0; x < xOffsset; ++x) {
            for (int y2 = 0; y2 < yOffset; ++y2) {
                matrix.set(x, y2, "", false, x > 0);
            }
        }
        this.populateAxis(matrix, columnsAxis, columnsAxisInfo, true, xOffsset);
        this.populateAxis(matrix, rowsAxis, rowsAxisInfo, false, yOffset);
        for (Cell cell : RectangularCellSetFormatter.cellIter(pageCoords, cellSet)) {
            List<Integer> coordList = cell.getCoordinateList();
            int x = xOffsset;
            if (coordList.size() > 0) {
                x += coordList.get(0).intValue();
            }
            y = yOffset;
            if (coordList.size() > 1) {
                y += coordList.get(1).intValue();
            }
            matrix.set(x, y, cell.getFormattedValue(), true, false);
        }
        int[] columnWidths = new int[matrix.width];
        int widestWidth = 0;
        for (int x = 0; x < matrix.width; ++x) {
            int columnWidth = 0;
            for (y = 0; y < matrix.height; ++y) {
                MatrixCell cell = matrix.get(x, y);
                if (cell == null) continue;
                columnWidth = Math.max(columnWidth, cell.value.length());
            }
            columnWidths[x] = columnWidth;
            widestWidth = Math.max(columnWidth, widestWidth);
        }
        char[] spaces = new char[widestWidth + 1];
        Arrays.fill(spaces, ' ');
        char[] equals = new char[widestWidth + 1];
        Arrays.fill(equals, '=');
        char[] dashes = new char[widestWidth + 3];
        Arrays.fill(dashes, '-');
        if (this.compact) {
            for (int y3 = 0; y3 < matrix.height; ++y3) {
                int x;
                for (x = 0; x < matrix.width; ++x) {
                    int padding;
                    int len;
                    MatrixCell cell;
                    if (x > 0) {
                        pw.print(' ');
                    }
                    if ((cell = matrix.get(x, y3)) != null) {
                        if (cell.sameAsPrev) {
                            len = 0;
                        } else {
                            if (cell.right) {
                                padding = columnWidths[x] - cell.value.length();
                                pw.write(spaces, 0, padding);
                                pw.print(cell.value);
                                continue;
                            }
                            pw.print(cell.value);
                            len = cell.value.length();
                        }
                    } else {
                        len = 0;
                    }
                    if (x == matrix.width - 1) break;
                    padding = columnWidths[x] - len;
                    pw.write(spaces, 0, padding);
                }
                pw.println();
                if (y3 != yOffset - 1) continue;
                for (x = 0; x < matrix.width; ++x) {
                    if (x > 0) {
                        pw.write(32);
                    }
                    pw.write(equals, 0, columnWidths[x]);
                }
                pw.println();
            }
        } else {
            for (int y4 = 0; y4 < matrix.height; ++y4) {
                int x;
                for (x = 0; x < matrix.width; ++x) {
                    int padding;
                    int len;
                    MatrixCell cell = matrix.get(x, y4);
                    if (cell != null) {
                        if (cell.sameAsPrev) {
                            pw.print("  ");
                            len = 0;
                        } else {
                            pw.print("| ");
                            if (cell.right) {
                                padding = columnWidths[x] - cell.value.length();
                                pw.write(spaces, 0, padding);
                                pw.print(cell.value);
                                pw.print(' ');
                                continue;
                            }
                            pw.print(cell.value);
                            len = cell.value.length();
                        }
                    } else {
                        pw.print("| ");
                        len = 0;
                    }
                    padding = columnWidths[x] - len;
                    pw.write(spaces, 0, ++padding);
                }
                pw.println('|');
                if (y4 != yOffset - 1) continue;
                for (x = 0; x < matrix.width; ++x) {
                    pw.write(43);
                    pw.write(dashes, 0, columnWidths[x] + 2);
                }
                pw.println('+');
            }
        }
    }

    private void populateAxis(Matrix matrix, CellSetAxis axis, AxisInfo axisInfo, boolean isColumns, int offset) {
        if (axis == null) {
            return;
        }
        Member[] prevMembers = new Member[axisInfo.getWidth()];
        Member[] members = new Member[axisInfo.getWidth()];
        for (int i = 0; i < axis.getPositions().size(); ++i) {
            int x = offset + i;
            Position position = axis.getPositions().get(i);
            int yOffset = 0;
            List<Member> memberList = position.getMembers();
            for (int j = 0; j < memberList.size(); ++j) {
                AxisOrdinalInfo ordinalInfo = axisInfo.ordinalInfos.get(j);
                for (Member member = memberList.get(j); member != null && member.getDepth() >= ordinalInfo.minDepth; member = member.getParentMember()) {
                    int y = yOffset + member.getDepth() - ordinalInfo.minDepth;
                    members[y] = member;
                }
                yOffset += ordinalInfo.getWidth();
            }
            boolean same = true;
            for (int y = 0; y < members.length; ++y) {
                String value;
                Member member = members[y];
                same = same && i > 0 && Olap4jUtil.equal(prevMembers[y], member);
                String string = value = member == null ? "" : member.getCaption();
                if (isColumns) {
                    matrix.set(x, y, value, false, same);
                } else {
                    if (same) {
                        value = "";
                    }
                    matrix.set(y, x, value, false, false);
                }
                prevMembers[y] = member;
                members[y] = null;
            }
        }
    }

    private AxisInfo computeAxisInfo(CellSetAxis axis) {
        if (axis == null) {
            return new AxisInfo(0);
        }
        AxisInfo axisInfo = new AxisInfo(axis.getAxisMetaData().getHierarchies().size());
        int p = -1;
        for (Position position : axis.getPositions()) {
            ++p;
            int k = -1;
            for (Member member : position.getMembers()) {
                int topDepth;
                AxisOrdinalInfo axisOrdinalInfo = axisInfo.ordinalInfos.get(++k);
                int n = member.isAll() ? member.getDepth() : (topDepth = member.getHierarchy().hasAll() ? 1 : 0);
                if (axisOrdinalInfo.minDepth > topDepth || p == 0) {
                    axisOrdinalInfo.minDepth = topDepth;
                }
                axisOrdinalInfo.maxDepth = Math.max(axisOrdinalInfo.maxDepth, member.getDepth());
            }
        }
        return axisInfo;
    }

    private static Iterable<Cell> cellIter(final int[] pageCoords, final CellSet cellSet) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                int[] axisDimensions = new int[cellSet.getAxes().size() - pageCoords.length];
                assert (pageCoords.length <= axisDimensions.length);
                for (int i = 0; i < axisDimensions.length; ++i) {
                    CellSetAxis axis = cellSet.getAxes().get(i);
                    axisDimensions[i] = axis.getPositions().size();
                }
                final CoordinateIterator coordIter = new CoordinateIterator(axisDimensions, true);
                return new Iterator<Cell>(){

                    @Override
                    public boolean hasNext() {
                        return coordIter.hasNext();
                    }

                    @Override
                    public Cell next() {
                        final int[] ints = coordIter.next();
                        AbstractList<Integer> intList = new AbstractList<Integer>(){

                            @Override
                            public Integer get(int index) {
                                return index < ints.length ? ints[index] : pageCoords[index - ints.length];
                            }

                            @Override
                            public int size() {
                                return pageCoords.length + ints.length;
                            }
                        };
                        return cellSet.getCell((List<Integer>)intList);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static class MatrixCell {
        final String value;
        final boolean right;
        final boolean sameAsPrev;

        MatrixCell(String value, boolean right, boolean sameAsPrev) {
            this.value = value;
            this.right = right;
            this.sameAsPrev = sameAsPrev;
        }
    }

    private class Matrix {
        private final Map<List<Integer>, MatrixCell> map = new HashMap<List<Integer>, MatrixCell>();
        private final int width;
        private final int height;

        public Matrix(int width, int height) {
            this.width = width;
            this.height = height;
        }

        void set(int x, int y, String value) {
            this.set(x, y, value, false, false);
        }

        void set(int x, int y, String value, boolean right, boolean sameAsPrev) {
            this.map.put(Arrays.asList(x, y), new MatrixCell(value, right, sameAsPrev));
            assert (x >= 0 && x < this.width) : x;
            assert (y >= 0 && y < this.height) : y;
        }

        public MatrixCell get(int x, int y) {
            return this.map.get(Arrays.asList(x, y));
        }
    }

    private static class AxisInfo {
        final List<AxisOrdinalInfo> ordinalInfos;

        AxisInfo(int ordinalCount) {
            this.ordinalInfos = new ArrayList<AxisOrdinalInfo>(ordinalCount);
            for (int i = 0; i < ordinalCount; ++i) {
                this.ordinalInfos.add(new AxisOrdinalInfo());
            }
        }

        public int getWidth() {
            int width = 0;
            for (AxisOrdinalInfo info : this.ordinalInfos) {
                width += info.getWidth();
            }
            return width;
        }
    }

    private static class AxisOrdinalInfo {
        int minDepth = 1;
        int maxDepth = 0;

        private AxisOrdinalInfo() {
        }

        public int getWidth() {
            return this.maxDepth - this.minDepth + 1;
        }
    }
}

