/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mondrian.util.ClassResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDiscovery<T> {
    private static final Log logger = LogFactory.getLog(ServiceDiscovery.class);
    private final Class<T> theInterface;
    private final ClassResolver classResolver;

    public static <T> ServiceDiscovery<T> forClass(Class<T> theInterface) {
        return new ServiceDiscovery<T>(theInterface, ClassResolver.INSTANCE);
    }

    private ServiceDiscovery(Class<T> theInterface, ClassResolver classResolver) {
        this.theInterface = theInterface;
        this.classResolver = classResolver;
        assert (classResolver != null);
        assert (theInterface != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<T>> getImplementor() {
        LinkedHashSet<Class<T>> uniqueClasses = new LinkedHashSet<Class<T>>();
        try {
            String lookupName = "META-INF/services/" + this.theInterface.getName();
            for (URL resourceUrl : this.classResolver.getResources(lookupName)) {
                InputStream is = null;
                try {
                    String clazz;
                    is = resourceUrl.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((clazz = reader.readLine()) != null) {
                        this.parseImplementor(clazz, uniqueClasses);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)("Error while finding service file " + resourceUrl + " for " + this.theInterface), (Throwable)e);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Error while finding service files for " + this.theInterface), (Throwable)e);
        }
        ArrayList<Class<T>> rtn = new ArrayList<Class<T>>();
        rtn.addAll(uniqueClasses);
        return rtn;
    }

    protected void parseImplementor(String clazz, Set<Class<T>> uniqueClasses) {
        assert (clazz != null);
        String[] classList = clazz.trim().split("#");
        String theClass = classList[0].trim();
        if (theClass.length() == 0) {
            return;
        }
        try {
            Class interfaceImplementor = this.classResolver.forName(theClass, false);
            if (this.theInterface.isAssignableFrom(interfaceImplementor)) {
                uniqueClasses.add(interfaceImplementor);
            } else {
                logger.error((Object)("Class " + interfaceImplementor + " cannot be assigned to interface " + this.theInterface));
            }
        }
        catch (ClassNotFoundException ignored) {
            ignored.printStackTrace();
        }
        catch (LinkageError ignored) {
            ignored.printStackTrace();
        }
    }
}

