/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lazy<T> {
    private Util.Function0<T> factory;
    private int state = 0;
    private T value;
    private Throwable throwable;
    private static final int STATE_INIT = 0;
    private static final int STATE_SUCCESS = 1;
    private static final int STATE_RUNTIME_EXCEPTION = 2;
    private static final int STATE_ERROR = 3;

    public Lazy(Util.Function0<T> factory) {
        assert (factory != null);
        this.factory = factory;
    }

    public synchronized T get() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                try {
                    this.value = this.factory.apply();
                }
                catch (RuntimeException e) {
                    this.state = 2;
                    this.throwable = e;
                    throw e;
                }
                catch (Error e) {
                    this.state = 3;
                    this.throwable = e;
                    throw e;
                }
                finally {
                    this.factory = null;
                }
                return this.value;
            }
            case 1: {
                return this.value;
            }
            case 2: {
                throw (RuntimeException)this.throwable;
            }
            case 3: {
                throw (Error)this.throwable;
            }
        }
        throw new AssertionError((Object)("invalid state " + this.state));
    }
}

