/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.util.DelegatingInvocationHandler;

public class MockDialect {
    public static Dialect of(Dialect.DatabaseProduct product) {
        DatabaseMetaData metaData = (DatabaseMetaData)Proxy.newProxyInstance(null, new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DatabaseMetaDataInvocationHandler(product));
        Connection connection = (Connection)Proxy.newProxyInstance(null, new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(metaData));
        Dialect dialect = DialectManager.createDialect(null, connection);
        assert (dialect.getDatabaseProduct() == product);
        return dialect;
    }

    public static class DatabaseMetaDataInvocationHandler
    extends DelegatingInvocationHandler {
        private final Dialect.DatabaseProduct product;

        DatabaseMetaDataInvocationHandler(Dialect.DatabaseProduct product) {
            this.product = product;
        }

        public boolean supportsResultSetConcurrency(int type, int concurrency) {
            return false;
        }

        public String getDatabaseProductName() {
            switch (this.product) {
                case GREENPLUM: {
                    return "postgres greenplum";
                }
            }
            return this.product.name();
        }

        public String getIdentifierQuoteString() {
            return "\"";
        }

        public String getDatabaseProductVersion() {
            return "1.0";
        }

        public boolean isReadOnly() {
            return true;
        }

        public int getMaxColumnNameLength() {
            return 30;
        }

        public String getDriverName() {
            switch (this.product) {
                case GREENPLUM: {
                    return "Mondrian fake dialect for Greenplum";
                }
            }
            return "Mondrian fake dialect";
        }

        public String getExtraNameCharacters() {
            return "";
        }

        public boolean supportsMixedCaseQuotedIdentifiers() {
            return true;
        }

        public boolean supportsMixedCaseIdentifiers() {
            return true;
        }

        public boolean storesUpperCaseQuotedIdentifiers() {
            return false;
        }

        public boolean storesLowerCaseQuotedIdentifiers() {
            return false;
        }

        public boolean storesMixedCaseQuotedIdentifiers() {
            return false;
        }

        public boolean storesUpperCaseIdentifiers() {
            return false;
        }

        public boolean storesLowerCaseIdentifiers() {
            return false;
        }

        public boolean storesMixedCaseIdentifiers() {
            return false;
        }
    }

    public static class ConnectionInvocationHandler
    extends DelegatingInvocationHandler {
        private final DatabaseMetaData metaData;

        ConnectionInvocationHandler(DatabaseMetaData metaData) {
            this.metaData = metaData;
        }

        public DatabaseMetaData getMetaData() {
            return this.metaData;
        }

        public Statement createStatement() throws SQLException {
            throw new SQLException();
        }
    }
}

