/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.util.ClassResolver;
import org.apache.log4j.Logger;

public interface VirtualFileHandler {
    public static final Logger LOGGER = Logger.getLogger(VirtualFileHandler.class);
    public static final String[] BUILTIN_IMPLEMENTATIONS = new String[]{"mondrian.spi.impl.ApacheVfsVirtualFileHandler", "mondrian.spi.impl.ApacheVfs2VirtualFileHandler", "mondrian.spi.impl.JavaNetVirtualFileHandler"};
    public static final Util.Function0<VirtualFileHandler> FACTORY = new Util.Function0<VirtualFileHandler>(){

        @Override
        public VirtualFileHandler apply() {
            Object[] classNames = new String[]{MondrianProperties.instance().VfsClass.get()};
            if (classNames[0] == null) {
                classNames = BUILTIN_IMPLEMENTATIONS;
                LOGGER.info((Object)"VirtualFileHandler: Property not set. Tryingstandard implementations");
            }
            for (String string : classNames) {
                try {
                    VirtualFileHandler vfh = (VirtualFileHandler)ClassResolver.INSTANCE.instantiateSafe(string, new Object[0]);
                    LOGGER.info((Object)("VirtualFileHandler: Using " + string));
                    return vfh;
                }
                catch (Exception e) {
                    LOGGER.info((Object)("Failed to instantiate " + string), (Throwable)e);
                }
            }
            RuntimeException e = Util.newError("Could not instantiate VirtualFileHandler; tried " + Arrays.toString(classNames));
            LOGGER.error((Object)"Giving up", (Throwable)e);
            throw e;
        }
    };

    public InputStream readVirtualFile(String var1) throws IOException;
}

