/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.olap4j.CatalogFinder;
import mondrian.olap4j.MondrianOlap4jDriver;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapResultShepherd;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.agg.AggregationManager;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.MondrianServerRegistry;
import mondrian.server.MonitorImpl;
import mondrian.server.Repository;
import mondrian.server.Statement;
import mondrian.server.monitor.ConnectionEndEvent;
import mondrian.server.monitor.ConnectionStartEvent;
import mondrian.server.monitor.Monitor;
import mondrian.server.monitor.StatementEndEvent;
import mondrian.server.monitor.StatementStartEvent;
import mondrian.spi.CatalogLocator;
import mondrian.util.LockBox;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianServerImpl
extends MondrianServer
implements CatalogFinder,
XmlaHandler.ConnectionFactory {
    private final int id = ID_GENERATOR.incrementAndGet();
    private final LockBox lockBox;
    private final Repository repository;
    private final CatalogLocator catalogLocator;
    private final RolapResultShepherd shepherd;
    private final Map<Integer, RolapConnection> connectionMap = new ReferenceMap(2, 2);
    private final Map<Long, Statement> statementMap = new ReferenceMap(2, 2);
    private final MonitorImpl monitor = new MonitorImpl();
    private final AggregationManager aggMgr;
    private boolean shutdown = false;
    private static final Logger LOGGER = Logger.getLogger(MondrianServerImpl.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private static final List<String> KEYWORD_LIST = Collections.unmodifiableList(Arrays.asList("$AdjustedProbability", "$Distance", "$Probability", "$ProbabilityStDev", "$ProbabilityStdDeV", "$ProbabilityVariance", "$StDev", "$StdDeV", "$Support", "$Variance", "AddCalculatedMembers", "Action", "After", "Aggregate", "All", "Alter", "Ancestor", "And", "Append", "As", "ASC", "Axis", "Automatic", "Back_Color", "BASC", "BDESC", "Before", "Before_And_After", "Before_And_Self", "Before_Self_After", "BottomCount", "BottomPercent", "BottomSum", "Break", "Boolean", "Cache", "Calculated", "Call", "Case", "Catalog_Name", "Cell", "Cell_Ordinal", "Cells", "Chapters", "Children", "Children_Cardinality", "ClosingPeriod", "Cluster", "ClusterDistance", "ClusterProbability", "Clusters", "CoalesceEmpty", "Column_Values", "Columns", "Content", "Contingent", "Continuous", "Correlation", "Cousin", "Covariance", "CovarianceN", "Create", "CreatePropertySet", "CrossJoin", "Cube", "Cube_Name", "CurrentMember", "CurrentCube", "Custom", "Cyclical", "DefaultMember", "Default_Member", "DESC", "Descendents", "Description", "Dimension", "Dimension_Unique_Name", "Dimensions", "Discrete", "Discretized", "DrillDownLevel", "DrillDownLevelBottom", "DrillDownLevelTop", "DrillDownMember", "DrillDownMemberBottom", "DrillDownMemberTop", "DrillTrough", "DrillUpLevel", "DrillUpMember", "Drop", "Else", "Empty", "End", "Equal_Areas", "Exclude_Null", "ExcludeEmpty", "Exclusive", "Expression", "Filter", "FirstChild", "FirstRowset", "FirstSibling", "Flattened", "Font_Flags", "Font_Name", "Font_size", "Fore_Color", "Format_String", "Formatted_Value", "Formula", "From", "Generate", "Global", "Head", "Hierarchize", "Hierarchy", "Hierary_Unique_name", "IIF", "IsEmpty", "Include_Null", "Include_Statistics", "Inclusive", "Input_Only", "IsDescendant", "Item", "Lag", "LastChild", "LastPeriods", "LastSibling", "Lead", "Level", "Level_Unique_Name", "Levels", "LinRegIntercept", "LinRegR2", "LinRegPoint", "LinRegSlope", "LinRegVariance", "Long", "MaxRows", "Median", "Member", "Member_Caption", "Member_Guid", "Member_Name", "Member_Ordinal", "Member_Type", "Member_Unique_Name", "Members", "Microsoft_Clustering", "Microsoft_Decision_Trees", "Mining", "Model", "Model_Existence_Only", "Models", "Move", "MTD", "Name", "Nest", "NextMember", "Non", "Normal", "Not", "Ntext", "Nvarchar", "OLAP", "On", "OpeningPeriod", "OpenQuery", "Or", "Ordered", "Ordinal", "Pages", "Pages", "ParallelPeriod", "Parent", "Parent_Level", "Parent_Unique_Name", "PeriodsToDate", "PMML", "Predict", "Predict_Only", "PredictAdjustedProbability", "PredictHistogram", "Prediction", "PredictionScore", "PredictProbability", "PredictProbabilityStDev", "PredictProbabilityVariance", "PredictStDev", "PredictSupport", "PredictVariance", "PrevMember", "Probability", "Probability_StDev", "Probability_StdDev", "Probability_Variance", "Properties", "Property", "QTD", "RangeMax", "RangeMid", "RangeMin", "Rank", "Recursive", "Refresh", "Related", "Rename", "Rollup", "Rows", "Schema_Name", "Sections", "Select", "Self", "Self_And_After", "Sequence_Time", "Server", "Session", "Set", "SetToArray", "SetToStr", "Shape", "Skip", "Solve_Order", "Sort", "StdDev", "Stdev", "StripCalculatedMembers", "StrToSet", "StrToTuple", "SubSet", "Support", "Tail", "Text", "Thresholds", "ToggleDrillState", "TopCount", "TopPercent", "TopSum", "TupleToStr", "Under", "Uniform", "UniqueName", "Use", "Value", "Value", "Var", "Variance", "VarP", "VarianceP", "VisualTotals", "When", "Where", "With", "WTD", "Xor"));

    MondrianServerImpl(MondrianServerRegistry registry, Repository repository, CatalogLocator catalogLocator) {
        assert (repository != null);
        assert (catalogLocator != null);
        this.repository = repository;
        this.catalogLocator = catalogLocator;
        this.lockBox = registry.lockBox;
        this.aggMgr = new AggregationManager(this);
        this.shepherd = new RolapResultShepherd();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("new MondrianServer: id=" + this.id));
        }
        this.registerMBean();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.shutdown(true);
        }
        catch (Throwable t) {
            LOGGER.info((Object)MondrianResource.instance().FinalizerErrorMondrianServerImpl.baseMessage, t);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public RolapResultShepherd getResultShepherd() {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.shepherd;
    }

    @Override
    public List<String> getKeywords() {
        return KEYWORD_LIST;
    }

    @Override
    public LockBox getLockBox() {
        return this.lockBox;
    }

    @Override
    public AggregationManager getAggregationManager() {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.aggMgr;
    }

    @Override
    public OlapConnection getConnection(String databaseName, String catalogName, String roleName) throws SQLException {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.getConnection(databaseName, catalogName, roleName, new Properties());
    }

    @Override
    public OlapConnection getConnection(String databaseName, String catalogName, String roleName, Properties props) throws SQLException {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.repository.getConnection(this, databaseName, catalogName, roleName, props);
    }

    @Override
    public List<String> getCatalogNames(RolapConnection connection) {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.repository.getCatalogNames(connection, this.repository.getDatabaseNames(connection).get(0));
    }

    @Override
    public List<Map<String, Object>> getDatabases(RolapConnection connection) {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.repository.getDatabases(connection);
    }

    @Override
    public CatalogLocator getCatalogLocator() {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.catalogLocator;
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    private void shutdown(boolean silent) {
        if (this == MondrianServerRegistry.INSTANCE.staticServer) {
            LOGGER.warn((Object)"Can't shutdown the static server.");
            return;
        }
        if (this.shutdown) {
            if (silent) {
                return;
            }
            throw new MondrianException("Server already shutdown.");
        }
        this.shutdown = true;
        this.aggMgr.shutdown();
        this.monitor.shutdown();
        this.repository.shutdown();
        this.shepherd.shutdown();
    }

    @Override
    public synchronized void addConnection(RolapConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addConnection , id=" + this.id + ", statements=" + this.statementMap.size() + ", connections=" + this.connectionMap.size()));
        }
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        this.connectionMap.put(connection.getId(), connection);
        this.monitor.sendEvent(new ConnectionStartEvent(System.currentTimeMillis(), connection.getServer().getId(), connection.getId()));
    }

    @Override
    public synchronized void removeConnection(RolapConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("removeConnection , id=" + this.id + ", statements=" + this.statementMap.size() + ", connections=" + this.connectionMap.size()));
        }
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        this.connectionMap.remove(connection.getId());
        this.monitor.sendEvent(new ConnectionEndEvent(System.currentTimeMillis(), this.getId(), connection.getId()));
    }

    @Override
    public RolapConnection getConnection(int connectionId) {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.connectionMap.get(connectionId);
    }

    @Override
    public synchronized void addStatement(Statement statement) {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addStatement , id=" + this.id + ", statements=" + this.statementMap.size() + ", connections=" + this.connectionMap.size()));
        }
        this.statementMap.put(statement.getId(), statement);
        RolapConnection connection = statement.getMondrianConnection();
        this.monitor.sendEvent(new StatementStartEvent(System.currentTimeMillis(), connection.getServer().getId(), connection.getId(), statement.getId()));
    }

    @Override
    public synchronized void removeStatement(Statement statement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("removeStatement , id=" + this.id + ", statements=" + this.statementMap.size() + ", connections=" + this.connectionMap.size()));
        }
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        this.statementMap.remove(statement.getId());
        RolapConnection connection = statement.getMondrianConnection();
        this.monitor.sendEvent(new StatementEndEvent(System.currentTimeMillis(), connection.getServer().getId(), connection.getId(), statement.getId()));
    }

    @Override
    public Monitor getMonitor() {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.monitor;
    }

    @Override
    public Map<String, RolapSchema> getRolapSchemas(RolapConnection connection, String catalogName) {
        if (this.shutdown) {
            throw new MondrianException("Server already shutdown.");
        }
        return this.repository.getRolapSchemas(connection, this.repository.getDatabaseNames(connection).get(0), catalogName);
    }

    public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
        return null;
    }

    public XmlaHandler.Request startRequest(XmlaRequest request, OlapConnection connection) {
        if (connection == null) {
            return null;
        }
        try {
            RolapConnection mondrianConnection = (RolapConnection)connection.unwrap(RolapConnection.class);
            Statement statement = mondrianConnection.getInternalStatement();
            Execution execution = new Execution(statement, 0L);
            execution.start();
            Locus locus = new Locus(execution, "XMLA request", null);
            Locus.push(locus);
            return new MondrianServerXmlaRequest(locus);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void endRequest(XmlaHandler.Request request) {
        if (request != null) {
            Locus locus = ((MondrianServerXmlaRequest)request).locus;
            Locus.pop(locus);
            locus.execution.end();
        }
    }

    public XmlaHandler.XmlaExtra getExtra() {
        return MondrianOlap4jDriver.EXTRA;
    }

    private void registerMBean() {
        if (Util.PreJdk16) {
            LOGGER.info((Object)"JMX is supported in Mondrian only on Java 6+.");
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mxbeanName = new ObjectName("mondrian4.server:type=Server-" + this.id);
            mbs.registerMBean(this.getMonitor(), mxbeanName);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn((Object)"Failed to register JMX MBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.warn((Object)"Failed to register JMX MBean", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.warn((Object)"Failed to register JMX MBean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.warn((Object)"Failed to register JMX MBean", (Throwable)e);
        }
    }

    private static class MondrianServerXmlaRequest
    implements XmlaHandler.Request {
        final Locus locus;

        public MondrianServerXmlaRequest(Locus locus) {
            this.locus = locus;
        }
    }
}

