/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Util;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQueryBuilder {
    public final SqlQuery sqlQuery;
    public final SqlTupleReader.ColumnLayoutBuilder layoutBuilder;
    private final BitSet orderBitSet = new BitSet();
    private final Set<Pair<Table, Joiner>> fromList = new LinkedHashSet<Pair<Table, Joiner>>();
    public RolapMeasureGroup fact;
    public boolean joinToDimensionKey;
    private final Map<TableKey, Table> keyTableMap = new LinkedHashMap<TableKey, Table>();
    private Map<RolapSchema.PhysPath, Table> pathTableMap = new LinkedHashMap<RolapSchema.PhysPath, Table>();
    private Set<Table> tableSet = new LinkedHashSet<Table>();

    @Deprecated
    public SqlQueryBuilder(SqlQuery sqlQuery, SqlTupleReader.ColumnLayoutBuilder layoutBuilder, List<RolapSchema.PhysColumn> keyList) {
        this(sqlQuery, layoutBuilder);
        for (RolapSchema.PhysExpr physExpr : keyList) {
            physExpr.foreachColumn(this, AutoJoiner.INSTANCE);
        }
    }

    public SqlQueryBuilder(Dialect dialect, String err, SqlTupleReader.ColumnLayoutBuilder layoutBuilder) {
        this(new ProtectedSqlQuery(dialect, err), layoutBuilder);
    }

    public SqlQueryBuilder(SqlQuery sqlQuery, SqlTupleReader.ColumnLayoutBuilder layoutBuilder) {
        this.sqlQuery = sqlQuery;
        this.layoutBuilder = layoutBuilder;
    }

    public void addRelation(Table table, Joiner joiner) {
        this.fromList.add(Pair.of(table, joiner));
    }

    void addRelation(RolapSchema.PhysRelation relation, String parentAlias, String joinCondition) {
        this.sqlQuery.addFrom(relation, relation.getAlias(), parentAlias, joinCondition, false);
    }

    public final Dialect getDialect() {
        return this.sqlQuery.getDialect();
    }

    public Column column(RolapSchema.PhysColumn column, RolapCubeDimension dimension) {
        Table table = this.table(column.relation, dimension);
        return new Column(table, column);
    }

    public Column column(RolapSchema.PhysColumn column, RolapSchema.PhysRouter router) {
        RolapSchema.PhysPath path = router.path(column);
        assert (Util.last(path.hopList).relation == column.relation);
        Table table = this.table(path);
        return new Column(table, column);
    }

    public Column column(RolapSchema.PhysColumn column, RolapStar.Table starTable) {
        Table table = this.table(starTable);
        return new Column(table, column);
    }

    public Table table(RolapStar.Table starTable) {
        return this.table(starTable.getPath());
    }

    public Table table(RolapSchema.PhysPath path) {
        Table table = this.pathTableMap.get(path);
        if (table == null) {
            RolapSchema.PhysHop lastHop = Util.last(path.hopList);
            if (path.hopList.size() == 1) {
                table = new Table(null, null, lastHop.relation, null);
            } else {
                Table parentTable = this.table(SqlQueryBuilder.butLast(path));
                RolapSchema.PhysLink link = Util.last(path.hopList).link;
                table = new Table(parentTable, link, lastHop.relation, null);
            }
            this.pathTableMap.put(path, table);
            this.tableSet.add(table);
        }
        return table;
    }

    private static RolapSchema.PhysPath butLast(RolapSchema.PhysPath path) {
        return new RolapSchema.PhysPath(path.hopList.subList(0, path.hopList.size() - 1));
    }

    public Table table(RolapSchema.PhysRelation relation, RolapCubeDimension dimension) {
        TableKey key = new TableKey(relation, dimension);
        Table table = this.keyTableMap.get(key);
        if (table == null) {
            Pair<Table, RolapSchema.PhysLink> parent = this.parentTable(relation, dimension);
            table = parent == null ? new Table(null, null, relation, dimension) : new Table((Table)parent.left, (RolapSchema.PhysLink)parent.right, relation, dimension);
            this.keyTableMap.put(key, table);
            this.tableSet.add(table);
        }
        return table;
    }

    private Pair<Table, RolapSchema.PhysLink> parentTable(RolapSchema.PhysRelation physRelation, RolapCubeDimension dimension) {
        RolapSchema.PhysPath path;
        if (dimension == null) {
            assert (this.fact == null || physRelation == this.fact.getFactRelation());
            return null;
        }
        RolapSchema.PhysRelation keyPhysRelation = dimension.getKeyTable();
        if (physRelation == keyPhysRelation) {
            if (this.fact == null) {
                return null;
            }
            RolapSchema.PhysPath path2 = this.fact.dimensionMap3.get(dimension);
            if (path2.getLinks().isEmpty()) {
                assert (physRelation == this.fact.getFactRelation());
                return null;
            }
            RolapSchema.PhysLink link = path2.getLinks().get(0);
            Table table = this.table(link.targetRelation, null);
            return Pair.of(table, link);
        }
        RolapSchema.PhysSchemaGraph graph = physRelation.getSchema().getGraph();
        try {
            path = graph.findPath(physRelation, Collections.singleton(keyPhysRelation), false);
        }
        catch (RolapSchema.PhysSchemaException e) {
            Util.deprecated("TODO", false);
            throw Util.newInternal(e, "while finding path from attribute to dimension key");
        }
        RolapSchema.PhysLink link = path.getLinks().get(0);
        Table table = this.table(link.targetRelation, dimension);
        return Pair.of(table, link);
    }

    public void addColumns(Iterable<? extends RolapSchema.PhysColumn> columns, RolapCubeDimension dimension, Clause clause, Joiner joiner) {
        this.addColumns(columns, dimension, clause, joiner, true);
    }

    public void addColumns(Iterable<? extends RolapSchema.PhysColumn> columns, RolapCubeDimension dimension, Clause clause, Joiner joiner, boolean collateNullsLast) {
        for (RolapSchema.PhysColumn physColumn : columns) {
            this.addColumn(this.column(physColumn, dimension), clause, joiner, null, collateNullsLast);
        }
    }

    public int addColumn(Column column, Clause clause) {
        return this.addColumn(column, clause, NullJoiner.INSTANCE, null);
    }

    public int addColumn(Column column, Clause clause, Joiner joiner, String alias0) {
        return this.addColumn(column, clause, joiner, alias0, true);
    }

    public int addColumn(Column column, Clause clause, Joiner joiner, String alias0, boolean collateNullsLast) {
        String alias;
        if (column == null) {
            return -1;
        }
        String expString = column.sql;
        int ordinal = this.layoutBuilder.lookup(expString);
        if (ordinal >= 0) {
            switch (clause) {
                case SELECT_GROUP_ORDER: 
                case SELECT_ORDER: {
                    if (this.orderBitSet.get(ordinal)) break;
                    this.sqlQuery.addOrderBy(expString, true, false, true);
                    this.orderBitSet.set(ordinal);
                }
            }
            return ordinal;
        }
        this.addRelation(column.table, joiner);
        switch (clause) {
            case SELECT: {
                alias = this.sqlQuery.addSelect(expString, column.physColumn.getInternalType(), alias0);
                break;
            }
            case SELECT_GROUP: {
                alias = this.sqlQuery.addSelect(expString, column.physColumn.getInternalType(), alias0);
                this.sqlQuery.addGroupBy(expString, alias);
                break;
            }
            case SELECT_ORDER: {
                alias = this.sqlQuery.addSelect(expString, column.physColumn.getInternalType(), alias0);
                break;
            }
            case SELECT_GROUP_ORDER: {
                alias = this.sqlQuery.addSelect(expString, column.physColumn.getInternalType(), alias0);
                this.sqlQuery.addGroupBy(expString, alias);
                break;
            }
            case FROM: {
                return -1;
            }
            default: {
                throw Util.unexpected(clause);
            }
        }
        ordinal = this.layoutBuilder.register(expString, alias);
        switch (clause) {
            case SELECT_GROUP_ORDER: 
            case SELECT_ORDER: {
                this.sqlQuery.addOrderBy(expString, alias, true, false, true, collateNullsLast);
                this.orderBitSet.set(ordinal);
            }
        }
        return ordinal;
    }

    public void flush() {
        if (this.joinToDimensionKey) {
            for (Pair<Table, Joiner> pair : new ArrayList<Pair<Table, Joiner>>(this.fromList)) {
                RolapCubeDimension dimension = ((Table)pair.left).dimension;
                if (dimension == null) continue;
                this.addRelation(this.table(dimension.getKeyTable(), dimension), NullJoiner.INSTANCE);
            }
        }
        HashSet<Table> added = new HashSet<Table>();
        for (Pair<Table, Joiner> pair : this.fromList) {
            this.addRecursive((Table)pair.left, added);
        }
    }

    private void addRecursive(Table table, Set<Table> added) {
        if (added.contains(table)) {
            return;
        }
        if (table.parent != null) {
            this.addRecursive(table.parent, added);
            ((ProtectedSqlQuery)this.sqlQuery).addFromSuper(table.physRelation, table.physRelation.getAlias(), table.parent.physRelation.getAlias(), ((Table)table).link.sql, true);
        } else {
            ((ProtectedSqlQuery)this.sqlQuery).addFromSuper(table.physRelation, table.physRelation.getAlias(), true);
        }
        added.add(table);
    }

    public Pair<String, List<SqlStatement.Type>> toSqlAndTypes() {
        this.flush();
        return ((ProtectedSqlQuery)this.sqlQuery).toSqlAndTypesSuper();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProtectedSqlQuery
    extends SqlQuery {
        public ProtectedSqlQuery(Dialect dialect, String err) {
            super(dialect);
        }

        @Override
        public Pair<String, List<SqlStatement.Type>> toSqlAndTypes() {
            throw new AssertionError();
        }

        private Pair<String, List<SqlStatement.Type>> toSqlAndTypesSuper() {
            return super.toSqlAndTypes();
        }

        @Override
        public boolean addFrom(RolapSchema.PhysRelation relation, String alias, boolean failIfExists) {
            throw new AssertionError();
        }

        private boolean addFromSuper(RolapSchema.PhysRelation relation, String alias, boolean failIfExists) {
            return super.addFrom(relation, alias, failIfExists);
        }

        @Override
        public boolean addFrom(RolapSchema.PhysRelation relation, String alias, String parentAlias, String joinCondition, boolean failIfExists) {
            throw new AssertionError();
        }

        public boolean addFromSuper(RolapSchema.PhysRelation relation, String alias, String parentAlias, String joinCondition, boolean failIfExists) {
            return super.addFrom(relation, alias, parentAlias, joinCondition, failIfExists);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableKey
    extends Pair<RolapSchema.PhysRelation, RolapCubeDimension> {
        private TableKey(RolapSchema.PhysRelation physRelation, RolapCubeDimension dimension) {
            super(physRelation, dimension);
        }
    }

    public static class Table {
        private final RolapSchema.PhysLink link;
        private final RolapSchema.PhysRelation physRelation;
        private final RolapCubeDimension dimension;
        private final RolapSchema.PhysPath path;
        private final Table parent;

        private Table(Table parent, RolapSchema.PhysLink link, RolapSchema.PhysRelation physRelation, RolapCubeDimension dimension) {
            this.parent = parent;
            this.link = link;
            this.physRelation = physRelation;
            this.dimension = dimension;
            this.path = parent == null ? new RolapSchema.PhysPathBuilder(physRelation).done() : new RolapSchema.PhysPathBuilder(parent.path).prepend(link, physRelation, false).done();
        }

        public String toString() {
            return this.physRelation.toString();
        }

        public int hashCode() {
            return Util.hashV(0, this.physRelation, this.parent, this.link);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Table && Util.equals(this.physRelation, ((Table)obj).physRelation) && Util.equals(this.parent, ((Table)obj).parent) && Util.equals(this.link, ((Table)obj).link);
        }
    }

    public static class Column {
        private final Table table;
        private final RolapSchema.PhysColumn physColumn;
        private final String sql;

        private Column(Table table, RolapSchema.PhysColumn physColumn) {
            assert (table != null);
            this.table = table;
            this.physColumn = physColumn;
            this.sql = physColumn.toSql();
        }
    }

    public static class NullJoiner
    implements Joiner {
        public static final NullJoiner INSTANCE = new NullJoiner();

        private NullJoiner() {
        }

        public void addColumn(SqlQueryBuilder queryBuilder, RolapSchema.PhysColumn column) {
            this.addRelation(queryBuilder, column.relation);
        }

        public void addRelation(SqlQueryBuilder queryBuilder, RolapSchema.PhysRelation relation) {
            queryBuilder.sqlQuery.addFrom(relation, relation.getAlias(), false);
        }
    }

    public static class DimensionJoiner
    implements Joiner {
        private final RolapMeasureGroup measureGroup;
        private final RolapCubeDimension dimension;

        public DimensionJoiner(RolapMeasureGroup measureGroup, RolapCubeDimension dimension) {
            this.measureGroup = measureGroup;
            this.dimension = dimension;
        }

        public void addColumn(SqlQueryBuilder queryBuilder, RolapSchema.PhysColumn column) {
            this.addRelation(queryBuilder, column.relation);
        }

        public void addRelation(SqlQueryBuilder queryBuilder, RolapSchema.PhysRelation relation) {
            queryBuilder.sqlQuery.addFrom(relation, relation.getAlias(), false);
            RolapSchema.PhysPath path = this.measureGroup.getPath(this.dimension);
            for (RolapSchema.PhysHop hop : path.hopList) {
                String parentAlias;
                String joinCondition;
                if (hop.link != null) {
                    joinCondition = hop.link.sql;
                    parentAlias = hop.link.targetRelation.getAlias();
                } else {
                    joinCondition = null;
                    parentAlias = null;
                }
                queryBuilder.addRelation(hop.relation, parentAlias, joinCondition);
            }
        }

        public static Joiner of(RolapMeasureGroup measureGroup, RolapCubeDimension dimension) {
            if (measureGroup == null) {
                return AutoJoiner.INSTANCE;
            }
            return new DimensionJoiner(measureGroup, dimension);
        }
    }

    public static class AutoJoiner {
        public static final Joiner INSTANCE = NullJoiner.INSTANCE;
    }

    public static interface Joiner {
        public void addColumn(SqlQueryBuilder var1, RolapSchema.PhysColumn var2);

        public void addRelation(SqlQueryBuilder var1, RolapSchema.PhysRelation var2);
    }
}

