/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final List<Segment> segments;
    private final Segment segment0;
    private final GroupingSetsList groupingSetsList;
    private final List<StarPredicate> compoundPredicateList;

    public SegmentArrayQuerySpec(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        super(groupingSetsList.getStar(), false);
        this.segments = groupingSetsList.getDefaultSegments();
        this.segment0 = this.segments.get(0);
        this.groupingSetsList = groupingSetsList;
        this.compoundPredicateList = compoundPredicateList;
        assert (this.isValid(true));
    }

    private boolean isValid(boolean fail) {
        assert (this.segments.size() > 0);
        for (Segment segment : this.segments) {
            if (Arrays.equals(this.segment0.predicates, segment.predicates)) continue;
            assert (!fail);
            return false;
        }
        return true;
    }

    @Override
    public List<Pair<RolapStar.Measure, String>> getMeasures() {
        return new AbstractList<Pair<RolapStar.Measure, String>>(){

            @Override
            public int size() {
                return SegmentArrayQuerySpec.this.segments.size();
            }

            @Override
            public Pair<RolapStar.Measure, String> get(int index) {
                return Pair.of(((Segment)((SegmentArrayQuerySpec)SegmentArrayQuerySpec.this).segments.get((int)index)).aggMeasure, "m" + index);
            }
        };
    }

    @Override
    public List<Pair<RolapStar.Column, String>> getColumns() {
        return new AbstractList<Pair<RolapStar.Column, String>>(){

            @Override
            public int size() {
                return ((SegmentArrayQuerySpec)SegmentArrayQuerySpec.this).segment0.aggColumns.length;
            }

            @Override
            public Pair<RolapStar.Column, String> get(int index) {
                return Pair.of(((SegmentArrayQuerySpec)SegmentArrayQuerySpec.this).segment0.aggColumns[index], "c" + index);
            }
        };
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        return this.segment0.predicates[i];
    }

    @Override
    protected List<StarPredicate> getPredicateList() {
        if (this.compoundPredicateList == null) {
            return super.getPredicateList();
        }
        return this.compoundPredicateList;
    }

    @Override
    protected void addGroupingFunction(SqlQueryBuilder queryBuilder) {
        List<RolapStar.Column> list = this.groupingSetsList.getRollupColumns();
        for (RolapStar.Column column : list) {
            queryBuilder.sqlQuery.addGroupingFunction(column.getExpression().toSql());
        }
    }

    @Override
    protected void addGroupingSets(SqlQueryBuilder queryBuilder, Map<String, String> groupingSetsAliases) {
        List<RolapStar.Column[]> groupingSetsColumns = this.groupingSetsList.getGroupingSetsColumns();
        for (RolapStar.Column[] groupingSetsColumn : groupingSetsColumns) {
            ArrayList<String> groupingColumnsExpr = new ArrayList<String>();
            for (RolapStar.Column column : groupingSetsColumn) {
                String columnExpr = column.getExpression().toSql();
                if (groupingSetsAliases.containsKey(columnExpr)) {
                    groupingColumnsExpr.add(groupingSetsAliases.get(columnExpr));
                    continue;
                }
                groupingColumnsExpr.add(columnExpr);
            }
            queryBuilder.sqlQuery.addGroupingSet(groupingColumnsExpr);
        }
    }

    @Override
    protected boolean isAggregate() {
        return true;
    }
}

