/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.List;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralStarPredicate
implements StarPredicate {
    private final boolean value;
    public static final LiteralStarPredicate TRUE = new LiteralStarPredicate(true);
    public static final LiteralStarPredicate FALSE = new LiteralStarPredicate(false);

    public LiteralStarPredicate(boolean value) {
        this.value = value;
    }

    public int hashCode() {
        return this.value ? 2 : 1;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LiteralStarPredicate && this.value == ((LiteralStarPredicate)obj).value;
    }

    public List<RolapSchema.PhysRouter> getRouters() {
        return Collections.emptyList();
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        assert (valueList.isEmpty());
        return this.value;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("=any");
    }

    @Override
    public List<PredicateColumn> getColumnList() {
        return Collections.emptyList();
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        return BitKey.EMPTY;
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        return this.value ? this : predicate;
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        return this.value ? predicate : this;
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (this.value) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void toSql(Dialect dialect, StringBuilder buf) {
        buf.append(this.value);
    }
}

