/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrillThroughQuerySpec
extends AbstractQuerySpec {
    private final DrillThroughCellRequest request;
    private final List<StarPredicate> listOfStarPredicates;
    private final List<String> columnNames;

    public DrillThroughQuerySpec(DrillThroughCellRequest request, StarPredicate starPredicateSlicer, boolean countOnly) {
        super(request.getMeasure().getStar(), countOnly);
        this.request = request;
        this.listOfStarPredicates = starPredicateSlicer != null ? Collections.singletonList(starPredicateSlicer) : Collections.emptyList();
        int maxColumnNameLength = this.getStar().getSqlQueryDialect().getMaxColumnNameLength();
        if (maxColumnNameLength == 0) {
            maxColumnNameLength = Integer.MAX_VALUE;
        }
        this.columnNames = DrillThroughQuerySpec.computeDistinctColumnNames(request, maxColumnNameLength);
    }

    private static List<String> computeDistinctColumnNames(DrillThroughCellRequest request, int maxColumnNameLength) {
        ArrayList<String> columnNames = new ArrayList<String>();
        HashSet<String> columnNameSet = new HashSet<String>();
        for (RolapStar.Column column : request.getConstrainedColumns()) {
            DrillThroughQuerySpec.addColumnName(request.getColumnAlias(column), column, maxColumnNameLength, columnNames, columnNameSet);
        }
        DrillThroughQuerySpec.addColumnName(request.getMeasure().getName(), request.getMeasure(), maxColumnNameLength, columnNames, columnNameSet);
        return columnNames;
    }

    private static void addColumnName(String columnName, RolapStar.Column column, int maxColumnNameLength, List<String> columnNames, Set<String> columnNameSet) {
        if (columnName == null) {
            columnName = column.getName();
            if (columnName != null) {
                if (columnName.startsWith("$")) {
                    columnName = columnName.replace("$", "");
                }
            } else {
                columnName = column.getExpression() instanceof RolapSchema.PhysRealColumn ? ((RolapSchema.PhysRealColumn)column.getExpression()).name : "c" + Integer.toString(columnNames.size());
            }
        }
        String originalColumnName = columnName;
        if (columnName.length() > maxColumnNameLength) {
            columnName = columnName.substring(0, maxColumnNameLength);
        }
        int j = 0;
        while (!columnNameSet.add(columnName)) {
            String suffix = "_" + Integer.toString(j);
            columnName = originalColumnName;
            if (originalColumnName.length() + suffix.length() > maxColumnNameLength) {
                columnName = originalColumnName.substring(0, maxColumnNameLength - suffix.length());
            }
            columnName = columnName + suffix;
            ++j;
        }
        columnNames.add(columnName);
    }

    @Override
    protected boolean isPartOfSelect(RolapStar.Column col) {
        return this.request.includeInSelect(col);
    }

    @Override
    protected boolean isPartOfSelect(RolapStar.Measure measure) {
        return this.request.includeInSelect(measure);
    }

    @Override
    public List<Pair<RolapStar.Measure, String>> getMeasures() {
        final List<RolapStar.Measure> drillThroughMeasures = this.request.getDrillThroughMeasures();
        if (drillThroughMeasures.size() > 0) {
            return new AbstractList<Pair<RolapStar.Measure, String>>(){

                @Override
                public int size() {
                    return drillThroughMeasures.size();
                }

                @Override
                public Pair<RolapStar.Measure, String> get(int index) {
                    RolapStar.Measure measure = (RolapStar.Measure)drillThroughMeasures.get(index);
                    return Pair.of(measure, measure.getName());
                }
            };
        }
        return Collections.singletonList(Pair.of(this.request.getMeasure(), Util.last(this.columnNames)));
    }

    @Override
    public List<Pair<RolapStar.Column, String>> getColumns() {
        final RolapStar.Column[] constrainedColumns = this.request.getConstrainedColumns();
        return new AbstractList<Pair<RolapStar.Column, String>>(){

            @Override
            public int size() {
                return constrainedColumns.length;
            }

            @Override
            public Pair<RolapStar.Column, String> get(int index) {
                return Pair.of(constrainedColumns[index], DrillThroughQuerySpec.this.columnNames.get(index));
            }
        };
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        StarColumnPredicate constraint = this.request.getValueAt(i);
        return constraint == null ? Predicates.wildcard(new PredicateColumn(RolapSchema.BadRouter.INSTANCE, this.request.getConstrainedColumns()[i].getExpression()), true) : constraint;
    }

    @Override
    public Pair<String, List<SqlStatement.Type>> generateSqlQuery(String desc) {
        SqlQueryBuilder queryBuilder = this.createQueryBuilder(desc);
        this.nonDistinctGenerateSql(queryBuilder);
        return queryBuilder.toSqlAndTypes();
    }

    @Override
    protected void addMeasure(RolapStar.Measure measure, String alias, SqlQueryBuilder queryBuilder) {
        String exprInner;
        if (!this.isPartOfSelect(measure)) {
            return;
        }
        assert (measure.getTable() == this.getStar().getFactTable());
        if (measure.getExpression() == null) {
            exprInner = "*";
        } else {
            exprInner = measure.getExpression().toSql();
            queryBuilder.addColumn(queryBuilder.column(measure.getExpression(), measure.getTable()), Clause.FROM);
        }
        if (!this.countOnly) {
            String exprOuter = measure.getAggregator().getExpression(exprInner);
            queryBuilder.sqlQuery.addSelect(exprOuter, measure.getInternalType(), alias);
        }
    }

    @Override
    protected boolean isAggregate() {
        return true;
    }

    @Override
    protected boolean isOrdered() {
        return false;
    }

    @Override
    protected List<StarPredicate> getPredicateList() {
        return this.listOfStarPredicates;
    }
}

