/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.TupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.LevelColumnLayout;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.DescendantsCrossJoinArg;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.spi.Dialect;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTupleReader
implements TupleReader {
    private static final Logger LOGGER = Logger.getLogger(SqlTupleReader.class);
    protected final TupleConstraint constraint;
    protected final List<Target> targets = new ArrayList<Target>();
    int maxRows = 0;
    private int missedMemberCount;
    private int emptySets = 0;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void incrementEmptySets() {
        ++this.emptySets;
    }

    @Override
    public void addLevelMembers(RolapCubeLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (Target target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    @Override
    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (Target target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    private void prepareTuples(Dialect dialect, DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            boolean moreRows;
            ResultSet resultSet;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                for (Target target : this.targets) {
                    if (target.srcMembers != null) continue;
                    partialTargets.add(target);
                }
                Pair<String, List<SqlStatement.Type>> pair = this.makeLevelMembersSql(dialect);
                String sql = (String)pair.left;
                List types = (List)pair.right;
                assert (sql != null && !sql.equals(""));
                stmt = RolapUtil.executeQuery(dataSource, sql, types, this.maxRows, 0, new SqlStatement.StatementLocus(this.getExecution(), "SqlTupleReader.readTuples " + partialTargets, message, SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (Target target : this.targets) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
                if (moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                if (enumTargetCount == 0) {
                    for (Target target : this.targets) {
                        target.setCurrMember(null);
                        target.addRow(stmt);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && this.targets.get((int)firstEnumTarget).srcMembers == null; ++firstEnumTarget) {
                    }
                    List partialRow = execQuery ? null : Util.cast((List)partialResult.get(currPartialResultIdx));
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, stmt, message);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    if (!moreRows) continue;
                    ++stmt.rowCount;
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
        catch (SQLException e) {
            if (stmt == null) {
                throw Util.newError(e, message);
            }
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private Execution getExecution() {
        assert (this.targets.size() > 0);
        if (Locus.peek().execution.getMondrianStatement().getMondrianConnection().getSchema() != null) {
            return Locus.peek().execution;
        }
        Statement statement = this.targets.get(0).getLevel().getHierarchy().getRolapSchema().getInternalConnection().getInternalStatement();
        return new Execution(statement, 0L);
    }

    @Override
    public TupleList readMembers(Dialect dialect, DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        block2: {
            int memberCountBefore;
            int memberCount = this.countMembers();
            do {
                this.missedMemberCount = 0;
                memberCountBefore = memberCount;
                this.prepareTuples(dialect, dataSource, partialResult, newPartialResult);
                memberCount = this.countMembers();
                if (this.missedMemberCount == 0) break block2;
            } while (memberCount != memberCountBefore);
            throw Util.newError("Parent-child hierarchy contains cyclic data");
        }
        assert (this.targets.size() == 1);
        return new UnaryTupleList(this.bumpNullMember(this.targets.get(0).close()));
    }

    protected List<Member> bumpNullMember(List<Member> members) {
        if (members.size() > 0 && ((RolapMemberBase)members.get(members.size() - 1)).getKey() == RolapUtil.sqlNullValue) {
            Member removed = members.remove(members.size() - 1);
            members.add(0, removed);
        }
        return members;
    }

    private int countMembers() {
        int n = 0;
        for (Target target : this.targets) {
            if (target.getList() == null) continue;
            n += target.getList().size();
        }
        return n;
    }

    @Override
    public TupleList readTuples(Dialect dialect, DataSource dataSource, TupleList partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(dialect, dataSource, partialResult, newPartialResult);
        int n = this.targets.size();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            Target t = this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        ArrayList<Member> members = new ArrayList<Member>();
        while (iter[0].hasNext()) {
            for (int i = 0; i < n; ++i) {
                members.add((Member)iter[i].next());
            }
        }
        TupleList tupleList = (TupleList)((Object)(n + this.emptySets == 1 ? new UnaryTupleList(members) : new ListTupleList(n + this.emptySets, members)));
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            tupleList = FunUtil.hierarchizeTupleList(tupleList, false);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.setCurrMember(partialRow.get(nativeTarget++));
                continue;
            }
            target.setCurrMember(null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, SqlStatement stmt, String message) {
        Target currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.srcMembers.size(); ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get((int)nextTargetIdx).srcMembers == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, stmt, message);
                continue;
            }
            int enumTargetIdx = 0;
            for (Target target : this.targets) {
                if (target.srcMembers == null) {
                    try {
                        target.addRow(stmt);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = target.srcMembers.get(srcMemberIdxes[enumTargetIdx++]);
                target.getList().add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.getCurrMember());
        }
        partialResult.add(row);
    }

    Pair<String, List<SqlStatement.Type>> makeLevelMembersSql(Dialect dialect) {
        List<RolapMeasureGroup> measureGroupList = this.constraint.isJoinRequired() ? this.constraint.getMeasureGroupList() : (this.constraint.getEvaluator() != null && this.constraint.getEvaluator().isNonEmpty() ? Collections.singletonList(this.constraint.getEvaluator().getMeasureGroup()) : Collections.emptyList());
        switch (measureGroupList.size()) {
            default: {
                List<RolapMeasureGroup> joiningMeasureGroupList = this.getFullyJoiningMeasureGroups(measureGroupList);
                if (joiningMeasureGroupList.size() == 0) {
                    return this.sqlForEmptyTuple(dialect, measureGroupList);
                }
                StringBuilder buf = new StringBuilder();
                List types = null;
                for (int i = 0; i < joiningMeasureGroupList.size(); ++i) {
                    RolapMeasureGroup measureGroup = joiningMeasureGroupList.get(i);
                    Util.deprecated("todo: push the star into the context somehow, and remove this commented-out logic", false);
                    if (i > 0) {
                        buf.append(Util.nl).append("union").append(Util.nl);
                    }
                    Pair<String, List<SqlStatement.Type>> pair = this.generateSelectForLevels(dialect, measureGroup, i, joiningMeasureGroupList.size());
                    buf.append((String)pair.left);
                    types = (List)pair.right;
                }
                return Pair.of(buf.toString(), types);
            }
            case 1: {
                return this.generateSelectForLevels(dialect, measureGroupList.get(0), 0, 1);
            }
            case 0: 
        }
        return this.generateSelectForLevels(dialect, null, 0, 1);
    }

    private List<RolapMeasureGroup> getFullyJoiningMeasureGroups(List<RolapMeasureGroup> measureGroupList) {
        ArrayList<RolapMeasureGroup> list = new ArrayList<RolapMeasureGroup>();
        for (RolapMeasureGroup measureGroup : measureGroupList) {
            if (!this.allTargetsJoin(measureGroup)) continue;
            list.add(measureGroup);
        }
        return list;
    }

    private boolean allTargetsJoin(RolapMeasureGroup measureGroup) {
        for (Target target : this.targets) {
            if (measureGroup.existsLink(target.level.cubeDimension)) continue;
            return false;
        }
        return true;
    }

    Pair<String, List<SqlStatement.Type>> sqlForEmptyTuple(Dialect dialect, List<RolapMeasureGroup> measureGroupList) {
        SqlQuery sqlQuery = SqlQuery.newQuery(dialect, null);
        sqlQuery.addSelect("0", null);
        sqlQuery.addFrom(measureGroupList.get(0).getStar().getFactTable().getRelation(), null, true);
        StringBuilder buf = new StringBuilder();
        dialect.quoteBooleanLiteral(buf, false);
        sqlQuery.addWhere(buf.toString());
        return sqlQuery.toSqlAndTypes();
    }

    Pair<String, List<SqlStatement.Type>> generateSelectForLevels(Dialect dialect, RolapMeasureGroup measureGroup, int selectOrdinal, int selectCount) {
        RolapStarSet starSet;
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        Evaluator evaluator = this.getEvaluator(this.constraint);
        if (measureGroup != null) {
            Object aggStar = null;
            RolapMeasureGroup aggMeasureGroup = null;
            starSet = new RolapStarSet(measureGroup.getStar(), measureGroup, aggMeasureGroup);
        } else {
            starSet = new RolapStarSet(null, null, null);
        }
        ArrayList<Target> unevaluatedTargets = new ArrayList<Target>();
        LinkedHashSet<RolapCubeDimension> dimensions = new LinkedHashSet<RolapCubeDimension>();
        for (Target target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            unevaluatedTargets.add(target);
            dimensions.add(target.level.getDimension());
        }
        ColumnLayoutBuilder columnLayoutBuilder = new ColumnLayoutBuilder();
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(dialect, s, columnLayoutBuilder);
        queryBuilder.sqlQuery.setAllowHints(true);
        if (!unevaluatedTargets.isEmpty()) {
            if (measureGroup != null) {
                queryBuilder.fact = measureGroup;
            } else if (MondrianProperties.instance().FilterChildlessSnowflakeMembers.get()) {
                queryBuilder.joinToDimensionKey = true;
            }
            for (Target target : unevaluatedTargets) {
                this.addLevelMemberSql(queryBuilder, target.getLevel(), starSet, selectOrdinal, selectCount);
                target.setColumnLayout(queryBuilder.layoutBuilder.toLayout());
            }
        }
        this.constraint.addConstraint(queryBuilder, starSet);
        return queryBuilder.toSqlAndTypes();
    }

    private boolean isGroupByNeeded(SqlQuery sqlQuery, RolapHierarchy hierarchy, List<? extends RolapCubeLevel> levels, int levelDepth) {
        return true;
    }

    protected void addLevelMemberSql(SqlQueryBuilder queryBuilder, RolapCubeLevel level, RolapStarSet starSet, int selectOrdinal, int selectCount) {
        assert (selectCount > 0 && selectOrdinal >= 0 && selectOrdinal < selectCount);
        boolean isUnion = selectCount > 1;
        SqlQueryBuilder.Joiner joiner = SqlQueryBuilder.DimensionJoiner.of(starSet.getMeasureGroup(), level.getDimension());
        SqlQuery sqlQuery = queryBuilder.sqlQuery;
        ColumnLayoutBuilder layoutBuilder = queryBuilder.layoutBuilder;
        RolapCubeHierarchy hierarchy = level.getHierarchy();
        if (starSet.cube != null && !hierarchy.getCube().equals(starSet.cube)) {
            Util.deprecated("don't think this is ever the case", true);
            hierarchy = starSet.cube.findBaseCubeHierarchy(hierarchy);
        }
        int levelDepth = level.getDepth();
        boolean needsGroupBy = this.isGroupByNeeded(sqlQuery, hierarchy, hierarchy.getLevelList(), levelDepth);
        RolapMeasureGroup measureGroup = starSet.getMeasureGroup();
        for (int i = 0; i <= levelDepth; ++i) {
            boolean levelCollapsed;
            RolapCubeLevel currLevel = hierarchy.getLevelList().get(i);
            if (currLevel.isAll()) continue;
            LevelLayoutBuilder levelLayoutBuilder = layoutBuilder.createLayoutFor(currLevel);
            boolean bl = levelCollapsed = starSet.getAggStar() != null && SqlMemberSource.isLevelCollapsed(starSet.getAggStar(), level, measureGroup);
            if (levelCollapsed) {
                RolapStar.Column starColumn = currLevel.getBaseStarKeyColumn(measureGroup);
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = starSet.getAggStar().lookupColumn(bitPos);
                String q = aggColumn.generateExprString(sqlQuery);
                String alias = sqlQuery.addSelectGroupBy(q, starColumn.getExpression().getInternalType());
                layoutBuilder.register(q, alias);
                sqlQuery.addOrderBy(q, alias, true, false, true, true);
                aggColumn.getTable().addToFrom(sqlQuery, false, true);
                continue;
            }
            RolapAttribute attribute = currLevel.getAttribute();
            if (currLevel.getParentAttribute() != null) {
                List<RolapSchema.PhysColumn> parentExps = currLevel.getParentAttribute().getKeyList();
                Clause clause = selectOrdinal == selectCount - 1 ? Clause.SELECT_GROUP_ORDER : Clause.SELECT_GROUP;
                for (RolapSchema.PhysColumn parentExp : parentExps) {
                    levelLayoutBuilder.parentOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(parentExp, level.cubeDimension), clause, joiner, null));
                }
            }
            Clause clause = isUnion ? Clause.SELECT.maybeGroup(needsGroupBy) : Clause.SELECT_ORDER.maybeGroup(needsGroupBy);
            for (RolapSchema.PhysColumn column : currLevel.getOrderByList()) {
                levelLayoutBuilder.orderByOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(column, level.cubeDimension), clause, joiner, null));
            }
            for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
                levelLayoutBuilder.keyOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(column, level.cubeDimension), clause, joiner, null));
            }
            levelLayoutBuilder.nameOrdinal = queryBuilder.addColumn(queryBuilder.column(attribute.getNameExp(), level.cubeDimension), Clause.SELECT.maybeGroup(needsGroupBy), joiner, null);
            levelLayoutBuilder.captionOrdinal = queryBuilder.addColumn(queryBuilder.column(attribute.getCaptionExp(), level.cubeDimension), Clause.SELECT.maybeGroup(needsGroupBy), joiner, null);
            this.constraint.addLevelConstraint(sqlQuery, starSet, currLevel);
            if (levelCollapsed) {
                for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
                    hierarchy.addToFromInverse(sqlQuery, column);
                }
                RolapStar.Column starColumn = currLevel.getBaseStarKeyColumn(measureGroup);
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = starSet.getAggStar().lookupColumn(bitPos);
                assert (attribute.getKeyList().size() == 1) : "TODO:";
                sqlQuery.addWhere(aggColumn.getExpression().toSql() + " = " + attribute.getKeyList().get(0).toSql());
            }
            if (isUnion && selectOrdinal == selectCount - 1) {
                SqlTupleReader.addUnionOrderByOrdinal(sqlQuery);
            }
            if (!isUnion) {
                for (RolapSchema.PhysColumn column : currLevel.getOrderByList()) {
                    if (sqlQuery.getDialect().requiresOrderByAlias()) {
                        queryBuilder.addColumn(queryBuilder.column(column, currLevel.cubeDimension), Clause.SELECT_ORDER, joiner, null);
                        continue;
                    }
                    sqlQuery.addOrderBy(column.toSql(), true, false, true);
                }
            }
            for (RolapProperty property : currLevel.attribute.getExplicitProperties()) {
                assert (property.attribute.getKeyList().size() == 1);
                RolapSchema.PhysColumn column = property.attribute.getKeyList().get(0);
                String propSql = column.toSql();
                int ordinal = layoutBuilder.lookup(propSql);
                if (ordinal < 0) {
                    String alias = sqlQuery.addSelect(propSql, column.getInternalType());
                    ordinal = layoutBuilder.register(propSql, alias);
                    if (!(!needsGroupBy || sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue())) {
                        sqlQuery.addGroupBy(propSql, alias);
                    }
                }
                levelLayoutBuilder.propertyOrdinalList.add(ordinal);
            }
        }
        if (measureGroup != null) {
            queryBuilder.joinToDimensionKey = true;
        }
    }

    private static void addUnionOrderByOrdinal(SqlQuery sqlQuery) {
        boolean nullable = true;
        Dialect dialect = sqlQuery.getDialect();
        if (dialect.requiresUnionOrderByExprToBeInSelectClause() || dialect.requiresUnionOrderByOrdinal()) {
            nullable = false;
        }
        String ordinal = Integer.toString(sqlQuery.getCurrentSelectListSize());
        sqlQuery.addOrderBy(ordinal, ordinal, true, false, nullable, false);
    }

    protected Evaluator getEvaluator(TupleConstraint constraint) {
        DescendantsConstraint descConstraint;
        MemberChildrenConstraint mcc;
        if (constraint instanceof SqlContextConstraint) {
            return constraint.getEvaluator();
        }
        if (constraint instanceof DescendantsConstraint && (mcc = (descConstraint = (DescendantsConstraint)constraint).getMemberChildrenConstraint(null)) instanceof SqlContextConstraint) {
            SqlContextConstraint scc = (SqlContextConstraint)mcc;
            return scc.getEvaluator();
        }
        return null;
    }

    AggStar chooseAggStar(TupleConstraint constraint, RolapMeasureGroup measureGroup1, Evaluator evaluator) {
        RolapStar.Column[] columns;
        if (!MondrianProperties.instance().UseAggregates.get()) {
            return null;
        }
        if (evaluator == null) {
            return null;
        }
        Member[] members = evaluator.getNonAllMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = measure.getStarMeasure().getBitPosition();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        RolapMeasureGroup measureGroup = measure.getMeasureGroup();
        RolapStar star = measureGroup.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        for (Target target : this.targets) {
            RolapStar.Column starColumn;
            RolapCubeLevel level = target.level;
            if (level.isAll() || (starColumn = level.getBaseStarKeyColumn(measureGroup)) == null) continue;
            levelBitKey.set(starColumn.getBitPosition());
        }
        measureBitKey.set(bitPosition);
        if (constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint) {
            RolapNativeCrossJoin.NonEmptyCrossJoinConstraint necj = (RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)constraint;
            for (CrossJoinArg arg : necj.args) {
                RolapCubeLevel level;
                if (!(arg instanceof DescendantsCrossJoinArg) && !(arg instanceof MemberListCrossJoinArg) || (level = arg.getLevel()) == null || level.isAll()) continue;
                RolapCubeLevel cubeLevel = level;
                for (RolapSchema.PhysColumn physColumn : cubeLevel.attribute.getKeyList()) {
                    RolapStar.Column column = measureGroup1.getRolapStarColumn(cubeLevel.cubeDimension, physColumn, true);
                    levelBitKey.set(column.getBitPosition());
                }
            }
        }
        return AggregationManager.findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnLayout {
        final Map<RolapCubeLevel, LevelColumnLayout<Integer>> levelLayoutMap;

        public ColumnLayout(Map<RolapCubeLevel, LevelColumnLayout<Integer>> levelLayoutMap) {
            this.levelLayoutMap = levelLayoutMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LevelLayoutBuilder {
        public List<Integer> keyOrdinalList = new ArrayList<Integer>();
        public int nameOrdinal = -1;
        public List<Integer> orderByOrdinalList = new ArrayList<Integer>();
        public int captionOrdinal = -1;
        final List<Integer> propertyOrdinalList = new ArrayList<Integer>();
        private final List<Integer> parentOrdinalList = new ArrayList<Integer>();
        public final RolapCubeLevel level;

        public LevelLayoutBuilder(RolapCubeLevel level) {
            this.level = level;
        }

        public LevelColumnLayout<Integer> toLayout() {
            boolean assignOrderKeys = MondrianProperties.instance().CompareSiblingsByOrderKey.get() || Util.deprecated(true, false) != false;
            LevelColumnLayout.OrderKeySource orderBySource = LevelColumnLayout.OrderKeySource.NONE;
            if (assignOrderKeys) {
                orderBySource = this.orderByOrdinalList.equals(this.keyOrdinalList) ? LevelColumnLayout.OrderKeySource.KEY : (this.orderByOrdinalList.equals(Collections.singletonList(this.nameOrdinal)) ? LevelColumnLayout.OrderKeySource.NAME : LevelColumnLayout.OrderKeySource.MAPPED);
            }
            return new LevelColumnLayout<Integer>(this.keyOrdinalList, this.nameOrdinal, this.captionOrdinal, orderBySource, orderBySource == LevelColumnLayout.OrderKeySource.MAPPED ? this.orderByOrdinalList : null, this.propertyOrdinalList, this.parentOrdinalList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnLayoutBuilder {
        private final List<String> exprList = new ArrayList<String>();
        private final List<String> aliasList = new ArrayList<String>();
        private final Map<RolapCubeLevel, LevelLayoutBuilder> levelLayoutMap = new IdentityHashMap<RolapCubeLevel, LevelLayoutBuilder>();
        LevelLayoutBuilder currentLevelLayout;
        final List<SqlStatement.Type> types = new ArrayList<SqlStatement.Type>();

        public int lookup(String sql) {
            return this.exprList.indexOf(sql);
        }

        public int register(String sql, String alias) {
            int ordinal = this.exprList.size();
            this.exprList.add(sql);
            this.aliasList.add(alias);
            return ordinal;
        }

        public ColumnLayout toLayout() {
            return new ColumnLayout(this.convert(this.levelLayoutMap.values()));
        }

        private Map<RolapCubeLevel, LevelColumnLayout<Integer>> convert(Collection<LevelLayoutBuilder> builders) {
            IdentityHashMap<RolapCubeLevel, LevelColumnLayout<Integer>> map = new IdentityHashMap<RolapCubeLevel, LevelColumnLayout<Integer>>();
            for (LevelLayoutBuilder builder : builders) {
                if (builder == null) continue;
                map.put(builder.level, this.convert(builder));
            }
            return map;
        }

        private LevelColumnLayout<Integer> convert(LevelLayoutBuilder builder) {
            return builder == null ? null : builder.toLayout();
        }

        public LevelLayoutBuilder createLayoutFor(RolapCubeLevel level) {
            LevelLayoutBuilder builder = this.levelLayoutMap.get(level);
            if (builder == null) {
                builder = new LevelLayoutBuilder(level);
                this.levelLayoutMap.put(level, builder);
            }
            this.currentLevelLayout = builder;
            return builder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Target {
        final List<RolapMember> srcMembers;
        final RolapCubeLevel level;
        private RolapMember currMember;
        private List<RolapMember> list;
        final Object cacheLock;
        final TupleReader.MemberBuilder memberBuilder;
        final MemberCache cache;
        ColumnLayout columnLayout;
        RolapCubeLevel[] levels;
        int levelDepth;
        boolean parentChild;
        List<RolapMember> members;
        List<List<RolapMember>> siblings;

        public Target(RolapCubeLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
            this.srcMembers = srcMembers;
            this.level = level;
            this.cacheLock = memberBuilder.getMemberCacheLock();
            this.memberBuilder = memberBuilder;
            this.cache = memberBuilder.getMemberCache();
        }

        public void setList(List<RolapMember> list) {
            this.list = list;
        }

        public List<RolapMember> getSrcMembers() {
            return this.srcMembers;
        }

        public RolapCubeLevel getLevel() {
            return this.level;
        }

        public RolapMember getCurrMember() {
            return this.currMember;
        }

        public void setCurrMember(RolapMember m) {
            this.currMember = m;
        }

        public List<RolapMember> getList() {
            return this.list;
        }

        public String toString() {
            return this.level.getUniqueName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addRow(SqlStatement stmt) throws SQLException {
            Object object = this.cacheLock;
            synchronized (object) {
                this.internalAddRow(stmt);
            }
        }

        public void add(RolapMember member) {
            this.getList().add(member);
        }

        public void open() {
            this.levels = this.level.getHierarchy().getLevelList().toArray(new RolapCubeLevel[this.level.getHierarchy().getLevelList().size()]);
            this.setList(new ArrayList<RolapMember>());
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            int levelCount = this.levels.length;
            this.members = new ArrayList<Object>(Collections.nCopies(levelCount, null));
            this.siblings = new ArrayList<List<RolapMember>>(levelCount + 1);
            for (int i = 0; i < levelCount + 1; ++i) {
                this.siblings.add(new ArrayList());
            }
        }

        void internalAddRow(SqlStatement stmt) throws SQLException {
            RolapMember member = null;
            if (this.getCurrMember() != null) {
                this.setCurrMember(member);
            } else {
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    RolapMember prevMember;
                    Comparable value;
                    int j;
                    Map<Object, SqlStatement.Accessor> accessors;
                    RolapMember parentMember;
                    LevelColumnLayout<Integer> layout;
                    RolapCubeLevel childLevel;
                    block24: {
                        childLevel = this.levels[i];
                        layout = this.columnLayout.levelLayoutMap.get(childLevel);
                        if (childLevel.isAll()) {
                            member = this.memberBuilder.allMember();
                            continue;
                        }
                        parentMember = member;
                        accessors = stmt.getAccessors();
                        if (this.parentChild) {
                            Comparable[] parentKeys = new Comparable[layout.getParentKeys().size()];
                            for (j = 0; j < layout.getParentKeys().size(); ++j) {
                                int parentOrdinal = layout.getParentKeys().get(j);
                                value = accessors.get(parentOrdinal).get();
                                if (value != null && !value.toString().equals(childLevel.getNullParentValue())) {
                                    parentKeys[j] = value;
                                    continue;
                                }
                                break block24;
                            }
                            Object parentKey = parentKeys.length == 1 ? parentKeys[0] : Arrays.asList(parentKeys);
                            parentMember = this.cache.getMember(this.level, parentKey);
                            if (parentMember == null) {
                                LOGGER.warn((Object)MondrianResource.instance().LevelTableParentNotFound.str(childLevel.getUniqueName(), parentKey.toString()));
                            }
                        }
                    }
                    Comparable[] keyValues = new Comparable[layout.getKeys().size()];
                    for (j = 0; j < layout.getKeys().size(); ++j) {
                        int keyOrdinal = layout.getKeys().get(j);
                        value = accessors.get(keyOrdinal).get();
                        keyValues[j] = SqlMemberSource.toComparable(value);
                    }
                    Object key = RolapMember.Key.quick(keyValues);
                    member = this.cache.getMember(childLevel, key);
                    if (member == null) {
                        if (SqlTupleReader.this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                            member = ((RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)SqlTupleReader.this.constraint).findMember(key);
                        }
                        if (member == null) {
                            Comparable orderKey;
                            String nameValue;
                            Comparable nameObject;
                            Comparable keyClone = RolapMember.Key.create(keyValues);
                            Comparable captionValue = layout.getCaptionKey() >= 0 ? accessors.get(layout.getCaptionKey()).get() : null;
                            if (layout.getNameKey() >= 0) {
                                nameObject = accessors.get(layout.getNameKey()).get();
                                nameValue = nameObject == null ? RolapUtil.mdxNullLiteral() : String.valueOf(nameObject);
                            } else {
                                nameObject = null;
                                nameValue = null;
                            }
                            switch (layout.getOrderBySource()) {
                                case NONE: {
                                    orderKey = null;
                                    break;
                                }
                                case KEY: {
                                    orderKey = keyClone;
                                    break;
                                }
                                case NAME: {
                                    orderKey = nameObject;
                                    break;
                                }
                                case MAPPED: {
                                    orderKey = SqlMemberSource.getCompositeKey(accessors, layout.getOrderByKeys());
                                    break;
                                }
                                default: {
                                    throw Util.unexpected(layout.getOrderBySource());
                                }
                            }
                            member = this.memberBuilder.makeMember(parentMember, childLevel, keyClone, captionValue, nameValue, orderKey, this.parentChild, stmt, layout);
                        }
                    }
                    if (member == (prevMember = this.members.get(i)) || prevMember == null) continue;
                    List<RolapMember> children = this.siblings.get(i + 1);
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(prevMember)) != null) {
                        this.cache.putChildren(prevMember, mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    if (i < this.levelDepth && cachedChildren == null) {
                        this.siblings.set(i + 1, new ArrayList());
                    } else {
                        this.siblings.set(i + 1, null);
                    }
                    this.members.set(i, member);
                    if (this.siblings.get(i) == null) continue;
                    if (keyValues == null) {
                        this.addAsOldestSibling(this.siblings.get(i), member);
                        continue;
                    }
                    this.siblings.get(i).add(member);
                }
                this.setCurrMember(member);
            }
            this.getList().add(member);
        }

        public void setColumnLayout(ColumnLayout columnLayout) {
            this.columnLayout = columnLayout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Member> close() {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalClose();
            }
        }

        public List<Member> internalClose() {
            for (int i = 0; i < this.members.size(); ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members.get(i);
                List<RolapMember> children = this.siblings.get(i + 1);
                if (member == null || children == null || member.getDepth() < this.level.getDepth() || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return Util.cast(this.getList());
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }
    }
}

