/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapStar {
    private static final Logger LOGGER = Logger.getLogger(RolapStar.class);
    private final RolapSchema schema;
    private DataSource dataSource;
    private final Table factTable;
    private final List<Column> columnList = new ArrayList<Column>();
    private final Dialect sqlQueryDialect;
    private boolean cacheAggregations = true;
    private final List<AggStar> aggStars = new LinkedList<AggStar>();
    private final ThreadLocal<Bar> localBars = new BarThreadLocal();

    protected RolapStar(RolapSchema schema, DataSource dataSource, RolapSchema.PhysRelation fact) {
        this.schema = schema;
        this.dataSource = dataSource;
        RolapSchema.PhysPath path = new RolapSchema.PhysPathBuilder(fact).done();
        this.factTable = new Table(this, fact, null, path);
        this.sqlQueryDialect = schema.getDialect();
    }

    public int getCost() {
        return MondrianProperties.instance().ChooseAggregateByVolume.get() ? this.factTable.relation.getVolume() : this.factTable.relation.getRowCount();
    }

    public Object getCellFromCache(CellRequest request, RolapAggregationManager.PinSet pinSet) {
        AggregationKey aggregationKey = AggregationKey.create(request);
        Bar bar = this.localBars.get();
        for (SegmentWithData segment : Util.GcIterator.over(bar.segmentRefs)) {
            Object o;
            if (!segment.getConstrainedColumnsBitKey().equals(request.getConstrainedColumnsBitKey()) || !segment.matches(aggregationKey, request.getMeasure()) || (o = segment.getCellValue(request.getSingleValues())) == null) continue;
            if (pinSet != null) {
                ((AggregationManager.PinSetImpl)pinSet).add(segment);
            }
            return o;
        }
        return null;
    }

    public Object getCellFromAllCaches(CellRequest request) {
        Object result = this.getCellFromCache(request, null);
        if (result != null) {
            return result;
        }
        return this.getCellFromExternalCache(request);
    }

    private Object getCellFromExternalCache(CellRequest request) {
        SegmentWithData segment = Locus.peek().getServer().getAggregationManager().cacheMgr.peek(request);
        if (segment == null) {
            return null;
        }
        return segment.getCellValue(request.getSingleValues());
    }

    public void register(SegmentWithData segment) {
        this.localBars.get().segmentRefs.add(new SoftReference<SegmentWithData>(segment));
    }

    public boolean areRowsUnique() {
        return !this.getFactTable().getRelation().getKeyList().isEmpty();
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public void prepareToLoadAggregates() {
        this.aggStars.clear();
    }

    public void addAggStar(AggStar aggStar) {
        int size = aggStar.getCost();
        ListIterator<AggStar> lit = this.aggStars.listIterator();
        while (lit.hasNext()) {
            AggStar as = lit.next();
            if (as.getCost() < size) continue;
            lit.previous();
            lit.add(aggStar);
            return;
        }
        this.aggStars.add(aggStar);
    }

    void clearAggStarList() {
        this.aggStars.clear();
    }

    public void reOrderAggStarList() {
        ArrayList<AggStar> oldList = new ArrayList<AggStar>(this.aggStars);
        this.aggStars.clear();
        for (AggStar aggStar : oldList) {
            this.addAggStar(aggStar);
        }
    }

    public List<AggStar> getAggStars() {
        return this.aggStars;
    }

    public Table getFactTable() {
        return this.factTable;
    }

    public Dialect getSqlQueryDialect() {
        return this.sqlQueryDialect;
    }

    public void setCacheAggregations(boolean cacheAggregations) {
        this.cacheAggregations = cacheAggregations;
        this.clearCachedAggregations(false);
    }

    public boolean isCacheAggregations() {
        return this.cacheAggregations;
    }

    boolean isCacheDisabled() {
        return MondrianProperties.instance().DisableCaching.get();
    }

    public void clearCachedAggregations(boolean forced) {
        if (forced || !this.cacheAggregations || this.isCacheDisabled()) {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("RolapStar.clearCachedAggregations: schema=");
                buf.append(this.schema.getName());
                buf.append(", star=");
                buf.append(this.getFactTable().getAlias());
                LOGGER.debug((Object)buf.toString());
            }
            this.localBars.get().aggregations.clear();
            this.localBars.get().segmentRefs.clear();
        }
    }

    public Aggregation lookupOrCreateAggregation(AggregationKey aggregationKey) {
        Aggregation aggregation = this.lookupSegment(aggregationKey);
        if (aggregation != null) {
            return aggregation;
        }
        aggregation = new Aggregation(aggregationKey);
        this.localBars.get().aggregations.put(aggregationKey, aggregation);
        return aggregation;
    }

    public Aggregation lookupSegment(AggregationKey aggregationKey) {
        return (Aggregation)this.localBars.get().aggregations.get(aggregationKey);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static Measure getStarMeasure(Member member) {
        return ((RolapStoredMeasure)member).getStarMeasure();
    }

    public Column lookupColumn(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumn(columnName);
    }

    public Table lookupTable(RolapSchema.PhysPath path) {
        List<Table> tables = this.getTables();
        for (Table table : tables) {
            if (!table.path.equals(path)) continue;
            return table;
        }
        return null;
    }

    public Table getTable(RolapSchema.PhysPath path) {
        Table table = this.getFactTable();
        for (RolapSchema.PhysHop hop : path.hopList) {
            if (hop.link == null) continue;
            table = table.findChild(hop, true);
        }
        return table;
    }

    private List<Table> getTables() {
        return this.populateTables(this.factTable, new ArrayList<Table>());
    }

    private List<Table> populateTables(Table table, List<Table> tables) {
        tables.add(table);
        for (Table childTable : table.children) {
            this.populateTables(childTable, tables);
        }
        return tables;
    }

    public BitKey getBitKey(List<String> tableAlias, List<String> columnName) {
        BitKey bitKey = BitKey.Factory.makeBitKey(this.getColumnCount());
        for (int i = 0; i < tableAlias.size(); ++i) {
            Column starColumn = this.lookupColumn(tableAlias.get(i), columnName.get(i));
            if (starColumn == null) continue;
            bitKey.set(starColumn.getBitPosition());
        }
        return bitKey;
    }

    public List<String> getAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        if (this.factTable != null) {
            RolapStar.collectAliases(aliasList, this.factTable);
        }
        return aliasList;
    }

    private static void collectAliases(List<String> aliasList, Table table) {
        aliasList.add(table.getAlias());
        for (Table child : table.children) {
            RolapStar.collectAliases(aliasList, child);
        }
    }

    public static void collectColumns(Collection<Column> columnList, Table table, RolapSchema.PhysRealColumn joinColumn) {
        Util.deprecated("used only by AggMatcher", true);
        if (joinColumn == null) {
            columnList.addAll(table.columnList);
        }
        for (Table child : table.children) {
            if (joinColumn != null && !child.getJoinCondition().left.equals(joinColumn)) continue;
            RolapStar.collectColumns(columnList, child, null);
        }
    }

    private void addColumn(Column c) {
        this.columnList.add(c.getBitPosition(), c);
    }

    public Column getColumn(int bitPos) {
        return this.columnList.get(bitPos);
    }

    public RolapSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "", true);
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix, boolean structure) {
        if (structure) {
            pw.print(prefix);
            pw.println("RolapStar:");
            String subprefix = prefix + "  ";
            this.factTable.print(pw, subprefix);
            for (AggStar aggStar : this.getAggStars()) {
                aggStar.print(pw, subprefix);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BarThreadLocal
    extends ThreadLocal<Bar> {
        private BarThreadLocal() {
        }

        @Override
        protected Bar initialValue() {
            return new Bar();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnComparator
    implements Comparator<Column> {
        public static ColumnComparator instance = new ColumnComparator();

        private ColumnComparator() {
        }

        @Override
        public int compare(Column o1, Column o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class Condition {
        private static final Logger LOGGER = Logger.getLogger(Condition.class);
        private final RolapSchema.PhysExpr left;
        private final RolapSchema.PhysExpr right;

        Condition(RolapSchema.PhysExpr left, RolapSchema.PhysExpr right) {
            assert (left != null);
            assert (right != null);
            Util.deprecated("obsolete class Condition", true);
            if (!(left instanceof RolapSchema.PhysRealColumn)) {
                LOGGER.debug((Object)("Condition.left NOT Column: " + left.getClass().getName()));
            }
            this.left = left;
            this.right = right;
        }

        public RolapSchema.PhysExpr getLeft() {
            return this.left;
        }

        public RolapSchema.PhysExpr getRight() {
            return this.right;
        }

        public String toSql() {
            return this.right.toSql() + " = " + this.left.toSql();
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)obj;
            return this.left.equals(that.left) && this.right.equals(that.right);
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Condition:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("left=");
            pw.println(this.left.toSql());
            pw.print(subprefix);
            pw.print("right=");
            pw.println(this.right.toSql());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table {
        private final RolapStar star;
        private final RolapSchema.PhysRelation relation;
        private final List<Column> columnList;
        private final Table parent;
        private List<Table> children;
        private final String alias;
        private final RolapSchema.PhysPath path;

        private Table(RolapStar star, RolapSchema.PhysRelation relation, Table parent, RolapSchema.PhysPath path) {
            assert (star != null);
            assert (relation != null);
            this.star = star;
            this.relation = relation;
            this.alias = this.chooseAlias();
            this.parent = parent;
            this.path = path;
            this.columnList = new ArrayList<Column>();
            this.children = Collections.emptyList();
        }

        public Condition getJoinCondition() {
            Util.deprecated("obsolete", true);
            return null;
        }

        public Table getParentTable() {
            return this.parent;
        }

        private void addColumn(Column column) {
            this.columnList.add(column);
            this.star.addColumn(column);
        }

        private void collectColumns(BitKey bitKey, List<Column> list) {
            Util.deprecated("not used - remove", true);
            for (Column column : this.getColumns()) {
                if (!bitKey.get(column.getBitPosition())) continue;
                list.add(column);
            }
            for (Table table : this.getChildren()) {
                table.collectColumns(bitKey, list);
            }
        }

        public List<Column> lookupColumns(String columnName) {
            ArrayList<Column> list = new ArrayList<Column>();
            for (Column column : this.getColumns()) {
                if (!this.matches(columnName, column)) continue;
                list.add(column);
            }
            return list;
        }

        private boolean matches(String columnName, Column column) {
            RolapSchema.PhysColumn expr = column.getExpression();
            if (expr instanceof RolapSchema.PhysRealColumn) {
                RolapSchema.PhysRealColumn columnExpr = (RolapSchema.PhysRealColumn)expr;
                return columnExpr.name.equals(columnName);
            }
            if (expr instanceof RolapSchema.PhysCalcColumn) {
                RolapSchema.PhysCalcColumn columnExpr = (RolapSchema.PhysCalcColumn)expr;
                return columnExpr.toSql().equals(columnName);
            }
            return false;
        }

        public Column lookupColumn(String columnName) {
            for (Column column : this.getColumns()) {
                if (!this.matches(columnName, column)) continue;
                return column;
            }
            return null;
        }

        public Column lookupColumnByExpression(RolapSchema.PhysColumn physColumn, boolean create, String name, String property) {
            for (Column column : this.getColumns()) {
                if (column instanceof Measure || !column.getExpression().equals(physColumn)) continue;
                return column;
            }
            if (create) {
                if (name == null) {
                    name = physColumn.name;
                }
                Column column = new Column(property == null ? name : name + " (" + property + ")", this, physColumn, physColumn.getDatatype() == null ? Dialect.Datatype.Numeric : physColumn.getDatatype(), physColumn.getInternalType(), null, null, null, Integer.MIN_VALUE, this.star.getColumnCount());
                this.addColumn(column);
                return column;
            }
            return null;
        }

        public Measure lookupMeasureByName(String cubeName, String name) {
            for (Column column : this.getColumns()) {
                Measure measure;
                if (!(column instanceof Measure) || !(measure = (Measure)column).getName().equals(name) || !measure.getCubeName().equals(cubeName)) continue;
                return measure;
            }
            return null;
        }

        RolapStar getStar() {
            return this.star;
        }

        public RolapSchema.PhysRelation getRelation() {
            return this.relation;
        }

        private String chooseAlias() {
            List<String> aliasList = this.star.getAliasList();
            int i = 0;
            while (true) {
                String candidateAlias = this.relation.getAlias();
                if (i > 0) {
                    candidateAlias = candidateAlias + "_" + i;
                }
                if (!aliasList.contains(candidateAlias)) {
                    return candidateAlias;
                }
                ++i;
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getTableName() {
            if (this.relation instanceof RolapSchema.PhysTable) {
                RolapSchema.PhysTable t = (RolapSchema.PhysTable)this.relation;
                return t.name;
            }
            return null;
        }

        void makeMeasure(RolapBaseCubeMeasure measure) {
            Measure starMeasure = this.makeMeasure(measure, measure.getExpr(), false);
            measure.setStarMeasure(starMeasure);
        }

        Measure makeMeasure(RolapBaseCubeMeasure measure, RolapSchema.PhysColumn expr, boolean rollup) {
            Dialect.Datatype datatype = measure.getAggregator().deriveDatatype(expr == null ? Collections.emptyList() : Collections.singletonList(expr.getDatatype()));
            if (datatype == null && expr != null) {
                datatype = measure.getDatatype();
            }
            Measure starMeasure = new Measure(measure.getName(), measure.getCube().getName(), rollup ? measure.getAggregator().getRollup() : measure.getAggregator(), this, expr, datatype);
            this.addColumn(starMeasure);
            return starMeasure;
        }

        public Table findChild(RolapSchema.PhysHop hop, boolean add) {
            for (Table child : this.getChildren()) {
                if (!child.relation.equals(hop.relation) || !Util.last(child.path.hopList).equals(hop)) continue;
                return child;
            }
            if (add) {
                Table child;
                RolapSchema.PhysPath path2 = new RolapSchema.PhysPathBuilder(this.path).add(hop).done();
                child = new Table(this.star, hop.relation, this, path2);
                if (this.children.isEmpty()) {
                    this.children = new ArrayList<Table>();
                }
                this.children.add(child);
                return child;
            }
            return null;
        }

        public Table findDescendant(String seekAlias) {
            if (this.getAlias().equals(seekAlias)) {
                return this;
            }
            for (Table child : this.getChildren()) {
                Table found = child.findDescendant(seekAlias);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public Table findAncestor(String tableName) {
            Table t = this;
            while (t != null) {
                if (t.relation.getAlias().equals(tableName)) {
                    return t;
                }
                t = t.parent;
            }
            return null;
        }

        public boolean equalsTableName(String tableName) {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table mt = (MondrianDef.Table)((Object)this.relation);
                if (mt.name.equals(tableName)) {
                    return true;
                }
            }
            return false;
        }

        public List<Table> getChildren() {
            return this.children;
        }

        public List<Column> getColumns() {
            return this.columnList;
        }

        public Table findTableWithLeftJoinCondition(String columnName) {
            Util.deprecated("obsolete", true);
            return null;
        }

        public Table findTableWithLeftCondition(RolapSchema.PhysExpr left) {
            Util.deprecated("obsolete", true);
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Table)) {
                return false;
            }
            Table other = (Table)obj;
            return this.getAlias().equals(other.getAlias());
        }

        public int hashCode() {
            return this.getAlias().hashCode();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subPrefix = prefix + "  ";
            pw.print(subPrefix);
            pw.print("alias=");
            pw.println(this.getAlias());
            if (this.relation != null) {
                pw.print(subPrefix);
                pw.print("relation=");
                pw.println(this.relation);
            }
            pw.print(subPrefix);
            pw.println("Columns:");
            String subSubPrefix = subPrefix + "  ";
            for (Column column : this.getColumns()) {
                column.print(pw, subSubPrefix);
                pw.println();
            }
            if (this.getLastHop() != null) {
                pw.print(subPrefix);
                pw.print(this.getLastHop());
            }
            for (Table child : this.getChildren()) {
                child.print(pw, subPrefix);
            }
        }

        private RolapSchema.PhysHop getLastHop() {
            return this.path.hopList.size() == 1 ? null : this.path.hopList.get(this.path.hopList.size() - 1);
        }

        public boolean containsColumn(String columnName) {
            return this.relation.getColumn(columnName, false) != null;
        }

        public RolapSchema.PhysPath getPath() {
            return this.path;
        }
    }

    public static class Measure
    extends Column {
        private final String cubeName;
        private final RolapAggregator aggregator;
        private final Dialect.Datatype datatype;

        public Measure(String name, String cubeName, RolapAggregator aggregator, Table table, RolapSchema.PhysColumn expression, Dialect.Datatype datatype) {
            super(name, table, expression, datatype, null, null, null, null, Integer.MIN_VALUE, table.star.getColumnCount());
            this.cubeName = cubeName;
            this.aggregator = aggregator;
            this.datatype = datatype;
        }

        public Dialect.Datatype getDatatype() {
            return this.datatype;
        }

        public RolapAggregator getAggregator() {
            return this.aggregator;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Measure)) {
                return false;
            }
            Measure that = (Measure)o;
            if (!super.equals(that)) {
                return false;
            }
            if (!this.cubeName.equals(that.cubeName)) {
                return false;
            }
            return that.aggregator == this.aggregator;
        }

        public int hashCode() {
            int h = super.hashCode();
            h = Util.hash(h, this.aggregator);
            return h;
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.aggregator.getExpression(this.getExpression() == null ? null : this.getExpression().toSql()));
        }

        public String getCubeName() {
            return this.cubeName;
        }
    }

    public static class Column {
        private final Table table;
        private final RolapSchema.PhysColumn expression;
        private final Dialect.Datatype datatype;
        protected final SqlStatement.Type internalType;
        private final String name;
        private final Column parentColumn;
        private final String usagePrefix;
        private final Column nameColumn;
        private final int bitPosition;
        private int approxCardinality = Integer.MIN_VALUE;

        private Column(String name, Table table, RolapSchema.PhysColumn expression, Dialect.Datatype datatype, SqlStatement.Type internalType, Column nameColumn, Column parentColumn, String usagePrefix, int approxCardinality, int bitPosition) {
            assert (table != null);
            assert (name != null);
            assert (datatype != null);
            assert (expression == null || datatype == expression.getDatatype() || expression.getDatatype() == null || this instanceof Measure) : "expression " + expression + ", datatype" + (Object)((Object)datatype) + " mismatch";
            assert (expression == null || internalType == expression.getInternalType());
            this.name = name;
            this.table = table;
            this.expression = expression;
            this.datatype = datatype;
            this.internalType = internalType;
            this.bitPosition = bitPosition;
            this.nameColumn = nameColumn;
            this.parentColumn = parentColumn;
            this.usagePrefix = usagePrefix;
            this.approxCardinality = approxCardinality;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column other = (Column)obj;
            return other.table == this.table && Util.equals(other.expression, this.expression) && other.name.equals(this.name);
        }

        public int hashCode() {
            int h = this.name.hashCode();
            h = Util.hash(h, this.table);
            return h;
        }

        public String getName() {
            return this.name;
        }

        public int getBitPosition() {
            return this.bitPosition;
        }

        public RolapStar getStar() {
            return this.table.star;
        }

        public Table getTable() {
            return this.table;
        }

        public Column getParentColumn() {
            Util.deprecated("parentColumn seems to be used ONLY for AggGen; remove it and represent the information outside RolapStar?", false);
            return this.parentColumn;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public boolean isNameColumn() {
            return this.nameColumn != null;
        }

        public RolapSchema.PhysColumn getExpression() {
            return this.expression;
        }

        public int getCardinality() {
            if (this.approxCardinality < 0) {
                this.approxCardinality = ((Table)this.table).relation.getSchema().statistic.getColumnCardinality(this.table.relation, this.expression, this.approxCardinality);
            }
            return this.approxCardinality;
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.getExpression().toSql());
        }

        public Dialect.Datatype getDatatype() {
            return this.expression.getDatatype();
        }

        public String getDatatypeString(Dialect dialect) {
            String string;
            Util.deprecated("move to dialect, or remove?; not used?", true);
            SqlQuery query = new SqlQuery(dialect);
            query.addFrom(this.table.star.factTable.relation, this.table.star.factTable.alias, false);
            query.addFrom(this.table.relation, this.table.alias, false);
            query.addSelect(this.expression.toSql(), null);
            String sql = query.toString();
            Connection jdbcConnection = null;
            PreparedStatement pstmt = null;
            try {
                jdbcConnection = this.table.star.dataSource.getConnection();
                pstmt = jdbcConnection.prepareStatement(sql);
                ResultSetMetaData resultSetMetaData = pstmt.getMetaData();
                assert (resultSetMetaData.getColumnCount() == 1);
                String type = resultSetMetaData.getColumnTypeName(1);
                int precision = resultSetMetaData.getPrecision(1);
                int scale = resultSetMetaData.getScale(1);
                if (type.equals("DOUBLE")) {
                    precision = 0;
                }
                String typeString = precision == 0 ? type : (scale == 0 ? type + "(" + precision + ")" : type + "(" + precision + ", " + scale + ")");
                string = typeString;
            }
            catch (SQLException e) {
                try {
                    throw Util.newError(e, "Error while deriving type of column " + this.toString());
                }
                catch (Throwable throwable) {
                    Util.close(null, pstmt, jdbcConnection);
                    throw throwable;
                }
            }
            Util.close(null, pstmt, jdbcConnection);
            return string;
        }

        public SqlStatement.Type getInternalType() {
            return this.internalType;
        }
    }

    public static class Bar {
        private final Map<AggregationKey, Aggregation> aggregations = new ReferenceMap(2, 2);
        private final List<SoftReference<SegmentWithData>> segmentRefs = new ArrayList<SoftReference<SegmentWithData>>();
    }
}

