/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheMemberReader
implements MemberReader,
MemberCache {
    private final MemberSource source;
    private final List<RolapMember> members;
    private final Map<Pair<RolapCubeLevel, Object>, RolapMember> mapKeyToMember;

    CacheMemberReader(MemberSource source) {
        this.source = source;
        this.mapKeyToMember = new HashMap<Pair<RolapCubeLevel, Object>, RolapMember>();
        this.members = source.getMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            RolapMember member = this.members.get(i);
            ((RolapMemberBase)member).setOrdinal(i);
        }
    }

    @Override
    public RolapCubeHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember getMemberByKey(RolapCubeLevel level, List<Comparable> keyValues) {
        assert (keyValues.size() == 1);
        return this.mapKeyToMember.get(keyValues.get(0));
    }

    @Override
    public List<RolapMember> getMembers() {
        return this.members;
    }

    @Override
    public RolapMember getMember(RolapCubeLevel level, Object key) {
        return this.mapKeyToMember.get(Pair.of(level, key));
    }

    public RolapMember getMember(RolapCubeLevel level, Object key, boolean mustCheckCacheStatus) {
        return this.mapKeyToMember.get(Pair.of(level, key));
    }

    @Override
    public Object putMember(RolapCubeLevel level, Object key, RolapMember value) {
        return this.mapKeyToMember.put(Pair.of(level, key), value);
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putChildren(RolapCubeLevel level, TupleConstraint constraint, List<RolapMember> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public RolapMember removeMember(RolapCubeLevel level, Object key) {
        throw new UnsupportedOperationException();
    }

    public RolapMember removeMemberAndDescendants(RolapCubeLevel level, Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        return null;
    }

    @Override
    public List<RolapMember> getLevelMembersFromCache(RolapCubeLevel level, TupleConstraint constraint) {
        return null;
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    @Override
    public List<RolapMember> getRootMembers() {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        for (RolapMember member : this.members) {
            if (member.getParentMember() != null) continue;
            list.add(member);
        }
        return list;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        int levelDepth = level.getDepth();
        for (RolapMember member : this.members) {
            if (member.getLevel().getDepth() != levelDepth) continue;
            list.add(member);
        }
        return list;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level, TupleConstraint constraint) {
        return this.getMembersInLevel(level);
    }

    @Override
    public int getLevelMemberCount(RolapCubeLevel level) {
        int count = 0;
        int levelDepth = level.getDepth();
        for (Member member : this.members) {
            if (member.getLevel().getDepth() != levelDepth) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        for (Member member : this.members) {
            if (member.getParentMember() != parentMember) continue;
            children.add((RolapMember)member);
        }
    }

    @Override
    public void getMemberChildren(RolapMember member, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(member, children);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        for (RolapMember member : this.members) {
            if (!parentMembers.contains(member.getParentMember())) continue;
            children.add(member);
        }
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(parentMembers, children);
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        if (n >= 0) {
            for (int ordinal = member.getOrdinal(); ordinal < this.members.size(); ++ordinal) {
                if (this.members.get(ordinal).getLevel() != member.getLevel() || n-- != 0) continue;
                return this.members.get(ordinal);
            }
            return member.getHierarchy().getNullMember();
        }
        for (int ordinal = member.getOrdinal(); ordinal >= 0; --ordinal) {
            if (this.members.get(ordinal).getLevel() != member.getLevel() || n++ != 0) continue;
            return this.members.get(ordinal);
        }
        return member.getHierarchy().getNullMember();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> list) {
        assert (startMember != null);
        assert (endMember != null);
        assert (startMember.getLevel() == endMember.getLevel());
        int endOrdinal = endMember.getOrdinal();
        for (int i = startMember.getOrdinal(); i <= endOrdinal; ++i) {
            if (this.members.get(i).getLevel() != endMember.getLevel()) continue;
            list.add(this.members.get(i));
        }
    }

    @Override
    public int getMemberCount() {
        return this.members.size();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        if (m1 == m2) {
            return 0;
        }
        if (siblingsAreEqual && m1.getParentMember() == m2.getParentMember()) {
            return 0;
        }
        Util.assertTrue(this.members.get(m1.getOrdinal()) == m1);
        Util.assertTrue(this.members.get(m2.getOrdinal()) == m2);
        return m1.getOrdinal() < m2.getOrdinal() ? -1 : 1;
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return null;
    }

    @Override
    public RolapMember getDefaultMember() {
        RolapMember defaultMember = this.getHierarchy().getDefaultMember();
        if (defaultMember != null) {
            return defaultMember;
        }
        return this.getRootMembers().get(0);
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        return member.getParentMember();
    }
}

