/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import mondrian.olap.Cube;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap4j.MondrianOlap4jCatalog;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jSchema
extends MondrianOlap4jMetadataElement
implements Schema,
Named {
    final MondrianOlap4jCatalog olap4jCatalog;
    final String schemaName;
    final RolapSchema schema;

    MondrianOlap4jSchema(MondrianOlap4jCatalog olap4jCatalog, String schemaName, RolapSchema schema) {
        this.olap4jCatalog = olap4jCatalog;
        this.schemaName = schemaName;
        this.schema = schema;
    }

    public Catalog getCatalog() {
        return this.olap4jCatalog;
    }

    public String getUniqueName() {
        return this.schema.getUniqueName();
    }

    public String getCaption() {
        return this.schema.getLocalized(LocalizedProperty.CAPTION, this.getLocale());
    }

    public String getDescription() {
        return this.schema.getLocalized(LocalizedProperty.DESCRIPTION, this.getLocale());
    }

    public boolean isVisible() {
        return this.schema.isVisible();
    }

    public NamedList<org.olap4j.metadata.Cube> getCubes() throws OlapException {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        for (Cube cube : olap4jConnection.getMondrianConnection().getSchemaReader().getCubes()) {
            if (cube.getName().startsWith("$")) continue;
            list.add((Object)olap4jConnection.toOlap4j(cube));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public NamedList<Dimension> getSharedDimensions() throws OlapException {
        MondrianOlap4jConnection olap4jConnection = this.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        TreeSet<MondrianOlap4jDimension> dimensions = new TreeSet<MondrianOlap4jDimension>(new Comparator<MondrianOlap4jDimension>(){

            @Override
            public int compare(MondrianOlap4jDimension o1, MondrianOlap4jDimension o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Role role = olap4jConnection.getMondrianConnection().getRole();
        for (RolapCubeDimension dim : this.schema.getSharedDimensionList()) {
            if (!role.canAccess(dim)) continue;
            dimensions.add(olap4jConnection.toOlap4j(dim));
        }
        NamedListImpl list = new NamedListImpl();
        list.addAll(dimensions);
        return Olap4jUtil.cast((NamedList)list);
    }

    public Collection<Locale> getSupportedLocales() {
        return this.schema.locales;
    }

    public String getName() {
        return this.schemaName;
    }

    final Locale getLocale() {
        return this.olap4jCatalog.olap4jDatabase.getOlapConnection().getLocale();
    }

    @Override
    protected OlapElement getOlapElement() {
        return this.schema;
    }
}

