/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class DrilldownMemberFunDef
extends FunDefBase {
    static final String[] reservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("DrilldownMember", "DrilldownMember(<Set1>, <Set2>[, RECURSIVE])", "Drills down the members in a set that are present in a second specified set.", new String[]{"fxxx", "fxxxy"}, DrilldownMemberFunDef.class, reservedWords);

    public DrilldownMemberFunDef(FunDef funDef) {
        super(funDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = DrilldownMemberFunDef.getLiteralArg(call, 2, "", reservedWords);
        final boolean recursive = literalArg.equals("RECURSIVE");
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList list1 = listCalc1.evaluateList(evaluator);
                TupleList list2 = listCalc2.evaluateList(evaluator);
                return this.drilldownMember(list1, list2, evaluator);
            }

            protected void drillDownObj(Evaluator evaluator, Member[] tuple, Set<Member> memberSet, TupleList resultList) {
                for (int k = 0; k < tuple.length; ++k) {
                    Member member = tuple[k];
                    if (!memberSet.contains(member)) continue;
                    List<Member> children = evaluator.getSchemaReader().getMemberChildren(member);
                    Member[] tuple2 = (Member[])tuple.clone();
                    Iterator<Member> i$ = children.iterator();
                    while (i$.hasNext()) {
                        Member childMember;
                        tuple2[k] = childMember = i$.next();
                        resultList.addTuple(tuple2);
                        if (!recursive) continue;
                        this.drillDownObj(evaluator, tuple2, memberSet, resultList);
                    }
                    break;
                }
            }

            private TupleList drilldownMember(TupleList v0, TupleList v1, Evaluator evaluator) {
                assert (v1.getArity() == 1);
                if (v0.isEmpty() || v1.isEmpty()) {
                    return v0;
                }
                HashSet<Member> set1 = new HashSet<Member>(v1.slice(0));
                TupleList result = TupleCollections.createList(v0.getArity());
                int i = 0;
                int n = v0.size();
                Member[] members = new Member[v0.getArity()];
                while (i < n) {
                    List o = (List)v0.get(i++);
                    o.toArray(members);
                    result.add(o);
                    this.drillDownObj(evaluator, members, set1, result);
                }
                return result;
            }
        };
    }
}

