/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMetaStoreAttribute
implements IMetaStoreAttribute {
    public static final String XML_TAG = "attribute";
    protected String id = null;
    protected Object value = null;
    protected Map<String, IMetaStoreAttribute> children = new HashMap<String, IMetaStoreAttribute>();
    protected String filename;

    public XmlMetaStoreAttribute() {
    }

    public XmlMetaStoreAttribute(String id, Object value) {
        this();
        this.id = id;
        this.value = value;
    }

    public XmlMetaStoreAttribute(IMetaStoreAttribute element) {
        this();
        this.id = element.getId();
        this.value = element.getValue();
        for (IMetaStoreAttribute childElement : element.getChildren()) {
            this.addChild(new XmlMetaStoreAttribute(childElement));
        }
    }

    protected void loadAttribute(Node attributeNode) {
        NodeList elementNodes = attributeNode.getChildNodes();
        for (int e = 0; e < elementNodes.getLength(); ++e) {
            Node elementNode = elementNodes.item(e);
            if ("id".equals(elementNode.getNodeName())) {
                this.id = XmlUtil.getNodeValue(elementNode);
                continue;
            }
            if ("value".equals(elementNode.getNodeName())) {
                this.value = XmlUtil.getNodeValue(elementNode);
                continue;
            }
            if ("type".equals(elementNode.getNodeName())) {
                String type = XmlUtil.getNodeValue(elementNode);
                if ("Integer".equals(type)) {
                    this.value = Integer.valueOf((String)this.value);
                    continue;
                }
                if ("Double".equals(type)) {
                    this.value = Double.valueOf((String)this.value);
                    continue;
                }
                if (!"Long".equals(type)) continue;
                this.value = Long.valueOf((String)this.value);
                continue;
            }
            if (!"children".equals(elementNode.getNodeName())) continue;
            NodeList childNodes = elementNode.getChildNodes();
            for (int c = 0; c < childNodes.getLength(); ++c) {
                Node childNode = childNodes.item(c);
                if (!childNode.getNodeName().equals("child")) continue;
                XmlMetaStoreAttribute childElement = new XmlMetaStoreAttribute();
                childElement.loadAttribute(childNode);
                this.addChild(childElement);
            }
        }
    }

    @Override
    public void deleteChild(String entityId) {
        Iterator<IMetaStoreAttribute> it = this.children.values().iterator();
        while (it.hasNext()) {
            IMetaStoreAttribute element = it.next();
            if (!element.getId().equals(entityId)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public List<IMetaStoreAttribute> getChildren() {
        return new ArrayList<IMetaStoreAttribute>(this.children.values());
    }

    public void setChildren(List<IMetaStoreAttribute> children) {
        this.children.clear();
        for (IMetaStoreAttribute child : children) {
            this.children.put(child.getId(), child);
        }
    }

    @Override
    public void addChild(IMetaStoreAttribute element) {
        this.children.put(element.getId(), element);
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public IMetaStoreAttribute getChild(String id) {
        return this.children.get(id);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    protected void appendAttribute(IMetaStoreAttribute attribute, Document doc, Element parentElement) throws MetaStoreException {
        if (attribute.getId() == null) {
            throw new MetaStoreException("An attribute has to be non-null");
        }
        Element idElement = doc.createElement("id");
        idElement.appendChild(doc.createTextNode(attribute.getId()));
        parentElement.appendChild(idElement);
        Element valueElement = doc.createElement("value");
        valueElement.appendChild(doc.createTextNode(attribute.getValue() != null ? attribute.getValue().toString() : ""));
        parentElement.appendChild(valueElement);
        Element typeElement = doc.createElement("type");
        typeElement.appendChild(doc.createTextNode(this.getType(attribute.getValue())));
        parentElement.appendChild(typeElement);
        if (!attribute.getChildren().isEmpty()) {
            Element childrenElement = doc.createElement("children");
            parentElement.appendChild(childrenElement);
            for (IMetaStoreAttribute childElement : attribute.getChildren()) {
                Element child = doc.createElement("child");
                childrenElement.appendChild(child);
                this.appendAttribute(childElement, doc, child);
            }
        }
    }

    protected String getType(Object object) {
        if (object == null) {
            return "String";
        }
        if (object instanceof String) {
            return "String";
        }
        if (object instanceof Integer) {
            return "Integer";
        }
        if (object instanceof Long) {
            return "Long";
        }
        if (object instanceof Double) {
            return "Double";
        }
        return "String";
    }
}

