/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq.generator;

import com.bitmechanic.maxq.IScriptAdapter;
import com.bitmechanic.maxq.Utils;
import com.bitmechanic.maxq.generator.AbstractCodeGenerator;
import com.bitmechanic.maxq.generator.IScriptGenerator;

public class JythonCodeGenerator
extends AbstractCodeGenerator {
    public JythonCodeGenerator(IScriptAdapter adapter) {
        super(adapter);
    }

    public void doCreateList() {
        this.getScriptAdapter().append(this.createStatement("list = ArrayList()"));
    }

    public void doCallUrl(String url, String method, String data, String contentLength, String list) {
        this.getScriptAdapter().append(this.createStatement("self." + method + "(\"" + url + "\"" + data + contentLength + list + ")"));
    }

    public void doSetData(String data) {
        this.getScriptAdapter().append(this.createStatement("data = '" + data + "'"));
    }

    public void doAssertResponse(String respCode) {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("print \"Response code: %s\" % self.getResponse().getStatusCode()"));
        if (!respCode.startsWith("302")) {
            result.append(this.createStatement("self.assertEquals(\"Assert number " + ++this.assertNumber + " failed\", " + respCode + ", self.getResponse().getStatusCode())"));
        }
        this.getScriptAdapter().append(result.toString());
    }

    public void doTidyCode(String url) {
        StringBuffer buf = new StringBuffer();
        if (jtidyConfigFile != null) {
            buf.append(this.createStatement("#validate html text via Tidy"));
            buf.append(this.createStatement("tidy.parse(self.getResponse().getInputStream(), System.out)"));
            buf.append(this.createStatement("if tidy.parseWarnings + tidy.parseErrors > 0:"));
            buf.append(this.createStatement("  print '''<<Tidy report>> URL=" + url.trim() + " WARNING=%d, and ERROR=%d\n''' % (tidy.parseWarnings, tidy.parseErrors)"));
            buf.append(this.createStatement("  print '''+------------------------------------------------------------------------------+'''"));
        }
        this.getScriptAdapter().append(buf.toString());
    }

    public void doResponseForStdOut(String url) {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("print '''+--------Begin HTTP response for :" + url + "--------+'''"));
        result.append(this.createStatement("rsp = String(self.getResponse().getData())"));
        result.append(this.createStatement("print rsp"));
        result.append(this.createStatement("print '''+--------End HTTP response for :" + url + "--------+'''"));
        result.append(this.createStatement("print '''+--------MessageDigest :%s--------+''' % self.getDigestStr(rsp) "));
        this.getScriptAdapter().append(result.toString());
    }

    public void doResponseForFile() {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("rsp = String(self.getResponse().getData())"));
        result.append(this.createStatement("filename = self.getResponse().hashCode().toString() + '.html'"));
        result.append(this.createStatement("print '''+--------Save html output to :%s--------+''' % filename"));
        result.append(this.createStatement("htmlFile = EditorPane.saveHTML(filename, rsp, 'tmp')"));
        this.getScriptAdapter().append(result.toString());
    }

    public void doAddParameterToList(String name, String value) {
        name = Utils.replace(name, "'''", "\\'''");
        value = Utils.replace(value, "'''", "\\'''");
        this.getScriptAdapter().append(this.createStatement("list.add(NameValuePair('''" + name + "''', '''" + value + "''')" + ")"));
    }

    public void doTestUrlMessage(String url) {
        this.getScriptAdapter().append(this.createStatement("print \"Testing URL: %s\" % self.replaceURL('''" + url + "''')"));
    }

    public String[] getValidFileExtensions() {
        return new String[]{".py"};
    }

    public void doStartRecording() {
        if (!this.scriptContainsTestDeclaration()) {
            this.getScriptAdapter().insert(this.getTestDeclarationText(), 0);
        }
    }

    public void doStopRecording() {
        if (!this.scriptContainsMainDeclaration()) {
            this.getScriptAdapter().append(this.getMainDeclarationText());
        }
    }

    public void doSave(String path, String fileName) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("file name cannot be null");
        }
        String name = fileName;
        name = fileName.indexOf(".") > -1 ? fileName.substring(0, fileName.indexOf(".")) : fileName;
        this.setTestName(name);
        this.setTestPath(path);
        this.updateTestName();
    }

    public void doLoad(String script) {
        super.loadScriptAdapter(script);
        this.setTestName(this.parseTestName());
    }

    public String parseTestName() {
        String testName = null;
        int pos = this.getClassNameStartPos();
        if (pos > -1) {
            int end = this.getClassNameEndPos();
            testName = this.getScript().substring(pos, end).trim();
        }
        return testName;
    }

    private void updateTestName() {
        this.getScriptAdapter().replace(this.getTestName(), this.getClassNameStartPos(), this.getClassNameEndPos());
        String replacestr = this.getTestName() + "(\"" + this.getTestName() + "\")";
        this.getScriptAdapter().replace(replacestr, this.getTestNameStartPos(), this.getTestNameEndPos());
    }

    private int getClassNameStartPos() {
        int pos = -1;
        if (this.getScript() != null && (pos = this.getScript().indexOf("class ")) > -1) {
            pos += 6;
        }
        return pos;
    }

    private int getClassNameEndPos() {
        int end = -1;
        if (this.getScript() != null) {
            end = this.getScript().indexOf("(HttpTestCase):");
        }
        return end;
    }

    private int getTestNameEndPos() {
        int end = -1;
        if (this.getScript() != null) {
            end = this.getScript().indexOf("    test.Run()");
        }
        return --end;
    }

    private int getTestNameStartPos() {
        int pos = -1;
        if (this.getScript() != null && (pos = this.getScript().indexOf("test = ")) > -1) {
            pos += 7;
        }
        return pos;
    }

    private boolean scriptContainsMainDeclaration() {
        int pos = this.getScript().indexOf(this.getMainDeclarationPrefix());
        return pos > -1;
    }

    private boolean scriptContainsTestDeclaration() {
        int pos = this.getScript().indexOf(this.getTestDeclarationPrefix());
        return pos > -1;
    }

    private String getMainDeclarationText() {
        StringBuffer result = new StringBuffer(this.getMainDeclarationPrefix());
        result.append("    test = ");
        result.append(this.getTestName());
        result.append("(\"" + this.getTestName() + "\")").append(IScriptGenerator.EOL);
        result.append("    test.Run()");
        return result.toString();
    }

    private String getTestDeclarationText() {
        StringBuffer result = new StringBuffer(this.getTestDeclarationPrefix());
        if (jtidyConfigFile != null) {
            result.append(this.generateTidyImport());
        }
        if (JythonCodeGenerator.isCpRspToStdout()) {
            result.append("from java.security import MessageDigest").append(IScriptGenerator.EOL);
        }
        result.append(IScriptGenerator.EOL);
        result.append("# definition of test class").append(IScriptGenerator.EOL);
        result.append("class " + this.getTestName() + "(HttpTestCase):").append(IScriptGenerator.EOL);
        result.append("    def __init__(self, testName):").append(IScriptGenerator.EOL);
        result.append("        HttpTestCase.__init__(self, testName)").append(IScriptGenerator.EOL).append(IScriptGenerator.EOL);
        result.append("    # Add setup code here.  See Junit javadoc." + IScriptGenerator.EOL);
        result.append("    def setUp(self):" + IScriptGenerator.EOL);
        result.append("        pass" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("    # Add tearDown code here.  See Junit javadoc." + IScriptGenerator.EOL);
        result.append("    def tearDown(self):" + IScriptGenerator.EOL);
        result.append("        pass" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("    #Runs the test" + IScriptGenerator.EOL);
        result.append("    def runTest(self):" + IScriptGenerator.EOL);
        result.append("        self.doTest()" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        if (JythonCodeGenerator.isCpRspToStdout()) {
            result.append("    def getDigestStr(self, http_str):").append(IScriptGenerator.EOL);
            result.append("        md = MessageDigest.getInstance(\"SHA\")").append(IScriptGenerator.EOL);
            result.append("        md.update(http_str.getBytes())").append(IScriptGenerator.EOL);
            result.append("        digest = md.digest()").append(IScriptGenerator.EOL);
            result.append("        hexString = StringBuffer()").append(IScriptGenerator.EOL);
            result.append("        for i in digest:").append(IScriptGenerator.EOL);
            result.append("            hexString.append(Integer.toHexString(0xFF & i))").append(IScriptGenerator.EOL);
            result.append("            hexString.append(\" \")").append(IScriptGenerator.EOL);
            result.append("        return hexString.toString()").append(IScriptGenerator.EOL).append(IScriptGenerator.EOL);
        }
        if (jtidyConfigFile != null) {
            result.append(this.setTidyConfig());
        }
        result.append("    #Test script" + IScriptGenerator.EOL);
        result.append("    def doTest(self):" + IScriptGenerator.EOL);
        return result.toString();
    }

    private String getTestDeclarationPrefix() {
        StringBuffer result = new StringBuffer();
        result.append("# imports").append(IScriptGenerator.EOL);
        result.append("from com.bitmechanic.maxq import HttpTestCase").append(IScriptGenerator.EOL);
        result.append("from junit.textui import TestRunner").append(IScriptGenerator.EOL);
        result.append("from java.lang import *").append(IScriptGenerator.EOL);
        result.append("from java.io import *").append(IScriptGenerator.EOL);
        result.append("from java.util import *").append(IScriptGenerator.EOL);
        result.append("from org.apache.commons.httpclient import NameValuePair").append(IScriptGenerator.EOL);
        result.append(IScriptGenerator.EOL);
        return result.toString();
    }

    private String generateTidyImport() {
        return "from org.w3c.tidy import *" + IScriptGenerator.EOL;
    }

    private String setTidyConfig() {
        StringBuffer result = new StringBuffer();
        result.append(this.createStatement("#setup Tidy configurations"));
        result.append(this.createStatement("tidy = Tidy()"));
        result.append(this.createStatement("tidy.setConfigurationFromFile(r\"" + jtidyConfigFile + "\")"));
        return result.toString();
    }

    private String createStatement(String text) {
        return Utils.lpad(8, text + IScriptGenerator.EOL);
    }

    private String getMainDeclarationPrefix() {
        StringBuffer result = new StringBuffer();
        result.append(IScriptGenerator.EOL).append(IScriptGenerator.EOL);
        result.append("##########################################").append(IScriptGenerator.EOL).append(IScriptGenerator.EOL);
        result.append("# Code to load and run the test").append(IScriptGenerator.EOL);
        result.append("if __name__ == 'main':").append(IScriptGenerator.EOL);
        return result.toString();
    }
}

