/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.HttpTestCase;
import com.bitmechanic.maxq.ProxyServer;
import com.bitmechanic.maxq.SwingMain;
import com.bitmechanic.maxq.Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.python.util.PythonInterpreter;

public class Main {
    private static final String VERSION = "0.93";
    private static final int DEFAULT_PORT = 8090;
    private BufferedReader in;
    private ProxyServer proxy;
    private ArrayList actionList = new ArrayList();

    public static void main(String[] argv) {
        block6: {
            HashMap args = Main.parseArgs(argv);
            Main m = new Main();
            try {
                if (args.get("-path") != null) {
                    Properties ppref = new Properties();
                    ppref.put("python.path", (String)args.get("-path"));
                    PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)ppref, (String[])new String[0]);
                }
                if (args.get("-run") != null) {
                    m.runTests(argv);
                    break block6;
                }
                int port = 8090;
                try {
                    port = Integer.parseInt((String)args.get("-port"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                m.startGUI(port);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static HashMap parseArgs(String[] argv) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].startsWith("-") || i >= argv.length - 1) continue;
            map.put(argv[i], argv[i + 1]);
        }
        return map;
    }

    public void runTests(String[] argv) {
        boolean runFlagFound = false;
        boolean quiet = false;
        int exitCode = 0;
        for (int i = 0; i < argv.length; ++i) {
            if (runFlagFound) {
                String fileName = argv[i];
                if (!quiet) {
                    System.out.println("Running: " + fileName);
                }
                PythonInterpreter python = new PythonInterpreter();
                try {
                    python.execfile(fileName);
                    if (quiet) continue;
                    System.out.println("OK");
                    System.out.println();
                }
                catch (Throwable e) {
                    System.err.println("FAILURE in script: " + fileName);
                    e.printStackTrace();
                    exitCode = 1;
                }
                continue;
            }
            if (argv[i].equals("-run")) {
                runFlagFound = true;
                continue;
            }
            if (argv[i].equals("-q")) {
                quiet = true;
                continue;
            }
            if (argv[i].equals("-debug")) {
                Test.debug = true;
                continue;
            }
            if (!argv[i].equals("-urlreplace")) continue;
            if (argv.length < i + 2) {
                System.err.println("Missing required two arguments to -urlreplace switch");
                System.exit(1);
            }
            HttpTestCase.setURLReplace(argv[++i], argv[++i]);
        }
        System.exit(exitCode);
    }

    public void startGUI(int port) throws IOException {
        System.out.println("MaxQ Proxy Recorder v0.93");
        System.out.println();
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.proxy = new ProxyServer(port);
        this.proxy.start();
        System.out.println("Proxy server started on port: " + port);
        SwingMain gui = new SwingMain();
        gui.init();
        this.proxy.addObserver(gui.getRequestProcessor());
    }
}

