/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;

public final class FastStack<T>
implements Serializable,
Cloneable {
    private Object[] contents;
    private int size;
    private int initialSize;
    private static final long serialVersionUID = 3111917250800511580L;

    public FastStack() {
        this.initialSize = 10;
    }

    public FastStack(int size) {
        this.initialSize = Math.max(1, size);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void push(T o) {
        if (this.contents == null) {
            this.contents = new Object[this.initialSize];
            this.contents[0] = o;
            this.size = 1;
            return;
        }
        int oldSize = this.size++;
        if (this.contents.length == this.size) {
            Object[] newContents = new Object[this.size + this.initialSize];
            System.arraycopy(this.contents, 0, newContents, 0, this.size);
            this.contents = newContents;
        }
        this.contents[oldSize] = o;
    }

    public T peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.contents[this.size - 1];
    }

    public T pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        Object retval = this.contents[this.size];
        this.contents[this.size] = null;
        return (T)retval;
    }

    public FastStack<T> clone() {
        try {
            FastStack stack = (FastStack)super.clone();
            if (this.contents != null) {
                stack.contents = (Object[])this.contents.clone();
            }
            return stack;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone not supported? Why?");
        }
    }

    public void clear() {
        if (this.contents != null) {
            Arrays.fill(this.contents, 0, this.size, null);
        }
        this.size = 0;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return (T)this.contents[index];
    }

    public String toString() {
        return "FastStack{contents=" + (this.contents == null ? null : Arrays.asList(this.contents)) + ", size=" + this.size + ", initialSize=" + this.initialSize + '}';
    }
}

