/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.libformula.editor.util;

import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;

public class PositionAndLength {
    private int position;
    private int length;

    public PositionAndLength(int position, int length) {
        this.position = position;
        this.length = length;
    }

    public static final PositionAndLength calculatePositionAndLength(String expression, ParsePosition position) {
        int col;
        int p = 0;
        PositionAndLength result = new PositionAndLength(0, 0);
        if (position == null) {
            return result;
        }
        int line = 1;
        while (p < expression.length() && line < position.getStartLine()) {
            if (expression.substring(p).startsWith("\n\r")) {
                ++line;
                p += 2;
                continue;
            }
            if (expression.substring(p).startsWith("\n")) {
                ++line;
                ++p;
                continue;
            }
            if (expression.substring(p).startsWith("\r")) {
                ++line;
                ++p;
                continue;
            }
            ++p;
        }
        for (col = 1; p < expression.length() && col < position.getStartColumn(); ++p, ++col) {
        }
        result.setPosition(p);
        while (p < expression.length() && line < position.getEndLine()) {
            if (expression.substring(p).startsWith("\n\r")) {
                ++line;
                col = 1;
                p += 2;
                continue;
            }
            if (expression.substring(p).startsWith("\n")) {
                ++line;
                ++p;
                col = 1;
                continue;
            }
            if (expression.substring(p).startsWith("\r")) {
                ++line;
                ++p;
                col = 1;
                continue;
            }
            ++p;
        }
        while (p < expression.length() && col < position.getEndColumn()) {
            ++p;
            ++col;
        }
        int length = p - result.getPosition() + 1;
        result.setLength(length);
        return result;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

