/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.PackageMessages;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.WebResult;

public abstract class BodyHttpServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 6576714217004890327L;
    private final PackageMessages messages = new PackageMessages(this.getClass());

    protected boolean useXML(HttpServletRequest request) {
        return "Y".equalsIgnoreCase(request.getParameter("xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(this.getContextPath())) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.messages.getString("Log.Execute", new String[0]));
        }
        boolean useXML = this.useXML(request);
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        try {
            if (useXML) {
                this.startXml(response, out);
            } else {
                this.beginHtml(response, out);
            }
            WebResult result = this.generateBody(request, response, useXML);
            if (result != null) {
                out.println(result.getXML());
            }
        }
        catch (Exception e) {
            String st = ExceptionUtils.getFullStackTrace((Throwable)e);
            if (useXML) {
                out.println(new WebResult("ERROR", st).getXML());
            } else {
                out.println("<p><pre>");
                out.println(Encode.forHtml((String)st));
                out.println("</pre>");
            }
        }
        finally {
            if (!useXML) {
                this.endHtml(out);
            }
            out.flush();
            IOUtils.closeQuietly((Writer)out);
        }
    }

    protected void beginHtml(HttpServletResponse response, PrintWriter out) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<TITLE>");
        out.println(Encode.forHtml((String)this.getTitle()));
        out.println("</TITLE>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.println("</HEAD>");
        out.println("<BODY>");
    }

    protected void endHtml(PrintWriter out) {
        out.println("<p>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    protected void startXml(HttpServletResponse response, PrintWriter out) throws IOException {
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
    }

    abstract WebResult generateBody(HttpServletRequest var1, HttpServletResponse var2, boolean var3) throws Exception;

    @Override
    public String getService() {
        return this.getContextPath() + " (" + this.getTitle() + ")";
    }

    private String getTitle() {
        return this.messages.getString("Title", new String[0]);
    }
}

