/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.zipfile.ZipFileData;
import org.pentaho.di.trans.steps.zipfile.ZipFileMeta;

public class ZipFile
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ZipFileMeta.class;
    private ZipFileMeta meta;
    private ZipFileData data;

    public ZipFile(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ZipFileMeta)smi;
        this.data = (ZipFileData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.getTrans().getRepository(), this.getTrans().getMetaStore());
            if (Utils.isEmpty((CharSequence)this.meta.getDynamicSourceFileNameField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFilenameFieldMissing", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getDynamicTargetFileNameField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFilenameFieldMissing", (String[])new String[0]));
            }
            if (this.data.indexOfSourceFilename < 0) {
                this.data.indexOfSourceFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicSourceFileNameField());
                if (this.data.indexOfSourceFilename < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicSourceFileNameField()}));
                }
            }
            this.data.indexOfZipFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTargetFileNameField());
            if (this.data.indexOfZipFilename < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicTargetFileNameField()}));
            }
            if (this.meta.isKeepSouceFolder() && !Utils.isEmpty((CharSequence)this.meta.getBaseFolderField())) {
                this.data.indexOfBaseFolder = this.getInputRowMeta().indexOfValue(this.meta.getBaseFolderField());
                if (this.data.indexOfBaseFolder < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.CouldnotFindField", (String[])new String[]{this.meta.getBaseFolderField()}));
                }
            }
            if (this.meta.getOperationType() == 1) {
                if (Utils.isEmpty((CharSequence)this.meta.getMoveToFolderField())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.EmptyMovetoFolder", (String[])new String[0]));
                }
                this.data.indexOfMoveToFolder = this.getInputRowMeta().indexOfValue(this.meta.getMoveToFolderField());
                if (this.data.indexOfMoveToFolder < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Exception.CouldnotFindField", (String[])new String[]{this.meta.getMoveToFolderField()}));
                }
            }
        }
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            String sourceFilename = this.getInputRowMeta().getString(r, this.data.indexOfSourceFilename);
            if (Utils.isEmpty((CharSequence)sourceFilename)) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileEmpty", (String[])new String[0])});
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileEmpty", (String[])new String[0]));
            }
            this.data.sourceFile = KettleVFS.getFileObject((String)sourceFilename, (VariableSpace)this);
            boolean skip = false;
            if (!this.data.sourceFile.exists()) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotExist", (String[])new String[]{sourceFilename})});
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
            }
            if (this.data.sourceFile.getType() != FileType.FILE) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotFile", (String[])new String[]{sourceFilename})});
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
            }
            if (this.data.indexOfBaseFolder > -1) {
                this.data.baseFolder = this.getInputRowMeta().getString(r, this.data.indexOfBaseFolder);
            }
            String moveToFolder = null;
            if (this.data.indexOfMoveToFolder > -1 && Utils.isEmpty((CharSequence)(moveToFolder = this.getInputRowMeta().getString(r, this.data.indexOfMoveToFolder)))) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.EmptyMoveToFolder", (String[])new String[0]));
            }
            if (!skip) {
                String targetFilename = this.getInputRowMeta().getString(r, this.data.indexOfZipFilename);
                if (Utils.isEmpty((CharSequence)targetFilename)) {
                    this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFileEmpty", (String[])new String[0])});
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetFileEmpty", (String[])new String[0]));
                }
                this.data.zipFile = KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this);
                if (this.data.zipFile.exists()) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Log.TargetFileExists", (String[])new String[]{targetFilename})});
                    }
                } else {
                    FileObject parentFolder = this.data.zipFile.getParent();
                    if (!parentFolder.exists()) {
                        if (!this.meta.isCreateParentFolder()) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.Error.TargetParentFolderNotExists", (String[])new String[]{parentFolder.toString()}));
                        }
                        parentFolder.createFolder();
                    }
                    if (parentFolder != null) {
                        parentFolder.close();
                    }
                }
                this.zipFile();
                this.processFile(moveToFolder);
                this.addFilenameToResult();
            }
            this.getLinesInput();
            this.putRow(this.data.outputRowMeta, r);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ZipFile.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"ZipFile.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ZipFile001");
            }
        }
        finally {
            try {
                if (this.data.sourceFile != null) {
                    this.data.sourceFile.close();
                }
                if (this.data.zipFile != null) {
                    this.data.zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processFile(String folder) throws Exception {
        switch (this.meta.getOperationType()) {
            case 1: {
                file = null;
                moveToFolder = null;
                try {
                    moveToFolder = KettleVFS.getFileObject((String)folder, (VariableSpace)this);
                    if (moveToFolder.exists()) {
                        if (moveToFolder.getType() != FileType.FOLDER) {
                            throw new KettleException(BaseMessages.getString(ZipFile.PKG, (String)"ZipFile.Error.NotAFolder", (String[])new String[]{folder}));
                        }
                    } else {
                        moveToFolder.createFolder();
                    }
                    targetfilename = KettleVFS.getFilename((FileObject)moveToFolder) + Const.FILE_SEPARATOR + this.data.sourceFile.getName().getBaseName();
                    file = KettleVFS.getFileObject((String)targetfilename, (VariableSpace)this);
                    this.data.sourceFile.moveTo(file);
                    if (file == null) ** GOTO lbl35
                }
                catch (Throwable var5_7) {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception var6_8) {
                            // empty catch block
                        }
                    }
                    if (moveToFolder != null) {
                        try {
                            moveToFolder.close();
                        }
                        catch (Exception var6_9) {
                            // empty catch block
                        }
                    }
                    throw var5_7;
                }
                try {
                    file.close();
                }
                catch (Exception var4_5) {
                    // empty catch block
                }
lbl35:
                // 3 sources

                if (moveToFolder == null) break;
                try {
                    moveToFolder.close();
                }
                catch (Exception var4_6) {}
                break;
            }
            case 2: {
                this.data.sourceFile.delete();
                break;
            }
        }
    }

    private void addFilenameToResult() throws FileSystemException {
        if (this.meta.isaddTargetFileNametoResult()) {
            ResultFile resultFile = new ResultFile(0, this.data.zipFile, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"ZipFile.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFile.Log.FilenameAddResult", (String[])new String[]{this.data.sourceFile.toString()})});
            }
        }
    }

    private File getFile(String filename) {
        try {
            URI uri = new URI(filename);
            return new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(filename);
        }
    }

    private void zipFile() throws KettleException {
        String localrealZipfilename = KettleVFS.getFilename((FileObject)this.data.zipFile);
        boolean updateZip = false;
        byte[] buffer = null;
        OutputStream dest = null;
        FilterOutputStream buff = null;
        DeflaterOutputStream out = null;
        InputStream in = null;
        ZipInputStream zin = null;
        ZipEntry entry = null;
        File tempFile = null;
        HashSet<String> fileSet = new HashSet<String>();
        try {
            int len;
            boolean bl = updateZip = this.data.zipFile.exists() && this.meta.isOverwriteZipEntry();
            if (updateZip) {
                File fileZip = this.getFile(localrealZipfilename);
                tempFile = File.createTempFile(fileZip.getName(), null);
                tempFile.delete();
                updateZip = fileZip.renameTo(tempFile);
            }
            buffer = new byte[18024];
            dest = KettleVFS.getOutputStream((String)localrealZipfilename, (boolean)false);
            buff = new BufferedOutputStream(dest);
            out = new ZipOutputStream(buff);
            if (updateZip) {
                zin = new ZipInputStream(new FileInputStream(tempFile));
                entry = zin.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (!fileSet.contains(name)) {
                        ((ZipOutputStream)out).putNextEntry(new ZipEntry(name));
                        while ((len = zin.read(buffer)) > 0) {
                            ((ZipOutputStream)out).write(buffer, 0, len);
                        }
                        fileSet.add(name);
                    }
                    entry = zin.getNextEntry();
                }
                zin.close();
            }
            ((ZipOutputStream)out).setMethod(8);
            ((ZipOutputStream)out).setLevel(9);
            in = KettleVFS.getInputStream((FileObject)this.data.sourceFile);
            String relativeName = this.data.sourceFile.getName().getBaseName();
            if (this.meta.isKeepSouceFolder()) {
                relativeName = KettleVFS.getFilename((FileObject)this.data.sourceFile);
                if (this.data.baseFolder != null) {
                    this.data.baseFolder = this.data.baseFolder + Const.FILE_SEPARATOR;
                    relativeName = relativeName.replace(this.data.baseFolder, "");
                }
            }
            if (!fileSet.contains(relativeName)) {
                ((ZipOutputStream)out).putNextEntry(new ZipEntry(relativeName));
                while ((len = in.read(buffer)) > 0) {
                    ((ZipOutputStream)out).write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFile.ErrorCreatingZip", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((ZipOutputStream)out).closeEntry();
                    ((ZipOutputStream)out).close();
                }
                if (buff != null) {
                    buff.close();
                }
                if (dest != null) {
                    dest.close();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                fileSet = null;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ZipFileMeta)smi;
        this.data = (ZipFileData)sdi;
        if (super.init(smi, sdi)) {
            if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
                this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.getTransMeta().getEmbeddedMetastoreProviderKey());
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ZipFileMeta)smi;
        this.data = (ZipFileData)sdi;
        if (this.data.sourceFile != null) {
            try {
                this.data.sourceFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.zipFile != null) {
            try {
                this.data.zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

