/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.MailInput;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MailInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MailInputMeta.class;
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_BATCH_SIZE = 500;
    public int conditionReceivedDate;
    public int valueimaplist;
    private String servername;
    private String username;
    private String password;
    private boolean usessl;
    private String sslport;
    private String firstmails;
    public int retrievemails;
    private boolean delete;
    private String protocol;
    private String imapfirstmails;
    private String imapfolder;
    private String senderSearch;
    private boolean notTermSenderSearch;
    private String recipientSearch;
    private String subjectSearch;
    private String receivedDate1;
    private String receivedDate2;
    private boolean notTermSubjectSearch;
    private boolean notTermRecipientSearch;
    private boolean notTermReceivedDateSearch;
    private boolean includesubfolders;
    private boolean useproxy;
    private String proxyusername;
    private String folderfield;
    private boolean usedynamicfolder;
    private String rowlimit;
    private MailInputField[] inputFields;
    private boolean useBatch;
    private String start;
    private String end;
    private Integer batchSize = DEFAULT_BATCH_SIZE;
    private boolean stopOnError;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.inputFields = new MailInputField[nrfields];
    }

    @Override
    public Object clone() {
        MailInputMeta retval = (MailInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (MailInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) {
        this.servername = XMLHandler.getTagValue((Node)stepnode, (String)"servername");
        this.username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password"));
        this.usessl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usessl"));
        this.sslport = XMLHandler.getTagValue((Node)stepnode, (String)"sslport");
        this.retrievemails = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"retrievemails"), (int)-1);
        this.firstmails = XMLHandler.getTagValue((Node)stepnode, (String)"firstmails");
        this.delete = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"delete"));
        this.protocol = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"protocol"), (String)"POP3");
        this.valueimaplist = MailConnectionMeta.getValueImapListByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"valueimaplist"), (String)""));
        this.imapfirstmails = XMLHandler.getTagValue((Node)stepnode, (String)"imapfirstmails");
        this.imapfolder = XMLHandler.getTagValue((Node)stepnode, (String)"imapfolder");
        this.senderSearch = XMLHandler.getTagValue((Node)stepnode, (String)"sendersearch");
        this.notTermSenderSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"nottermsendersearch"));
        this.recipientSearch = XMLHandler.getTagValue((Node)stepnode, (String)"recipientsearch");
        this.notTermRecipientSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"notTermRecipientSearch"));
        this.subjectSearch = XMLHandler.getTagValue((Node)stepnode, (String)"subjectsearch");
        this.notTermSubjectSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"nottermsubjectsearch"));
        this.conditionReceivedDate = MailConnectionMeta.getConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"conditionreceiveddate"), (String)""));
        this.notTermReceivedDateSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"nottermreceiveddatesearch"));
        this.receivedDate1 = XMLHandler.getTagValue((Node)stepnode, (String)"receivedDate1");
        this.receivedDate2 = XMLHandler.getTagValue((Node)stepnode, (String)"receivedDate2");
        this.includesubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includesubfolders"));
        this.usedynamicfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usedynamicfolder"));
        this.folderfield = XMLHandler.getTagValue((Node)stepnode, (String)"folderfield");
        this.proxyusername = XMLHandler.getTagValue((Node)stepnode, (String)"proxyusername");
        this.useproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useproxy"));
        this.useBatch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useBatch"));
        try {
            this.batchSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"batchSize"));
        }
        catch (NumberFormatException e) {
            this.batchSize = DEFAULT_BATCH_SIZE;
        }
        this.start = XMLHandler.getTagValue((Node)stepnode, (String)"startMsg");
        this.end = XMLHandler.getTagValue((Node)stepnode, (String)"endMsg");
        this.stopOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"stopOnError"));
        this.rowlimit = XMLHandler.getTagValue((Node)stepnode, (String)"rowlimit");
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
        int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            this.inputFields[i] = new MailInputField();
            this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
            this.inputFields[i].setColumn(MailInputField.getColumnByCode(XMLHandler.getTagValue((Node)fnode, (String)"column")));
        }
    }

    @Override
    public void setDefault() {
        this.servername = null;
        this.username = null;
        this.password = null;
        this.usessl = false;
        this.sslport = null;
        this.retrievemails = 0;
        this.firstmails = null;
        this.delete = false;
        this.protocol = "POP3";
        this.imapfirstmails = "0";
        this.valueimaplist = 0;
        this.imapfolder = null;
        this.senderSearch = null;
        this.notTermSenderSearch = false;
        this.notTermRecipientSearch = false;
        this.notTermSubjectSearch = false;
        this.receivedDate1 = null;
        this.receivedDate2 = null;
        this.notTermReceivedDateSearch = false;
        this.recipientSearch = null;
        this.subjectSearch = null;
        this.includesubfolders = false;
        this.useproxy = false;
        this.proxyusername = null;
        this.folderfield = null;
        this.usedynamicfolder = false;
        this.rowlimit = "0";
        this.batchSize = DEFAULT_BATCH_SIZE;
        this.useBatch = false;
        this.start = null;
        this.end = null;
        this.stopOnError = true;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new MailInputField("field" + (i + 1));
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.servername = rep.getStepAttributeString(id_step, "servername");
            this.username = rep.getStepAttributeString(id_step, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.usessl = rep.getStepAttributeBoolean(id_step, "usessl");
            int intSSLPort = (int)rep.getStepAttributeInteger(id_step, "sslport");
            this.sslport = rep.getStepAttributeString(id_step, "sslport");
            if (intSSLPort > 0 && Utils.isEmpty((CharSequence)this.sslport)) {
                this.sslport = Integer.toString(intSSLPort);
            }
            this.retrievemails = (int)rep.getStepAttributeInteger(id_step, "retrievemails");
            this.firstmails = rep.getStepAttributeString(id_step, "firstmails");
            this.delete = rep.getStepAttributeBoolean(id_step, "delete");
            this.protocol = Const.NVL((String)rep.getStepAttributeString(id_step, "protocol"), (String)"POP3");
            this.valueimaplist = MailConnectionMeta.getValueListImapListByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "valueimaplist"), (String)""));
            this.imapfirstmails = rep.getStepAttributeString(id_step, "imapfirstmails");
            this.imapfolder = rep.getStepAttributeString(id_step, "imapfolder");
            this.senderSearch = rep.getStepAttributeString(id_step, "sendersearch");
            this.notTermSenderSearch = rep.getStepAttributeBoolean(id_step, "nottermsendersearch");
            this.recipientSearch = rep.getStepAttributeString(id_step, "recipientsearch");
            this.notTermRecipientSearch = rep.getStepAttributeBoolean(id_step, "notTermRecipientSearch");
            this.subjectSearch = rep.getStepAttributeString(id_step, "subjectsearch");
            this.notTermSubjectSearch = rep.getStepAttributeBoolean(id_step, "nottermsubjectsearch");
            this.conditionReceivedDate = MailConnectionMeta.getConditionByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "conditionreceiveddate"), (String)""));
            this.notTermReceivedDateSearch = rep.getStepAttributeBoolean(id_step, "nottermreceiveddatesearch");
            this.receivedDate1 = rep.getStepAttributeString(id_step, "receiveddate1");
            this.receivedDate2 = rep.getStepAttributeString(id_step, "receiveddate2");
            this.includesubfolders = rep.getStepAttributeBoolean(id_step, "includesubfolders");
            this.useproxy = rep.getStepAttributeBoolean(id_step, "useproxy");
            this.proxyusername = rep.getStepAttributeString(id_step, "proxyusername");
            this.usedynamicfolder = rep.getStepAttributeBoolean(id_step, "usedynamicfolder");
            this.folderfield = rep.getStepAttributeString(id_step, "folderfield");
            this.rowlimit = rep.getStepAttributeString(id_step, "rowlimit");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.useBatch = rep.getStepAttributeBoolean(id_step, "useBatch");
            try {
                this.batchSize = (int)rep.getStepAttributeInteger(id_step, "batchSize");
            }
            catch (Exception e) {
                this.batchSize = DEFAULT_BATCH_SIZE;
            }
            this.start = rep.getStepAttributeString(id_step, "startMsg");
            this.end = rep.getStepAttributeString(id_step, "endMsg");
            this.stopOnError = rep.getStepAttributeBoolean(id_step, "stopOnError");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                MailInputField field = new MailInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setColumn(MailInputField.getColumnByCode(rep.getStepAttributeString(id_step, i, "field_column")));
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException("Erreur inattendue", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "servername", this.servername);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.username);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "usessl", this.usessl);
            rep.saveStepAttribute(id_transformation, id_step, "sslport", this.sslport);
            rep.saveStepAttribute(id_transformation, id_step, "retrievemails", this.retrievemails);
            rep.saveStepAttribute(id_transformation, id_step, "firstmails", this.firstmails);
            rep.saveStepAttribute(id_transformation, id_step, "delete", this.delete);
            rep.saveStepAttribute(id_transformation, id_step, "protocol", this.protocol);
            rep.saveStepAttribute(id_transformation, id_step, "valueimaplist", MailConnectionMeta.getValueImapListCode(this.valueimaplist));
            rep.saveStepAttribute(id_transformation, id_step, "imapfirstmails", this.imapfirstmails);
            rep.saveStepAttribute(id_transformation, id_step, "imapfolder", this.imapfolder);
            rep.saveStepAttribute(id_transformation, id_step, "sendersearch", this.senderSearch);
            rep.saveStepAttribute(id_transformation, id_step, "nottermsendersearch", this.notTermSenderSearch);
            rep.saveStepAttribute(id_transformation, id_step, "recipientsearch", this.recipientSearch);
            rep.saveStepAttribute(id_transformation, id_step, "notTermRecipientSearch", this.notTermRecipientSearch);
            rep.saveStepAttribute(id_transformation, id_step, "subjectsearch", this.subjectSearch);
            rep.saveStepAttribute(id_transformation, id_step, "nottermsubjectsearch", this.notTermSubjectSearch);
            rep.saveStepAttribute(id_transformation, id_step, "conditionreceiveddate", MailConnectionMeta.getConditionDateCode(this.conditionReceivedDate));
            rep.saveStepAttribute(id_transformation, id_step, "nottermreceiveddatesearch", this.notTermReceivedDateSearch);
            rep.saveStepAttribute(id_transformation, id_step, "receiveddate1", this.receivedDate1);
            rep.saveStepAttribute(id_transformation, id_step, "receiveddate2", this.receivedDate2);
            rep.saveStepAttribute(id_transformation, id_step, "includesubfolders", this.includesubfolders);
            rep.saveStepAttribute(id_transformation, id_step, "useproxy", this.useproxy);
            rep.saveStepAttribute(id_transformation, id_step, "proxyusername", this.proxyusername);
            rep.saveStepAttribute(id_transformation, id_step, "usedynamicfolder", this.usedynamicfolder);
            rep.saveStepAttribute(id_transformation, id_step, "folderfield", this.folderfield);
            rep.saveStepAttribute(id_transformation, id_step, "rowlimit", this.rowlimit);
            rep.saveStepAttribute(id_transformation, id_step, "useBatch", this.useBatch);
            rep.saveStepAttribute(id_transformation, id_step, "batchSize", this.batchSize.intValue());
            rep.saveStepAttribute(id_transformation, id_step, "startMsg", this.start);
            rep.saveStepAttribute(id_transformation, id_step, "endMsg", this.end);
            rep.saveStepAttribute(id_transformation, id_step, "stopOnError", this.stopOnError);
            for (int i = 0; i < this.inputFields.length; ++i) {
                MailInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_column", field.getColumnCode());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save step of type 'get pop' to the repository for id_step=" + id_step, (Throwable)dbe);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        String tab = "      ";
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.servername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usessl", (boolean)this.usessl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sslport", (String)this.sslport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"retrievemails", (int)this.retrievemails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"firstmails", (String)this.firstmails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"delete", (boolean)this.delete));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("      ").append(XMLHandler.addTagValue((String)"valueimaplist", (String)MailConnectionMeta.getValueImapListCode(this.valueimaplist)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"imapfirstmails", (String)this.imapfirstmails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"imapfolder", (String)this.imapfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sendersearch", (String)this.senderSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermsendersearch", (boolean)this.notTermSenderSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"recipientsearch", (String)this.recipientSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"notTermRecipientSearch", (boolean)this.notTermRecipientSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"subjectsearch", (String)this.subjectSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermsubjectsearch", (boolean)this.notTermSubjectSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"conditionreceiveddate", (String)MailConnectionMeta.getConditionDateCode(this.conditionReceivedDate)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermreceiveddatesearch", (boolean)this.notTermReceivedDateSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"receiveddate1", (String)this.receivedDate1));
        retval.append("      ").append(XMLHandler.addTagValue((String)"receiveddate2", (String)this.receivedDate2));
        retval.append("      ").append(XMLHandler.addTagValue((String)"includesubfolders", (boolean)this.includesubfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyusername", (String)this.proxyusername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usedynamicfolder", (boolean)this.usedynamicfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"folderfield", (String)this.folderfield));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rowlimit", (String)this.rowlimit));
        retval.append(tab).append(XMLHandler.addTagValue((String)"useBatch", (boolean)this.useBatch));
        retval.append(tab).append(XMLHandler.addTagValue((String)"batchSize", (int)this.batchSize));
        retval.append(tab).append(XMLHandler.addTagValue((String)"startMsg", (String)this.start));
        retval.append(tab).append(XMLHandler.addTagValue((String)"endMsg", (String)this.end));
        retval.append(tab).append(XMLHandler.addTagValue((String)"stopOnError", (boolean)this.stopOnError));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"column", (String)this.inputFields[i].getColumnCode()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getPort() {
        return this.sslport;
    }

    public void setPort(String sslport) {
        this.sslport = sslport;
    }

    public void setFirstMails(String firstmails) {
        this.firstmails = firstmails;
    }

    public String getFirstMails() {
        return this.firstmails;
    }

    public boolean isIncludeSubFolders() {
        return this.includesubfolders;
    }

    public void setIncludeSubFolders(boolean includesubfolders) {
        this.includesubfolders = includesubfolders;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useprox) {
        this.useproxy = useprox;
    }

    public void setProxyUsername(String username) {
        this.proxyusername = username;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public boolean isDynamicFolder() {
        return this.usedynamicfolder;
    }

    public void setDynamicFolder(boolean usedynamicfolder) {
        this.usedynamicfolder = usedynamicfolder;
    }

    public void setRowLimit(String rowlimit) {
        this.rowlimit = rowlimit;
    }

    public String getRowLimit() {
        return this.rowlimit;
    }

    public void setFolderField(String folderfield) {
        this.folderfield = folderfield;
    }

    public String getFolderField() {
        return this.folderfield;
    }

    public void setFirstIMAPMails(String firstmails) {
        this.imapfirstmails = firstmails;
    }

    public String getFirstIMAPMails() {
        return this.imapfirstmails;
    }

    public void setSenderSearchTerm(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    public String getSenderSearchTerm() {
        return this.senderSearch;
    }

    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    public void setNotTermRecipientSearch(boolean notTermRecipientSearch) {
        this.notTermRecipientSearch = notTermRecipientSearch;
    }

    public boolean isNotTermRecipientSearch() {
        return this.notTermRecipientSearch;
    }

    public void setRecipientSearch(String recipientSearch) {
        this.recipientSearch = recipientSearch;
    }

    public String getRecipientSearch() {
        return this.recipientSearch;
    }

    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    public void setReceivedDate1(String inputDate) {
        this.receivedDate1 = inputDate;
    }

    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    public void setReceivedDate2(String inputDate) {
        this.receivedDate2 = inputDate;
    }

    public void setConditionOnReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    public int getConditionOnReceivedDate() {
        return this.conditionReceivedDate;
    }

    public void setServerName(String servername) {
        this.servername = servername;
    }

    public String getServerName() {
        return this.servername;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setRetrievemails(int nr) {
        this.retrievemails = nr;
    }

    public int getRetrievemails() {
        return this.retrievemails;
    }

    public int getValueImapList() {
        return this.valueimaplist;
    }

    public void setValueImapList(int value) {
        this.valueimaplist = value;
    }

    public MailInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(MailInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIMAPFolder() {
        return this.imapfolder;
    }

    public void setIMAPFolder(String folder) {
        this.imapfolder = folder;
    }

    public void setUseSSL(boolean usessl) {
        this.usessl = usessl;
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MailInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MailInputData();
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            MailInputField field = this.inputFields[i];
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(field.getName()));
            switch (field.getColumn()) {
                case 0: 
                case 11: 
                case 17: {
                    v = new ValueMetaInteger(space.environmentSubstitute(field.getName()));
                    v.setLength(10, 0);
                    break;
                }
                case 7: 
                case 8: {
                    v = new ValueMetaDate(space.environmentSubstitute(field.getName()));
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    v = new ValueMetaBoolean(space.environmentSubstitute(field.getName()));
                    break;
                }
                default: {
                    v.setLength(250);
                    v.setPrecision(-1);
                }
            }
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    public boolean useBatch() {
        return this.useBatch;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean breakOnError) {
        this.stopOnError = breakOnError;
    }

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    private static final class Tags {
        static final String USE_BATCH = "useBatch";
        static final String BATCH_SIZE = "batchSize";
        static final String START_MSG = "startMsg";
        static final String END_MSG = "endMsg";
        static final String STOP_ON_ERROR = "stopOnError";

        private Tags() {
        }
    }
}

