/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapSslProtocol;
import org.pentaho.di.trans.steps.ldapinput.store.CustomSocketFactory;

public class LdapTlsProtocol
extends LdapSslProtocol {
    private StartTlsResponse startTlsResponse;

    public LdapTlsProtocol(LogChannelInterface log, VariableSpace variableSpace, LdapMeta meta, Collection<String> binaryAttributes) {
        super(log, variableSpace, meta, binaryAttributes);
    }

    @Override
    protected String getConnectionPrefix() {
        return "ldap://";
    }

    public static String getName() {
        return "LDAP TLS";
    }

    @Override
    protected void doConnect(String username, String password) throws KettleException {
        super.doConnect(username, password);
        StartTlsRequest tlsRequest = new StartTlsRequest();
        try {
            this.startTlsResponse = (StartTlsResponse)this.getCtx().extendedOperation(tlsRequest);
            this.startTlsResponse.negotiate(CustomSocketFactory.getDefault());
        }
        catch (NamingException e) {
            throw new KettleException((Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    protected void configureSslEnvironment(Map<String, String> env) {
    }

    @Override
    public void close() throws KettleException {
        if (this.startTlsResponse != null) {
            try {
                this.startTlsResponse.close();
            }
            catch (IOException e) {
                throw new KettleException((Throwable)e);
            }
            finally {
                this.startTlsResponse = null;
            }
        }
        super.close();
    }
}

