/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesModelerMeta;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.injection.InjectionTypeConverter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookup;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="DimensionLookup.Injection.", groups={"KEYS", "FIELDS"})
public class DimensionLookupMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesModelerMeta {
    private static Class<?> PKG = DimensionLookupMeta.class;
    public static final int TYPE_UPDATE_DIM_INSERT = 0;
    public static final int TYPE_UPDATE_DIM_UPDATE = 1;
    public static final int TYPE_UPDATE_DIM_PUNCHTHROUGH = 2;
    public static final int TYPE_UPDATE_DATE_INSUP = 3;
    public static final int TYPE_UPDATE_DATE_INSERTED = 4;
    public static final int TYPE_UPDATE_DATE_UPDATED = 5;
    public static final int TYPE_UPDATE_LAST_VERSION = 6;
    public static final String[] typeDesc = new String[]{BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Insert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Update", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.PunchThrough", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInsertedOrUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInserted", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.LastVersion", (String[])new String[0])};
    public static final String[] typeCodes = new String[]{"Insert", "Update", "Punch through", "DateInsertedOrUpdated", "DateInserted", "DateUpdated", "LastVersion"};
    public static final String[] typeDescLookup = ValueMetaFactory.getValueMetaNames();
    public static final int START_DATE_ALTERNATIVE_NONE = 0;
    public static final int START_DATE_ALTERNATIVE_SYSDATE = 1;
    public static final int START_DATE_ALTERNATIVE_START_OF_TRANS = 2;
    public static final int START_DATE_ALTERNATIVE_NULL = 3;
    public static final int START_DATE_ALTERNATIVE_COLUMN_VALUE = 4;
    private static final String[] startDateAlternativeCodes = new String[]{"none", "sysdate", "trans_start", "null", "column_value"};
    private static final String[] startDateAlternativeDescs = new String[]{BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.None.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Sysdate.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.TransStart.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Null.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.ColumnValue.Label", (String[])new String[0])};
    @Injection(name="TARGET_SCHEMA")
    private String schemaName;
    @Injection(name="TARGET_TABLE")
    private String tableName;
    private List<? extends SharedObjectInterface> databases;
    private DatabaseMeta databaseMeta;
    @Injection(name="UPDATE_DIMENSION")
    private boolean update;
    @Injection(name="KEY_STREAM_FIELDNAME", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_DATABASE_FIELDNAME", group="KEYS")
    private String[] keyLookup;
    @Injection(name="STREAM_DATE_FIELD")
    private String dateField;
    @Injection(name="DATE_RANGE_START_FIELD")
    private String dateFrom;
    @Injection(name="DATE_RANGE_END_FIELD")
    private String dateTo;
    @Injection(name="STREAM_FIELDNAME", group="FIELDS")
    private String[] fieldStream;
    @Injection(name="DATABASE_FIELDNAME", group="FIELDS")
    private String[] fieldLookup;
    @Injection(name="UPDATE_TYPE", group="FIELDS", converter=UpdateTypeCodeConverter.class)
    private int[] fieldUpdate;
    @Injection(name="TYPE_OF_RETURN_FIELD", group="FIELDS", converter=ReturnTypeCodeConverter.class)
    private int[] returnType = new int[0];
    @Injection(name="TECHNICAL_KEY_FIELD")
    private String keyField;
    @Injection(name="TECHNICAL_KEY_NEW_NAME")
    private String keyRename;
    private boolean autoIncrement;
    @Injection(name="VERSION_FIELD")
    private String versionField;
    @Injection(name="TECHNICAL_KEY_SEQUENCE")
    private String sequenceName;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    private boolean useBatchUpdate;
    @Injection(name="MIN_YEAR")
    private int minYear;
    @Injection(name="MAX_YEAR")
    private int maxYear;
    @Injection(name="TECHNICAL_KEY_CREATION")
    private String techKeyCreation = null;
    public static String CREATION_METHOD_AUTOINC = "autoinc";
    public static String CREATION_METHOD_SEQUENCE = "sequence";
    public static String CREATION_METHOD_TABLEMAX = "tablemax";
    @Injection(name="CACHE_SIZE")
    private int cacheSize;
    @Injection(name="USE_ALTERNATIVE_START_DATE")
    private boolean usingStartDateAlternative;
    @Injection(name="ALTERNATIVE_START_OPTION", converter=StartDateCodeConverter.class)
    private int startDateAlternative;
    @Injection(name="ALTERNATIVE_START_COLUMN")
    private String startDateFieldName;
    @Injection(name="PRELOAD_CACHE")
    private boolean preloadingCache;

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tablename) {
        this.tableName = tablename;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Injection(name="CONNECTION_NAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setTechKeyCreation(String techKeyCreation) {
        this.techKeyCreation = techKeyCreation;
    }

    public String getTechKeyCreation() {
        return this.techKeyCreation;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDateField() {
        return this.dateField;
    }

    public void setDateField(String dateField) {
        this.dateField = dateField;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String[] getFieldLookup() {
        return this.fieldLookup;
    }

    public void setFieldLookup(String[] fieldLookup) {
        this.fieldLookup = fieldLookup;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public int[] getFieldUpdate() {
        return this.fieldUpdate;
    }

    public void setFieldUpdate(int[] fieldUpdate) {
        this.fieldUpdate = fieldUpdate;
    }

    public int[] getReturnType() {
        return this.returnType;
    }

    public void setReturnType(int[] returnType) {
        this.returnType = returnType;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String getKeyRename() {
        return this.keyRename;
    }

    public void setKeyRename(String keyRename) {
        this.keyRename = keyRename;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public void setVersionField(String versionField) {
        this.versionField = versionField;
    }

    public void actualizeWithInjectedValues() {
        if (!this.update && this.returnType.length > 0) {
            this.fieldUpdate = this.returnType;
        }
        this.normalizeAllocationFields();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrfields) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.fieldStream = new String[nrfields];
        this.fieldLookup = new String[nrfields];
        this.fieldUpdate = new int[nrfields];
        this.returnType = new int[nrfields];
    }

    @Override
    public Object clone() {
        DimensionLookupMeta retval = (DimensionLookupMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrfields = this.fieldStream.length;
        retval.allocate(nrkeys, nrfields);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrfields);
        System.arraycopy(this.fieldLookup, 0, retval.fieldLookup, 0, nrfields);
        System.arraycopy(this.fieldUpdate, 0, retval.fieldUpdate, 0, nrfields);
        System.arraycopy(this.returnType, 0, retval.returnType, 0, nrfields);
        return retval;
    }

    public static final int getUpdateType(boolean upd, String ty) {
        if (upd) {
            int i;
            for (i = 0; i < typeCodes.length; ++i) {
                if (!typeCodes[i].equalsIgnoreCase(ty)) continue;
                return i;
            }
            for (i = 0; i < typeDesc.length; ++i) {
                if (!typeDesc[i].equalsIgnoreCase(ty)) continue;
                return i;
            }
            if ("Y".equalsIgnoreCase(ty)) {
                return 2;
            }
            return 0;
        }
        int retval = ValueMetaFactory.getIdForValueMeta((String)ty);
        if (retval == 0) {
            retval = 2;
        }
        return retval;
    }

    public static final String getUpdateType(boolean upd, int t) {
        if (!upd) {
            return ValueMetaFactory.getValueMetaName((int)t);
        }
        return typeDesc[t];
    }

    public static final String getUpdateTypeCode(boolean upd, int t) {
        if (!upd) {
            return ValueMetaFactory.getValueMetaName((int)t);
        }
        return typeCodes[t];
    }

    public static final int getStartDateAlternative(String string) {
        int i;
        for (i = 0; i < startDateAlternativeCodes.length; ++i) {
            if (!startDateAlternativeCodes[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        for (i = 0; i < startDateAlternativeDescs.length; ++i) {
            if (!startDateAlternativeDescs[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return 0;
    }

    public static final String getStartDateAlternativeCode(int alternative) {
        return startDateAlternativeCodes[alternative];
    }

    public static final String getStartDateAlternativeDesc(int alternative) {
        return startDateAlternativeDescs[alternative];
    }

    public static final String[] getStartDateAlternativeCodes() {
        return startDateAlternativeCodes;
    }

    public static final String[] getStartDateAlternativeDescriptions() {
        return startDateAlternativeDescs;
    }

    public static final boolean isUpdateTypeWithoutArgument(boolean update, int type) {
        if (!update) {
            return false;
        }
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDefault() {
        int i;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.DefualtTableName", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.update = true;
        int nrkeys = 0;
        int nrfields = 0;
        this.allocate(nrkeys, nrfields);
        for (i = 0; i < nrkeys; ++i) {
            this.keyStream[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        for (i = 0; i < nrfields; ++i) {
            this.fieldStream[i] = "field" + i;
            this.fieldLookup[i] = "lookup" + i;
            this.fieldUpdate[i] = 0;
        }
        this.dateField = "";
        this.dateFrom = "date_from";
        this.dateTo = "date_to";
        this.minYear = 1900;
        this.maxYear = 2199;
        this.keyField = "";
        this.keyRename = "";
        this.autoIncrement = false;
        this.versionField = "version";
        this.cacheSize = 5000;
        this.preloadingCache = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        block14: {
            for (ValueMetaInterface valueMeta : row.getValueMetaList()) {
                valueMeta.setStorageType(0);
                valueMeta.setTrimType(0);
            }
            if (Utils.isEmpty((CharSequence)this.keyField)) {
                String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Error.NoTechnicalKeySpecified", (String[])new String[0]);
                this.logError(message);
                throw new KettleStepException(message);
            }
            ValueMetaInteger v = new ValueMetaInteger(this.keyField);
            if (this.keyRename != null && this.keyRename.length() > 0) {
                v.setName(this.keyRename);
            }
            v.setLength(9);
            v.setPrecision(0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
            if (!this.update && this.fieldLookup.length > 0) {
                Database db = null;
                try {
                    if (this.databaseMeta != null) {
                        db = this.createDatabaseObject();
                        RowMetaInterface extraFields = this.getDatabaseTableFields(db, this.schemaName, this.tableName);
                        for (int i = 0; i < this.fieldLookup.length; ++i) {
                            v = extraFields.searchValueMeta(this.fieldLookup[i]);
                            if (v == null) {
                                String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToFindReturnField", (String[])new String[]{this.fieldLookup[i]});
                                this.logError(message);
                                throw new KettleStepException(message);
                            }
                            if (this.fieldStream[i] != null && this.fieldStream[i].length() > 0) {
                                v.setName(this.fieldStream[i]);
                            }
                            v.setOrigin(name);
                            row.addValueMeta((ValueMetaInterface)v);
                        }
                        break block14;
                    }
                    String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField", (String[])new String[0]);
                    this.logError(message);
                    throw new KettleStepException(message);
                }
                catch (Exception e) {
                    String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField2", (String[])new String[0]);
                    this.logError(message);
                    throw new KettleStepException(message, (Throwable)e);
                }
                finally {
                    if (db != null) {
                        db.disconnect();
                    }
                }
            }
        }
    }

    @Override
    public String getXML() {
        int i;
        this.actualizeWithInjectedValues();
        StringBuilder retval = new StringBuilder(512);
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"update", (boolean)this.update));
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("        <key>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"lookup", (String)this.keyLookup[i]));
            retval.append("        </key>").append(Const.CR);
        }
        retval.append("        <date>").append(Const.CR);
        retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.dateField));
        retval.append("          ").append(XMLHandler.addTagValue((String)"from", (String)this.dateFrom));
        retval.append("          ").append(XMLHandler.addTagValue((String)"to", (String)this.dateTo));
        retval.append("        </date>").append(Const.CR);
        if (this.fieldStream != null) {
            for (i = 0; i < this.fieldStream.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)Const.NVL((String)this.fieldStream[i], (String)"")));
                retval.append("          ").append(XMLHandler.addTagValue((String)"lookup", (String)Const.NVL((String)this.fieldLookup[i], (String)"")));
                retval.append("          ").append(XMLHandler.addTagValue((String)"update", (String)DimensionLookupMeta.getUpdateTypeCode(this.update, this.fieldUpdate[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("        <return>").append(Const.CR);
        retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.keyField));
        retval.append("          ").append(XMLHandler.addTagValue((String)"rename", (String)this.keyRename));
        retval.append("          ").append(XMLHandler.addTagValue((String)"creation_method", (String)this.techKeyCreation));
        retval.append("          ").append(XMLHandler.addTagValue((String)"use_autoinc", (boolean)this.autoIncrement));
        retval.append("          ").append(XMLHandler.addTagValue((String)"version", (String)this.versionField));
        retval.append("        </return>").append(Const.CR);
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"sequence", (String)this.sequenceName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"min_year", (int)this.minYear));
        retval.append("      ").append(XMLHandler.addTagValue((String)"max_year", (int)this.maxYear));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"preload_cache", (boolean)this.preloadingCache));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_start_date_alternative", (boolean)this.usingStartDateAlternative));
        retval.append("      ").append(XMLHandler.addTagValue((String)"start_date_alternative", (String)DimensionLookupMeta.getStartDateAlternativeCode(this.startDateAlternative)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"start_date_field_name", (String)this.startDateFieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useBatch", (boolean)this.useBatchUpdate));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databases = databases;
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String commit = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)commit, (int)0);
            String upd = XMLHandler.getTagValue((Node)stepnode, (String)"update");
            this.update = upd.equalsIgnoreCase("Y");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)fields, (String)"key");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrkeys, nrfields);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"lookup");
            }
            Node dnode = XMLHandler.getSubNode((Node)fields, (String)"date");
            this.dateField = XMLHandler.getTagValue((Node)dnode, (String)"name");
            this.dateFrom = XMLHandler.getTagValue((Node)dnode, (String)"from");
            this.dateTo = XMLHandler.getTagValue((Node)dnode, (String)"to");
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldStream[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldLookup[i] = XMLHandler.getTagValue((Node)fnode, (String)"lookup");
                upd = XMLHandler.getTagValue((Node)fnode, (String)"update");
                this.fieldUpdate[i] = DimensionLookupMeta.getUpdateType(this.update, upd);
            }
            if (this.update) {
                this.sequenceName = XMLHandler.getTagValue((Node)stepnode, (String)"sequence");
            }
            this.maxYear = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"max_year"), (int)2199);
            this.minYear = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"min_year"), (int)1900);
            this.keyField = XMLHandler.getTagValue((Node)fields, (String)"return", (String)"name");
            this.keyRename = XMLHandler.getTagValue((Node)fields, (String)"return", (String)"rename");
            this.autoIncrement = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fields, (String)"return", (String)"use_autoinc"));
            this.versionField = XMLHandler.getTagValue((Node)fields, (String)"return", (String)"version");
            this.setTechKeyCreation(XMLHandler.getTagValue((Node)fields, (String)"return", (String)"creation_method"));
            this.cacheSize = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"cache_size"), (int)-1);
            this.preloadingCache = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"preload_cache"));
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useBatch"));
            this.usingStartDateAlternative = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_start_date_alternative"));
            this.startDateAlternative = DimensionLookupMeta.getStartDateAlternative(XMLHandler.getTagValue((Node)stepnode, (String)"start_date_alternative"));
            this.startDateFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"start_date_field_name");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databases = databases;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.update = rep.getStepAttributeBoolean(id_step, "update");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_update");
            this.allocate(nrkeys, nrfields);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            this.dateField = rep.getStepAttributeString(id_step, "date_name");
            this.dateFrom = rep.getStepAttributeString(id_step, "date_from");
            this.dateTo = rep.getStepAttributeString(id_step, "date_to");
            for (i = 0; i < nrfields; ++i) {
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldLookup[i] = rep.getStepAttributeString(id_step, i, "field_lookup");
                this.fieldUpdate[i] = DimensionLookupMeta.getUpdateType(this.update, rep.getStepAttributeString(id_step, i, "field_update"));
                if (this.update) continue;
                this.returnType[i] = this.fieldUpdate[i];
            }
            this.keyField = rep.getStepAttributeString(id_step, "return_name");
            this.keyRename = rep.getStepAttributeString(id_step, "return_rename");
            this.autoIncrement = rep.getStepAttributeBoolean(id_step, "use_autoinc");
            this.versionField = rep.getStepAttributeString(id_step, "version_field");
            this.techKeyCreation = rep.getStepAttributeString(id_step, "creation_method");
            if (this.update) {
                this.sequenceName = rep.getStepAttributeString(id_step, "sequence");
            }
            this.minYear = (int)rep.getStepAttributeInteger(id_step, "min_year");
            this.maxYear = (int)rep.getStepAttributeInteger(id_step, "max_year");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.preloadingCache = rep.getStepAttributeBoolean(id_step, "preload_cache");
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "useBatch");
            this.usingStartDateAlternative = rep.getStepAttributeBoolean(id_step, "use_start_date_alternative");
            this.startDateAlternative = DimensionLookupMeta.getStartDateAlternative(rep.getStepAttributeString(id_step, "start_date_alternative"));
            this.startDateFieldName = rep.getStepAttributeString(id_step, "start_date_field_name");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            this.actualizeWithInjectedValues();
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "update", this.update);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_field", this.keyLookup[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "date_name", this.dateField);
            rep.saveStepAttribute(id_transformation, id_step, "date_from", this.dateFrom);
            rep.saveStepAttribute(id_transformation, id_step, "date_to", this.dateTo);
            if (this.fieldStream != null) {
                for (i = 0; i < this.fieldStream.length; ++i) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_lookup", this.fieldLookup[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_update", DimensionLookupMeta.getUpdateTypeCode(this.update, this.fieldUpdate[i]));
                }
            }
            rep.saveStepAttribute(id_transformation, id_step, "return_name", this.keyField);
            rep.saveStepAttribute(id_transformation, id_step, "return_rename", this.keyRename);
            rep.saveStepAttribute(id_transformation, id_step, "creation_method", this.techKeyCreation);
            rep.saveStepAttribute(id_transformation, id_step, "use_autoinc", this.autoIncrement);
            rep.saveStepAttribute(id_transformation, id_step, "version_field", this.versionField);
            rep.saveStepAttribute(id_transformation, id_step, "sequence", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "min_year", this.minYear);
            rep.saveStepAttribute(id_transformation, id_step, "max_year", this.maxYear);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "preload_cache", this.preloadingCache);
            rep.saveStepAttribute(id_transformation, id_step, "useBatch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "use_start_date_alternative", this.usingStartDateAlternative);
            rep.saveStepAttribute(id_transformation, id_step, "start_date_alternative", DimensionLookupMeta.getStartDateAlternativeCode(this.startDateAlternative));
            rep.saveStepAttribute(id_transformation, id_step, "start_date_field_name", this.startDateFieldName);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToLoadDimensionLookupInfoFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public Date getMinDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.minYear);
        mincal.set(2, 0);
        mincal.set(5, 1);
        mincal.set(11, 0);
        mincal.set(12, 0);
        mincal.set(13, 0);
        mincal.set(14, 0);
        return mincal.getTime();
    }

    public Date getMaxDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.maxYear);
        mincal.set(2, 11);
        mincal.set(5, 31);
        mincal.set(11, 23);
        mincal.set(12, 59);
        mincal.set(13, 59);
        mincal.set(14, 999);
        return mincal.getTime();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.update) {
            this.checkUpdate(remarks, stepMeta, prev);
        } else {
            this.checkLookup(remarks, stepMeta, prev);
        }
        if (!(this.techKeyCreation == null || CREATION_METHOD_AUTOINC.equals(this.techKeyCreation) || CREATION_METHOD_SEQUENCE.equals(this.techKeyCreation) || CREATION_METHOD_TABLEMAX.equals(this.techKeyCreation))) {
            String error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": " + this.techKeyCreation + "!";
            CheckResult cr2 = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr2);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StepReceiveInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.NoInputReceiveFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    private void checkUpdate(List<CheckResultInterface> remarks, StepMeta stepinfo, RowMetaInterface prev) {
        block30: {
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = this.createDatabaseObject();
                try {
                    CheckResult cr;
                    boolean error_found;
                    boolean first;
                    db.connect();
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        first = true;
                        error_found = false;
                        error_message = "";
                        RowMetaInterface r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                        if (r != null) {
                            for (int i = 0; i < this.fieldLookup.length; ++i) {
                                String lufield = this.fieldLookup[i];
                                this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.CheckLookupField", (String[])new String[0]) + i + " --> " + lufield + " in lookup table...");
                                ValueMetaInterface v = r.searchValueMeta(lufield);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + lufield + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllLookupFieldFound", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                            if (this.keyField != null && this.keyField.length() > 0) {
                                if (r.indexOfValue(this.keyField) < 0) {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.keyField}) + Const.CR;
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                                } else {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.keyField}) + Const.CR;
                                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                                }
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((CheckResultInterface)new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo));
                            }
                            if (this.versionField != null && this.versionField.length() > 0) {
                                if (r.indexOfValue(this.versionField) < 0) {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldNotFound", (String[])new String[]{this.versionField}) + Const.CR;
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                                } else {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldFound", (String[])new String[]{this.versionField}) + Const.CR;
                                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                                }
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((CheckResultInterface)new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo));
                            }
                            if (this.dateFrom != null && this.dateFrom.length() > 0) {
                                if (r.indexOfValue(this.dateFrom) < 0) {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeNotFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                                } else {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                                }
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((CheckResultInterface)new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo));
                            }
                            if (this.dateTo != null && this.dateTo.length() > 0) {
                                if (r.indexOfValue(this.dateTo) < 0) {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeNotFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                                } else {
                                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                                }
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((CheckResultInterface)new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo));
                            }
                        } else {
                            error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    if (prev != null && prev.size() > 0) {
                        first = true;
                        error_message = "";
                        error_found = false;
                        for (int i = 0; i < this.fieldStream.length; ++i) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.CheckField", (String[])new String[]{i + " --> " + this.fieldStream[i]}));
                            ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissongFields", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (!this.databaseMeta.supportsSequences() || !CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) || this.sequenceName == null || this.sequenceName.length() == 0) break block30;
                    if (db.checkSequenceExists(this.sequenceName)) {
                        error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceExists", (String[])new String[]{this.sequenceName});
                        cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                        remarks.add((CheckResultInterface)cr);
                        break block30;
                    }
                    error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceCouldNotFound", (String[])new String[]{this.sequenceName});
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
                catch (KettleException e) {
                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotConectToDB", (String[])new String[0]) + e.getMessage();
                    CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.InvalidConnectionName", (String[])new String[0]);
                CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    private void checkLookup(List<CheckResultInterface> remarks, StepMeta stepinfo, RowMetaInterface prev) {
        block23: {
            boolean error_found = false;
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = this.createDatabaseObject();
                try {
                    db.connect();
                    if (Utils.isEmpty((CharSequence)this.tableName)) break block23;
                    RowMetaInterface tableFields = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (tableFields != null) {
                        if (prev != null && prev.size() > 0) {
                            int i;
                            boolean first = true;
                            boolean warning_found = false;
                            for (i = 0; i < this.keyStream.length; ++i) {
                                String strfield = this.keyStream[i];
                                ValueMetaInterface strvalue = prev.searchValueMeta(strfield);
                                if (strvalue == null) {
                                    if (first) {
                                        first = false;
                                        error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem", (String[])new String[0]) + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + this.keyField + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInStream", (String[])new String[0]) + Const.CR;
                                    continue;
                                }
                                String dimfield = this.keyLookup[i];
                                ValueMetaInterface dimvalue = tableFields.searchValueMeta(dimfield);
                                if (dimvalue == null) {
                                    if (first) {
                                        first = false;
                                        error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem2", (String[])new String[0]) + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + dimfield + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInDimensiontable", (String[])new String[0]) + this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName) + ")" + Const.CR;
                                    continue;
                                }
                                if (strvalue.getType() == dimvalue.getType()) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem3", (String[])new String[0]) + Const.CR;
                                }
                                warning_found = true;
                                error_message = error_message + "\t\t" + strfield + " (" + strvalue.getOrigin() + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotTheSameTypeAs", (String[])new String[0]) + dimfield + " (" + this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName) + ")" + Const.CR;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.WarningInfoInDBConversion", (String[])new String[0]);
                            }
                            CheckResult cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : (warning_found ? new CheckResult(3, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllKeysFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepinfo));
                            remarks.add((CheckResultInterface)cr);
                            error_found = false;
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                ValueMetaInterface v;
                                String lufield = this.fieldLookup[i];
                                if (lufield == null || lufield.length() <= 0 || (v = tableFields.searchValueMeta(lufield)) != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.FieldsToRetrieveNotExistInDimension", (String[])new String[0]) + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + lufield + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllFieldsToRetrieveFound", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                            if (tableFields.indexOfValue(this.keyField) < 0) {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.keyField}) + Const.CR;
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.keyField}) + Const.CR;
                                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                            }
                            remarks.add((CheckResultInterface)cr);
                            if (tableFields.indexOfValue(this.versionField) < 0) {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldNotFound", (String[])new String[]{this.versionField}) + Const.CR;
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldFound", (String[])new String[]{this.versionField}) + Const.CR;
                                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                            }
                            remarks.add((CheckResultInterface)cr);
                            if (tableFields.indexOfValue(this.dateFrom) < 0) {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartOfDaterangeFieldNotFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartOfDaterangeFieldFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                            }
                            remarks.add((CheckResultInterface)cr);
                            if (tableFields.indexOfValue(this.dateTo) < 0) {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndOfDaterangeFieldNotFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndOfDaterangeFieldFound", (String[])new String[]{this.dateTo});
                                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
                            }
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
                            CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                            remarks.add((CheckResultInterface)cr);
                        }
                        break block23;
                    }
                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                    CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
                catch (KettleException e) {
                    error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotConnectDB", (String[])new String[0]) + e.getMessage();
                    CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                error_message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowMetaInterface getTableFields() {
        RowMetaInterface fields = null;
        if (this.databaseMeta != null) {
            Database db = this.createDatabaseObject();
            try {
                db.connect();
                fields = db.getTableFieldsMeta(this.schemaName, this.tableName);
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.update) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.Update", (String[])new String[0]));
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                    if (!Utils.isEmpty((CharSequence)schemaTable)) {
                        Database db = this.createDatabaseObject();
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            ValueMetaInterface field;
                            ValueMetaInterface vprev;
                            int i;
                            db.connect();
                            String sql = "";
                            RowMeta fields = new RowMeta();
                            ValueMetaInteger vkeyfield = new ValueMetaInteger(this.keyField);
                            vkeyfield.setLength(10);
                            fields.addValueMeta((ValueMetaInterface)vkeyfield);
                            ValueMetaInteger vversion = new ValueMetaInteger(this.versionField);
                            vversion.setLength(5);
                            fields.addValueMeta((ValueMetaInterface)vversion);
                            ValueMetaDate vdatefrom = new ValueMetaDate(this.dateFrom);
                            fields.addValueMeta((ValueMetaInterface)vdatefrom);
                            ValueMetaDate vdateto = new ValueMetaDate(this.dateTo);
                            fields.addValueMeta((ValueMetaInterface)vdateto);
                            String errors = "";
                            for (i = 0; i < this.keyLookup.length; ++i) {
                                vprev = prev.searchValueMeta(this.keyStream[i]);
                                if (vprev != null) {
                                    field = vprev.clone();
                                    field.setName(this.keyLookup[i]);
                                    fields.addValueMeta(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.keyStream[i];
                            }
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                vprev = prev.searchValueMeta(this.fieldStream[i]);
                                if (vprev != null) {
                                    field = vprev.clone();
                                    field.setName(this.fieldLookup[i]);
                                    fields.addValueMeta(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.fieldStream[i];
                            }
                            for (i = 0; i < this.fieldUpdate.length; ++i) {
                                ValueMetaDate valueMeta = null;
                                switch (this.fieldUpdate[i]) {
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        valueMeta = new ValueMetaDate(this.fieldLookup[i]);
                                        break;
                                    }
                                    case 6: {
                                        valueMeta = new ValueMetaBoolean(this.fieldLookup[i]);
                                        break;
                                    }
                                }
                                if (valueMeta == null) continue;
                                fields.addValueMeta(valueMeta);
                            }
                            if (errors.length() > 0) {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.UnableToFindFields", (String[])new String[0]) + errors);
                            }
                            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.GetDDLForTable", (String[])new String[0]) + schemaTable + "] : " + fields.toStringMeta());
                            sql = sql + db.getDDL(schemaTable, (RowMetaInterface)fields, (String)(this.sequenceName != null && this.sequenceName.length() != 0 ? null : this.keyField), this.autoIncrement, null, true);
                            this.logDebug("sql =" + sql);
                            CharSequence[] idx_fields = null;
                            if (!Utils.isEmpty((CharSequence[])this.keyLookup)) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i2 = 0; i2 < this.keyLookup.length; ++i2) {
                                    idx_fields[i2] = this.keyLookup[i2];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoKeyFieldsSpecified", (String[])new String[0]));
                            }
                            if (!Utils.isEmpty((CharSequence[])idx_fields) && !db.checkIndexExists(schemaTable, (String[])idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                sql = sql + db.getCreateIndexStatement(schemaTable, indexname, (String[])idx_fields, false, false, false, true);
                            }
                            idx_fields = new String[]{this.keyField};
                            if (!Utils.isEmpty((CharSequence)this.keyField)) {
                                if (!db.checkIndexExists(schemaTable, (String[])idx_fields)) {
                                    String indexname = "idx_" + this.tableName + "_tk";
                                    sql = sql + db.getCreateIndexStatement(schemaTable, indexname, (String[])idx_fields, true, false, true, true);
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.TechnicalKeyFieldRequired", (String[])new String[0]));
                            }
                            if (CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) && !Utils.isEmpty((CharSequence)this.sequenceName) && !db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                                sql = sql + db.getCreateSequenceStatement(this.schemaName, this.sequenceName, 1L, 1L, -1L, true);
                            }
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                            }
                            retval.setSQL(transMeta.environmentSubstitute(sql));
                        }
                        catch (KettleDatabaseException dbe) {
                            retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + dbe.getMessage());
                        }
                        finally {
                            db.disconnect();
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoConnectionDefiendInStep", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) {
        block6: {
            if (prev == null) break block6;
            if (!this.update) {
                DatabaseImpact ii;
                ValueMetaInterface v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValueMeta(this.keyStream[i]);
                    ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValueMeta(this.fieldStream[i]);
                    ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v == null ? "" : (v != null ? v.getOrigin() : "?"), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            } else {
                DatabaseImpact ii;
                ValueMetaInterface v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValueMeta(this.keyStream[i]);
                    ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v == null ? "" : v.getOrigin(), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValueMeta(this.fieldStream[i]);
                    ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v == null ? "" : v.getOrigin(), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DimensionLookup(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DimensionLookupData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isUsingStartDateAlternative() {
        return this.usingStartDateAlternative;
    }

    public void setUsingStartDateAlternative(boolean usingStartDateAlternative) {
        this.usingStartDateAlternative = usingStartDateAlternative;
    }

    public int getStartDateAlternative() {
        return this.startDateAlternative;
    }

    public void setStartDateAlternative(int startDateAlternative) {
        this.startDateAlternative = startDateAlternative;
    }

    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    public void setStartDateFieldName(String startDateFieldName) {
        this.startDateFieldName = startDateFieldName;
    }

    public boolean isPreloadingCache() {
        return this.preloadingCache;
    }

    public void setPreloadingCache(boolean preloadingCache) {
        this.preloadingCache = preloadingCache;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    protected RowMetaInterface getDatabaseTableFields(Database db, String schemaName, String tableName) throws KettleDatabaseException {
        RowMetaInterface extraFields = db.getTableFieldsMeta(schemaName, tableName);
        if (extraFields == null) {
            db.connect();
            extraFields = db.getTableFieldsMeta(schemaName, tableName);
        }
        return extraFields;
    }

    Database createDatabaseObject() {
        return new Database(loggingObject, this.databaseMeta);
    }

    @Override
    public RowMeta getRowMeta(StepDataInterface stepData) {
        try {
            return (RowMeta)this.getDatabaseTableFields(this.createDatabaseObject(), this.schemaName, this.tableName);
        }
        catch (KettleDatabaseException e) {
            this.log.logError("", (Throwable)e);
            return new RowMeta();
        }
    }

    @Override
    public List<String> getDatabaseFields() {
        ArrayList<String> fields = new ArrayList<String>(this.fieldLookup.length + this.keyLookup.length);
        fields.addAll(Arrays.asList(this.fieldLookup));
        fields.addAll(Arrays.asList(this.keyLookup));
        return fields;
    }

    @Override
    public List<String> getStreamFields() {
        ArrayList<String> fields = new ArrayList<String>(this.fieldLookup.length + this.keyLookup.length);
        fields.addAll(Arrays.asList(this.fieldStream));
        fields.addAll(Arrays.asList(this.keyStream));
        return fields;
    }

    public void normalizeAllocationFields() {
        if (this.keyLookup != null) {
            int keysGroupSize = this.keyLookup.length;
            this.keyStream = this.normalizeAllocation(this.keyStream, keysGroupSize);
        }
        if (this.fieldLookup != null) {
            int fieldsGroupSize = this.fieldLookup.length;
            this.fieldStream = this.normalizeAllocation(this.fieldStream, fieldsGroupSize);
            this.fieldUpdate = this.normalizeAllocation(this.fieldUpdate, fieldsGroupSize);
            this.returnType = this.normalizeAllocation(this.returnType, fieldsGroupSize);
        }
    }

    private String[] normalizeAllocation(String[] oldAllocation, int length) {
        String[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new String[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    private int[] normalizeAllocation(int[] oldAllocation, int length) {
        int[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new int[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int nrStream;
        int n = nrStream = this.keyStream == null ? -1 : this.keyStream.length;
        if (nrStream > 0) {
            String[][] rtn = Utils.normalizeArrays((int)nrStream, (String[][])new String[][]{this.keyLookup});
            this.keyLookup = rtn[0];
        }
        int n2 = nrFields = this.fieldStream == null ? -1 : this.fieldStream.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtnFieldLookup = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.fieldLookup});
        this.fieldLookup = rtnFieldLookup[0];
        int[][] rtnFieldUpdate = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.fieldUpdate});
        this.fieldUpdate = rtnFieldUpdate[0];
    }

    public static class ReturnTypeCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws KettleValueException {
            return DimensionLookupMeta.getUpdateType(false, v);
        }
    }

    public static class UpdateTypeCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws KettleValueException {
            return DimensionLookupMeta.getUpdateType(true, v);
        }
    }

    public static class StartDateCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws KettleValueException {
            return DimensionLookupMeta.getStartDateAlternative(v);
        }
    }
}

