/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.errorhandling;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;

public abstract class AbstractFileErrorHandler
implements FileErrorHandler {
    private static Class<?> PKG = AbstractFileErrorHandler.class;
    private static final String DD_MMYYYY_HHMMSS = "ddMMyyyy-HHmmss";
    public static final String NO_PARTS = "NO_PARTS";
    private final String destinationDirectory;
    private final String fileExtension;
    private final String encoding;
    private String processingFilename;
    private Map<Object, Writer> writers;
    private String dateString;
    private BaseStep baseStep;

    public AbstractFileErrorHandler(Date date, String destinationDirectory, String fileExtension, String encoding, BaseStep baseStep) {
        this.destinationDirectory = destinationDirectory;
        this.fileExtension = fileExtension;
        this.encoding = encoding;
        this.baseStep = baseStep;
        this.writers = new HashMap<Object, Writer>();
        this.initDateFormatter(date);
    }

    private void initDateFormatter(Date date) {
        this.dateString = AbstractFileErrorHandler.createDateFormat().format(date);
    }

    public static DateFormat createDateFormat() {
        return new SimpleDateFormat(DD_MMYYYY_HHMMSS);
    }

    public static FileObject getReplayFilename(String destinationDirectory, String processingFilename, String dateString, String extension, Object source) throws KettleFileException {
        String name = null;
        String sourceAdding = "";
        if (!NO_PARTS.equals(source)) {
            sourceAdding = "_" + source.toString();
        }
        name = extension == null || extension.length() == 0 ? processingFilename + sourceAdding + "." + dateString : processingFilename + sourceAdding + "." + dateString + "." + extension;
        return KettleVFS.getFileObject((String)(destinationDirectory + "/" + name));
    }

    public static FileObject getReplayFilename(String destinationDirectory, String processingFilename, Date date, String extension, Object source) throws KettleFileException {
        return AbstractFileErrorHandler.getReplayFilename(destinationDirectory, processingFilename, AbstractFileErrorHandler.createDateFormat().format(date), extension, source);
    }

    Writer getWriter(Object source) throws KettleException {
        try {
            Writer outputStreamWriter = this.writers.get(source);
            if (outputStreamWriter != null) {
                return outputStreamWriter;
            }
            FileObject file = AbstractFileErrorHandler.getReplayFilename(this.destinationDirectory, this.processingFilename, this.dateString, this.fileExtension, source);
            ResultFile resultFile = new ResultFile(0, file, this.baseStep.getTransMeta().getName(), this.baseStep.getStepname());
            this.baseStep.addResultFile(resultFile);
            try {
                outputStreamWriter = StringUtils.isBlank((String)this.encoding) ? new OutputStreamWriter(KettleVFS.getOutputStream((FileObject)file, (boolean)false)) : new OutputStreamWriter(KettleVFS.getOutputStream((FileObject)file, (boolean)false), this.encoding);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCreateFileErrorHandlerForFile", (String[])new String[0]) + file.getName().getURI(), (Throwable)e);
            }
            this.writers.put(source, outputStreamWriter);
            return outputStreamWriter;
        }
        catch (KettleFileException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCreateFileErrorHandlerForFile", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void close() throws KettleException {
        Iterator<Writer> iter = this.writers.values().iterator();
        while (iter.hasNext()) {
            this.close(iter.next());
        }
        this.writers = new HashMap<Object, Writer>();
    }

    private void close(Writer outputStreamWriter) throws KettleException {
        if (outputStreamWriter != null) {
            try {
                outputStreamWriter.flush();
            }
            catch (IOException exception) {
                this.baseStep.logError(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Log.CouldNotFlushContentToFile", (String[])new String[0]), exception.getLocalizedMessage());
            }
            try {
                outputStreamWriter.close();
            }
            catch (IOException exception) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCloseFile", (String[])new String[0]), (Throwable)exception);
            }
            finally {
                outputStreamWriter = null;
            }
        }
    }

    @Override
    public void handleFile(FileObject file) throws KettleException {
        this.close();
        this.processingFilename = file.getName().getBaseName();
    }
}

